#include <stdio.h>
#include "allegro.h"
#include <aldumb.h>
#include "string.h"
#include "music.h"
#include "sprite.h"
#include "input.h"
#include "pmain.h"
#include "npk.h"
#include "pack.h"
#include "gmenu.h"
#include "menu.h"
#include "encrypt.h"
//Pong Stuff.
int map_number_chosen;
//Menu Stuff
int set_slide_on(void);
int set_fps_on(void);
int set_joystickm(void);
int set_new_controls(void);
int setup_controls_text(void);
int show_credits(void);
int reset_positions_pong(void);
int set_up_num_balls(void);
int set_up_levels(void);
int start_new_level(void);
int play_game_menu(void);
int pre_start_new_level(void);
int set_up_player(void);
int set_up_user(void);
int set_up_song(void);
int set_sound_menu(void);
int set_music_menu(void);
int set_sound_texts(void);
int mset_sound_vol(void);
int mset_music_vol(void);
int set_up_game_text(void);
int set_up_game_mode(void);
int set_up_score_text(void);
int set_up_score_mode(void);
int set_default_controls(void);
//Game Stuff
int set_exit_game(void);
G_MENUP *menup_pong;
//Okay, Lets Test this
G_MENU menu_main[] =
{
/*   Text,  Pressed, Num Extra, ExtraText,Next Menu,  Function To  Call,Flags void*dp,Back*/
   { "Play Game",0,    0,        "",      menu_level,   set_up_levels, 0, NULL,NULL  },
   { "Options",  0,    0,        "",      menu_options,       NULL, 0, NULL,NULL  },
   { "Credits",  0,    0,        "",      NULL,       show_credits, 0, NULL,NULL  },
   { "Exit",     0,    0,        "",      NULL,       NULL, D_EXIT, NULL,NULL  },
   { "",       0,    0,        NULL,    NULL,       NULL, 0, NULL,NULL  }
};
G_MENU menu_controls[] =
{
/*   Text,  Pressed, Num Extra, ExtraText,Next Menu,  Function To  Call,Flags void*dp,Back*/
   { "User 1",0,    0,        "",         NULL,   setup_controls_text, 0, NULL,NULL  },
   { "Keyboard",  0,    0,        "",      NULL,       set_joystickm, 0, NULL,NULL  },
   { "Change Keys",  0,    0,        "",      NULL,       set_new_controls, 0, NULL,NULL  },
//   { "Calibrate Joystick", 0, 0, "",      NULL,       NULL, D_DISABLED, NULL,NULL  },
   { "Up",  0,    0,        "",      NULL,       NULL, D_DISABLED, NULL,NULL  },
   { "Down",  0,    0,        "",      NULL,       NULL, D_DISABLED, NULL,NULL  },
   { "Left",  0,    0,        "",      NULL,       NULL, D_DISABLED, NULL,NULL  },
   { "Right",  0,    0,        "",      NULL,       NULL, D_DISABLED, NULL,NULL  },
   { "Restore Defaults",  0,    0,        "",      NULL,  set_default_controls, 0, NULL,NULL  },
   { "Back",     0,    0,        "",      NULL,       NULL, D_BACK, NULL,NULL  },
   { "",       0,    0,        NULL,    NULL,       NULL, 0, NULL,NULL  }
};

G_MENU menu_esc[] =
{
/*   Text,  Pressed, Num Extra, ExtraText,Next Menu,  Function To  Call,Flags void*dp,Back*/
   { "Return",0,    0,        "",      NULL,       NULL, D_EXIT, NULL,NULL  },
   { "Sound Vol",  0,    0,        "",      NULL,       mset_sound_vol, 0, NULL,NULL  },
   { "Music Vol",  0,    0,        "",      NULL,       mset_music_vol,0, NULL,NULL  },
   { "Song Setup",  0,    0,        "",      menu_music,      set_up_song, 0, NULL,NULL  },
   { "Exit Game",     0,    0,        "",      NULL,       set_exit_game, D_EXIT, NULL,NULL  },
   { "",       0,    0,        NULL,    NULL,       NULL, NULL, NULL,NULL  }
};
G_MENU menu_options[] =
{
/*   Text,  Pressed, Num Extra, ExtraText,Next Menu,  Function To  Call,Flags void*dp,Back*/
   { "Configure Controls",0,    0,        "",      menu_controls,       setup_controls_text, 0, NULL,NULL  },
   { "Sound Vol Loud",  0,    1,        "",      NULL,       mset_sound_vol, 0, NULL,NULL  },
   { "Music Vol Loud",  0,    1,        "",      NULL,       mset_music_vol,0, NULL,NULL  },
   { "Sound On",  0,    1,        "",      NULL,       set_sound_menu, 0, NULL,NULL  },
   { "Music On",  0,    1,        "",      NULL,       set_music_menu, 0, NULL,NULL  },
   { "Song Setup",  0,    0,        "",      menu_music,       set_up_song, 0, NULL,NULL  },
   { "Sliding ON",  0,    0,        "",      NULL,       set_slide_on, 0, NULL,NULL  },
   { "Show FPS OFF",  0,    0,        "",      NULL,       set_fps_on, 0, NULL,NULL  },
   { "Back",     0,    0,        "",      NULL,       NULL, D_BACK, NULL,NULL  },
   { "",       0,    0,        NULL,    NULL,       NULL, NULL, NULL,NULL  }
};


G_MENU menu_level[] =
{
/*   Text,  Pressed, Num Extra, ExtraText,Next Menu,  Function To  Call,Flags void*dp,Back*/
   { "Packfile Name",0,    0,        "",      NULL,       set_up_levels, 0, NULL,NULL  },
   { "Level 1",  0,    0,        "",      menu_selected,       start_new_level, 0, NULL,NULL  },
   { "Level 2",  0,    0,        "",      menu_selected,       start_new_level,0, NULL,NULL  },
   { "Level 3",  0,    0,        "",      menu_selected,       start_new_level, 0, NULL,NULL  },
   { "Level 4",     0,    0,        "",      menu_selected,       start_new_level, 0, NULL,NULL  },
   { "Level 5",     0,    0,        "",      menu_selected,       start_new_level, 0, NULL,NULL  },
   { "Level 6",     0,    0,        "",      menu_selected,       start_new_level, 0, NULL,NULL  },
   { "Level 7",     0,    0,        "",      menu_selected,       start_new_level, 0, NULL,NULL  },
   { "Level 8",     0,    0,        "",      menu_selected,       start_new_level, 0, NULL,NULL  },
   { "Level 9",     0,    0,        "",      menu_selected,       start_new_level, 0, NULL,NULL  },
   { "Level 10",     0,    0,        "",      menu_selected,      start_new_level , 0, NULL,NULL  },
   { "Back",     0,    0,        "",      NULL,       NULL, D_BACK, NULL,NULL  },
   { "",       0,    0,        NULL,    NULL,       NULL, 0, NULL,NULL  }
};
G_MENU menu_music[] =
{
/*   Text,  Pressed, Num Extra, ExtraText,Next Menu,  Function To  Call,Flags void*dp,Back*/
   { "",0,    1,          "Bob The Builder",      NULL,       set_up_song, 0, NULL,NULL  },
   { "",  0,    1,        "Footsteps",      NULL,       set_up_song, 0, NULL,NULL  },
   { "",  0,    1,        "Untitled",      NULL,       set_up_song,0, NULL,NULL  },
   { "",  0,    1,        "I Cant Fly",      NULL,       set_up_song, 0, NULL,NULL  },
   { "",     0,    1,     "Chant For Sweat",     NULL,       set_up_song, 0, NULL,NULL  },
   { "",     0,    1,        "Euro Trash",      NULL,       set_up_song, 0, NULL,NULL  },
   { "",     0,    1,        "Maybe",      NULL,       set_up_song, 0, NULL,NULL  },
   { "",     0,    1,        "My Swing Arm",      NULL,       set_up_song, 0, NULL,NULL  },
   { "Back",     0,    0,        "",      NULL,       NULL, D_BACK, NULL,NULL  },
   { "",       0,    0,        NULL,    NULL,       NULL, 0, NULL,NULL  }
};

G_MENU menu_selected[] =
{
/*   Text,  Pressed, Num Extra, ExtraText,Next Menu,  Function To  Call,Flags void*dp,Back*/
   { "Player 1 Human",0,    1,        "",      NULL,       set_up_player, 0, NULL,NULL  },
   { "User 1",  0,    1,        "",      NULL,       set_up_user, 0, NULL,NULL  },
   { "Player 2 Computer",  0,    2,        "",      NULL,     set_up_player,0, NULL,NULL  },
   { "Easy",  0,    1,        "",      NULL,       set_up_user, 0, NULL,NULL  },
   { "Player 3 Human",     0,    1,        "",      NULL,  set_up_player, 0, NULL,NULL  },
   { "User 3",     0,    3,        "",      NULL,       set_up_user, 0, NULL,NULL  },
   { "Player 4 Computer",     0,    2,   "",NULL,      set_up_player, 0, NULL,NULL  },
   { "Easy",     0,    1,        "",      NULL,       set_up_user, 0, NULL,NULL  },
   { "Number of Balls 1",     0,    1,        "",      NULL,     set_up_num_balls, 0, NULL,NULL  },
   { "Limit Type Points 10",     0,    1,        "",      NULL,   set_up_score_mode, 0, NULL,NULL  },
   { "Game Type 2v2",     0,    1,        "",      NULL,     set_up_game_mode , 0, NULL,NULL  },
   { "Play",     0,    0,        "",      NULL,       play_game_menu,0, NULL,NULL  },
   { "Back",     0,    0,        "",      NULL,       NULL, D_BACK, NULL,NULL  },
   { "",       0,    0,        NULL,    NULL,       NULL, 0, NULL,NULL  }
};

//Sets Up default controls:
int set_default_controls(void)
{
paddle_input[0].input = 1;
paddle_input[0].right_flag = KEY_RIGHT;
paddle_input[0].left_flag = KEY_LEFT;
paddle_input[0].down_flag = KEY_DOWN;
paddle_input[0].up_flag = KEY_UP;
//Player 2
paddle_input[1].input = 1;
paddle_input[1].right_flag = KEY_D;
paddle_input[1].left_flag = KEY_A;
paddle_input[1].down_flag = KEY_S;
paddle_input[1].up_flag = KEY_W;
//Player 3
paddle_input[2].input = 1;
paddle_input[2].right_flag = KEY_L;
paddle_input[2].left_flag = KEY_J;
paddle_input[2].down_flag = KEY_I;
paddle_input[2].up_flag = KEY_K;
//Player 4
paddle_input[3].input = 1;
paddle_input[3].right_flag = KEY_6_PAD;
paddle_input[3].left_flag = KEY_4_PAD;
paddle_input[3].down_flag = KEY_5_PAD;
paddle_input[3].up_flag = KEY_8_PAD;
gmenu_message_alert(screen,"Default Keys Restored",100, 220,1, 221);
wait_for_key(5);
return 0;
}
//Updates Menu Look And Settings
int set_slide_on(void)
{
menu_options[6].num_extra = !menu_options[6].num_extra;
if(!menu_options[6].num_extra)
 {
 strcpy(menu_options[6].text,"Sliding ON");
 paddle_no_slide = 0;
 }
else
 {
 strcpy(menu_options[6].text,"Sliding OFF");
 paddle_no_slide = 1;
 }
return 0;
}

int set_fps_on(void)
{
menu_options[7].num_extra = !menu_options[7].num_extra;
if(menu_options[7].num_extra)
 strcpy(menu_options[7].text,"Show FPS ON");
else
 strcpy(menu_options[7].text,"Show FPS OFF");
return 0;
}
int set_up_levels(void)
{
int index;
//First we get the next packfile in order
if(!current->next)
 current = npkl.next;
else
 current = current->next;
//Give the title a title
strcpy(menu_level[0].text,current->filename);
for(index=0;index <10;index++)
{
if(index<current->num_maps)
 {
 strcpy(menu_level[index+1].text,current->map_name[index]);
 if(current->npk_type && index > 0)
    {
    if(current->map_status[index])
    menu_level[index+1].flags = 0;
    else
    menu_level[index+1].flags = D_DISABLED;
    }
 else
  menu_level[index+1].flags = 0;
 }
else
 menu_level[index+1].flags = D_HIDDEN;
}
return 0;
}
int start_new_level(void)
{
if((open_packfile_read(current->filename_pak)))
 {
 allegro_message("Error, Could Not Open Packfile\n");
 exit(1);
 }
load_map_packfile(menup_pong->selected - 1);
map_number_chosen = menup_pong->selected -1;
close_packfile();
pre_start_new_level();
return 0;
}

int set_up_player(void)
{
int index;
//This is becuase set up player is also called to initalize stuff
if(game_active_menu == menu_selected)
  {
   if(menu_selected[menup_pong->selected].num_extra == 1) //Human to Comp
      {
      sprintf(menu_selected[menup_pong->selected].text, "Player %d Computer", (menup_pong->selected / 2) + 1);
      strcpy(menu_selected[menup_pong->selected +1].text, "Easy");
      menu_selected[menup_pong->selected +1].num_extra = 1; //Changes To Easy Setting
      menu_selected[menup_pong->selected].num_extra = 2; //Human to Comp
      }
   else if(menu_selected[menup_pong->selected].num_extra == 2) //Comp to Human
      {
      sprintf(menu_selected[menup_pong->selected].text, "Player %d Human", (menup_pong->selected / 2) + 1);
      sprintf(menu_selected[menup_pong->selected + 1].text, "User %d", (menup_pong->selected / 2) + 1);
      menu_selected[menup_pong->selected +1].num_extra = (menup_pong->selected / 2) + 1;
      menu_selected[menup_pong->selected].num_extra = 1; //Comp to Human
      }
  }
paddle[0].user =  menu_selected[0].num_extra;
paddle[1].user =  menu_selected[2].num_extra;
paddle[2].user =  menu_selected[4].num_extra;
paddle[3].user =  menu_selected[6].num_extra;
paddle[0].user_type =  menu_selected[1].num_extra;
paddle[1].user_type =  menu_selected[3].num_extra;
paddle[2].user_type =  menu_selected[5].num_extra;
paddle[3].user_type =  menu_selected[7].num_extra;

//Disable Enable Certain Options
if(map.map_type ==1)
 {
 for(index = 4;index <8;index++)
   menu_selected[index].flags = D_DISABLED;
 }
if(map.map_type ==2)
 {
  for(index = 0;index <8;index++)
   menu_selected[index].flags = 0;

 }

return 0;
}
int set_joystickm(void)
{
if(game_active_menu == menu_controls)
{
if(menup_pong->selected ==1)
{
if(menu_controls[1].num_extra && paddle_input[menu_controls[0].num_extra].input ==2)
  {
  menu_controls[1].num_extra = 0;
  paddle_input[menu_controls[0].num_extra].input =1;
  }
else if(menu_controls[1].num_extra)
  {
  gmenu_message_alert(screen,"Joystick Already in Use",100, 220,1, 221);
  rest(1000);
  }
else
 {
  menu_controls[1].num_extra = 1;
  paddle_input[menu_controls[0].num_extra].input =2;

 }
}
}
if(paddle_input[menu_controls[0].num_extra].input ==2 )
 sprintf(menu_controls[1].text, "Joystick");
else
 sprintf(menu_controls[1].text, "Keyboard");
return 0;
}

int set_new_controls(void)
{
blit(screen_pic,screen,0,0,0,0,double_buffer->w,double_buffer->h);
gmenu_message_alert(screen,"Press Up Key",200, 220,1, 221);
clear_keybuf();
while(!keypressed()){play_music(song);}
paddle_input[menu_controls[0].num_extra].up_flag = readkey() >>8;
blit(screen_pic,screen,0,0,0,0,double_buffer->w,double_buffer->h);
gmenu_message_alert(screen,"Press Down Key",200, 220,1, 221);
clear_keybuf();
while(!keypressed()){play_music(song);}
paddle_input[menu_controls[0].num_extra].down_flag = readkey() >>8;
blit(screen_pic,screen,0,0,0,0,double_buffer->w,double_buffer->h);
gmenu_message_alert(screen,"Press Left Key",200, 220,1, 221);
clear_keybuf();
while(!keypressed()){play_music(song);}
paddle_input[menu_controls[0].num_extra].left_flag = readkey() >>8;
blit(screen_pic,screen,0,0,0,0,double_buffer->w,double_buffer->h);
gmenu_message_alert(screen,"Press Right Key",200, 220,1, 221);
clear_keybuf();
while(!keypressed()){play_music(song);}
paddle_input[menu_controls[0].num_extra].right_flag = readkey() >>8;
setup_controls_text();
return 0;
}
//Sets Up User Controls
int setup_controls_text(void)
{
if(game_active_menu == menu_controls)
{

//  menu_selected[menup_pong->selected].num_extra+= 1;
 if(menup_pong->selected == 0)
     {
    menu_controls[menup_pong->selected].num_extra+= 1;
     if(menu_controls[menup_pong->selected].num_extra > 3)
        menu_controls[menup_pong->selected].num_extra = 0;
     }

}
sprintf(menu_controls[0].text, "User %d",menu_controls[menup_pong->selected].num_extra+1);
sprintf(menu_controls[3].text, "Up %c",scancode_to_ascii(paddle_input[menu_controls[0].num_extra].up_flag));
sprintf(menu_controls[4].text, "Down %c",scancode_to_ascii(paddle_input[menu_controls[0].num_extra].down_flag));
sprintf(menu_controls[5].text, "Left %c",scancode_to_ascii(paddle_input[menu_controls[0].num_extra].left_flag));
sprintf(menu_controls[6].text, "Right %c",scancode_to_ascii(paddle_input[menu_controls[0].num_extra].right_flag));
set_joystickm();
return 0;
}

int set_up_game_text(void)
{
//if(current->map_type[menup_pong->selected -1] == 2)
//menu_selected = 10.
if(map.map_type == 1)
  {
   if(menu_selected[10].num_extra == 0)
    {
    strcpy (menu_selected[10].text, "For Score");
    for_score = 1;
  menu_selected[0].flags = D_ENABLED;
  menu_selected[1].flags = D_ENABLED;
  menu_selected[2].flags = D_DISABLED;
  menu_selected[3].flags = D_DISABLED;
  menu_selected[4].flags = D_DISABLED;
  menu_selected[5].flags = D_DISABLED;
  menu_selected[6].flags = D_DISABLED;
  menu_selected[7].flags = D_DISABLED;
  menu_selected[9].flags = D_DISABLED;
     }
   else if(menu_selected[10].num_extra == 1)
    {
     menu_selected[0].flags = D_ENABLED;
  menu_selected[1].flags = D_ENABLED;
  menu_selected[2].flags = D_ENABLED;
  menu_selected[3].flags = D_ENABLED;
  menu_selected[4].flags = D_DISABLED;
  menu_selected[5].flags = D_DISABLED;
  menu_selected[6].flags = D_DISABLED;
  menu_selected[7].flags = D_DISABLED;
  menu_selected[9].flags = D_ENABLED;
    strcpy (menu_selected[10].text, "1 vs 1");
    for_score = 0;

    }
  }
else if(map.map_type == 2)
  {
    if(menu_selected[10].num_extra == 0)
    {
        for_score = 1;
  menu_selected[0].flags = D_ENABLED;
  menu_selected[1].flags = D_ENABLED;
  menu_selected[2].flags = D_DISABLED;
  menu_selected[3].flags = D_DISABLED;
  menu_selected[4].flags = D_DISABLED;
  menu_selected[5].flags = D_DISABLED;
  menu_selected[6].flags = D_DISABLED;
  menu_selected[7].flags = D_DISABLED;
  menu_selected[9].flags = D_DISABLED;
    strcpy (menu_selected[10].text, "For Score");
    game_type = 0;
    }
   else if(menu_selected[10].num_extra == 1)
    {
    strcpy (menu_selected[10].text, "2 vs 2");
        for_score = 0;
  menu_selected[0].flags = D_ENABLED;
  menu_selected[1].flags = D_ENABLED;
  menu_selected[2].flags = D_ENABLED;
  menu_selected[3].flags = D_ENABLED;
  menu_selected[4].flags = D_ENABLED;
  menu_selected[5].flags = D_ENABLED;
  menu_selected[6].flags = D_ENABLED;
  menu_selected[7].flags = D_ENABLED;
  menu_selected[9].flags = D_ENABLED;
    game_type = 0;
    }
   else if(menu_selected[10].num_extra == 2)
    {
    strcpy (menu_selected[10].text, "3 vs 1");
    game_type = 3;
    }
  }
else if(map.map_type == 3)
  {
  menu_selected[10].num_extra = 0;
  strcpy (menu_selected[10].text, "For Score");
  }
return 0;
}

int set_up_game_mode(void)
{
if(game_active_menu == menu_selected)
{
if(map.map_type == 1)
  {
   menu_selected[10].num_extra++;
   if(menu_selected[10].num_extra > 1)
    menu_selected[10].num_extra = 0;
  }
else if(map.map_type == 2)
  {
   menu_selected[10].num_extra ++;
    if(menu_selected[10].num_extra > 2)
   menu_selected[10].num_extra  = 0;
  }
else if(map.map_type == 3)
  {
  menu_selected[10].num_extra = 0;
  }
}
set_up_game_text();
return 0;
}
int set_up_score_text(void)
{
//I can cut down code by 10+ lines, doing score_mode = menu_selected[9].num_extra
//At beggining or end
   if(menu_selected[9].num_extra == 0)
    {
    strcpy (menu_selected[9].text, "Limit Type Points 5");
     score_mode = 0;
     }
   else if(menu_selected[9].num_extra == 1)
    {
    strcpy (menu_selected[9].text, "Limit Type Points 10");
     score_mode = 1;
    }
   else if(menu_selected[9].num_extra == 2)
    {
    strcpy (menu_selected[9].text, "Limit Type Points 15");
     score_mode = 2;
    }
   else if(menu_selected[9].num_extra == 3)
    {
    strcpy (menu_selected[9].text, "Limit Type Time 60s");
     score_mode = 3;
    }
   else if(menu_selected[9].num_extra == 4)
    {
    strcpy (menu_selected[9].text, "Limit Type Time 120s");
     score_mode = 4;
    }
   else if(menu_selected[9].num_extra == 5)
    {
    strcpy (menu_selected[9].text, "Limit Type Time 180s");
    score_mode = 5;
    }

return 0;
}

int set_up_score_mode(void)
{
if(game_active_menu == menu_selected)
{
   menu_selected[9].num_extra++;
  if(menu_selected[9].num_extra > 5)
    menu_selected[9].num_extra = 0;
}
set_up_score_text();
return 0;
}

int set_up_user(void)
{
if(game_active_menu == menu_selected)
{
  menu_selected[menup_pong->selected].num_extra+= 1;
    if(menu_selected[menup_pong->selected-1].num_extra == 1)
     {
     if(menu_selected[menup_pong->selected].num_extra > 4)
        menu_selected[menup_pong->selected].num_extra = 1;
     sprintf(menu_selected[menup_pong->selected].text, "User %d", menu_selected[menup_pong->selected].num_extra);
     }
    if(menu_selected[menup_pong->selected-1].num_extra == 2)
     {
     if(menu_selected[menup_pong->selected].num_extra > 3)
        menu_selected[menup_pong->selected].num_extra = 1;
     switch (menu_selected[menup_pong->selected].num_extra)
     {
     case 1:
     strcpy(menu_selected[menup_pong->selected].text, "Easy");
     break;
     case 2:
     strcpy(menu_selected[menup_pong->selected].text, "Normal");
     break;
     case 3:
     strcpy(menu_selected[menup_pong->selected].text, "Hard");
     break;
     }
    }
}
paddle[0].user_type =  menu_selected[1].num_extra;
paddle[1].user_type =  menu_selected[3].num_extra;
paddle[2].user_type =  menu_selected[5].num_extra;
paddle[3].user_type =  menu_selected[7].num_extra;
//Forced, No choice here, stupid me
paddle[0].type =  1;
paddle[1].type =  1;
paddle[2].type =  2;
paddle[3].type =  2;


return 0;

}
//Sets Everything Back To Normal

//This sub seems unnecisary
int pre_start_new_level(void)
{
menu_selected[10].num_extra = 1;  //This is a stupid hack by me,
                                  //That Makes it so game_mode is reset
                                  //And for score == 0.
for_score = 0; //Make Off By Default
game_type = 0; //Off By Default, only used for 3vs1
reset_positions_pong();
set_sound_texts();
set_up_player();
set_up_user();
set_up_num_balls();
set_up_song();
set_up_game_mode();
set_up_score_mode();
//4 Player Map
if(map.map_type ==2)
  {
  menu_selected[0].flags = D_ENABLED;
  menu_selected[1].flags = D_ENABLED;
  menu_selected[2].flags = D_ENABLED;
  menu_selected[3].flags = D_ENABLED;
  menu_selected[4].flags = D_ENABLED;
  menu_selected[5].flags = D_ENABLED;
  menu_selected[6].flags = D_ENABLED;
  menu_selected[7].flags = D_ENABLED;
  menu_selected[9].flags = D_ENABLED;
  }
//Map Type 1
else if(map.map_type == 1)
  {
  menu_selected[0].flags = D_ENABLED;
  menu_selected[1].flags = D_ENABLED;
  menu_selected[2].flags = D_ENABLED;
  menu_selected[3].flags = D_ENABLED;
  menu_selected[4].flags = D_DISABLED;
  menu_selected[5].flags = D_DISABLED;
  menu_selected[6].flags = D_DISABLED;
  menu_selected[7].flags = D_DISABLED;
  menu_selected[9].flags = D_ENABLED;
  }
else if(map.map_type == 3)
  {
  menu_selected[0].flags = D_ENABLED;
  menu_selected[1].flags = D_ENABLED;
  menu_selected[2].flags = D_DISABLED;
  menu_selected[3].flags = D_DISABLED;
  menu_selected[4].flags = D_DISABLED;
  menu_selected[5].flags = D_DISABLED;
  menu_selected[6].flags = D_DISABLED;
  menu_selected[7].flags = D_DISABLED;
  menu_selected[9].flags = D_DISABLED;
  }

return 0;
}
int reset_positions_pong(void)
{
//Scores
score1 = 0;
score2 = 0;

//Left Paddle
paddle[0].image.x =0;
paddle[0].image.y =242;
//Right Paddle
paddle[1].image.x =620;
paddle[1].image.y =242;
//Top Paddle
paddle[2].image.x =290;
paddle[2].image.y =64;
//Bottom Paddle
paddle[3].image.x =290;
paddle[3].image.y =460;
paddle[0].image.oldx = paddle[0].image.x;
paddle[0].image.oldy = paddle[0].image.y;
paddle[1].image.oldx = paddle[1].image.x;
paddle[1].image.oldy = paddle[1].image.y;
paddle[2].image.oldx = paddle[2].image.x;
paddle[2].image.oldy = paddle[2].image.y;
paddle[3].image.oldx = paddle[3].image.x;
paddle[3].image.oldy = paddle[3].image.y;
//Ball Starting Locations
ball[0].image.x = 312;
ball[0].image.y = 264;
ball[1].image.x = 312;
ball[1].image.y = 264;
ball[2].image.x = 312;
ball[2].image.y = 264;
ball[3].image.x = 312;
ball[3].image.y = 264;
//Ball Starting Velocities
ball[0].image.vx = 88;
ball[0].image.vy = 55;
ball[1].image.vx = -88;
ball[1].image.vy = -55;
ball[2].image.vx = 88;
ball[2].image.vy = -55;
ball[3].image.vx = -88;
ball[3].image.vy = 55;
ball[3].image.oldx = ball[3].image.x;
ball[3].image.oldy = ball[3].image.y;
ball[2].image.oldx = ball[2].image.x;
ball[2].image.oldy = ball[2].image.y;
ball[1].image.oldx = ball[1].image.x;
ball[1].image.oldy = ball[1].image.y;
ball[0].image.oldx = ball[0].image.x;
ball[0].image.oldy = ball[0].image.y;

return 0;
}
int set_up_num_balls(void)
{
if(game_active_menu == menu_selected)
 {
 menu_selected[menup_pong->selected].num_extra+=1;
 if(menu_selected[menup_pong->selected].num_extra > 4)
   menu_selected[menup_pong->selected].num_extra = 1;
 sprintf(menu_selected[menup_pong->selected].text, "Number of Balls %d",menu_selected[menup_pong->selected].num_extra);
 }
balls_used = menu_selected[8].num_extra;
return 0;
}

int play_game_menu(void)
{
start_game = 1; //Let the pong match begin
return D_EXIT;
return 0;
}
int set_exit_game(void)
{
exit_int = 1;
return D_EXIT;
}
int set_up_song(void)
{
int index;
//This is becuase set up player is also called to initalize stuff
if(game_active_menu == menu_music)
  {
   if(menu_music[menup_pong->selected].num_extra == 1) //OFF
      {
       if(songs[menup_pong->selected].flags == SONG_ON)
         {
         stop_music(song);
         song->flags = SONG_DISABLED;
         menu_music[menup_pong->selected].num_extra = 0;
         songs_used--;
         song = &songs[random_song()];
         play_music(song);
         }
       else
         {
         stop_music(song);
         song = &songs[menup_pong->selected];
         song->flags = SONG_OFF;
         play_music(song);
         }
      }
   else if(menu_music[menup_pong->selected].num_extra == 0) //ON
      {
         songs_used++;
         stop_music(song);
         song = &songs[menup_pong->selected];
         song->flags = SONG_OFF;
         play_music(song);
         menu_music[menup_pong->selected].num_extra = 1;
      }
  }
for(index = 0;index < 8;index++)
{
if(menu_music[index].num_extra == 1)
sprintf(menu_music[index].text, "%s ON", menu_music[index].t_extra);
else
sprintf(menu_music[index].text, "%s OFF", menu_music[index].t_extra);
}
return 0;
}

int set_sound_menu(void)
{
if(sound_disabled)
 {
 menu_options[3].num_extra = 1;
 menu_options[4].num_extra = 1;
 sound_on = 0;
 music_on = 0;
 }
if(menu_options[3].num_extra == 1)
{
menu_options[3].num_extra = 0;
strcpy(menu_options[3].text, "Sound Off");
sound_on = 0;
}
else if(menu_options[3].num_extra == 0)
{
menu_options[3].num_extra = 1;
strcpy(menu_options[3].text, "Sound On");
sound_on = 1;
}
set_sound_texts();
return 0;
}
int set_music_menu(void)
{
if(sound_disabled)
 {
 menu_options[3].num_extra = 1;
 menu_options[4].num_extra = 1;
 sound_on = 0;
 music_on = 0;
 }
if(menu_options[4].num_extra == 1)
{
menu_options[4].num_extra = 0;
stop_music(song);
strcpy(menu_options[4].text, "Music Off");
music_on = 0;
}
else if(menu_options[4].num_extra == 0)
{
menu_options[4].num_extra = 1;
strcpy(menu_options[4].text, "Music On");
music_on = 1;
}
set_sound_texts();
return 0;
}
int mset_sound_vol(void)
{
if(menu_options[1].num_extra ==1)
{
menu_options[1].num_extra =2;
sound_vol = 125;
}
else if(menu_options[1].num_extra ==2)
{
menu_options[1].num_extra =3;
sound_vol = 50;
}
else if(menu_options[1].num_extra ==3)
{
menu_options[1].num_extra =1;
sound_vol = 255;
}
set_sound_texts();
return 0;
}
int mset_music_vol(void)
{
if(menu_options[2].num_extra ==1)
{
menu_options[2].num_extra =2;
music_vol = 0.5f;
}
else if(menu_options[2].num_extra ==2)
{
menu_options[2].num_extra =3;
music_vol = 0.2f;
}
else if(menu_options[2].num_extra ==3)
{
menu_options[2].num_extra =1;
music_vol = 1.0f;
}
set_sound_texts();
return 0;
}

int set_sound_texts(void)
{
if(sound_on)
{
strcpy(menu_options[3].text, "Sound On");
menu_options[3].num_extra = 1;
menu_options[1].flags = 0;
menu_esc[1].flags  = 0;
}
else
{
strcpy(menu_options[3].text, "Sound Off");
menu_options[3].num_extra = 0;
menu_options[1].flags = D_DISABLED;
menu_esc[1].flags  = D_DISABLED;
}
if(music_on)
{
strcpy(menu_options[4].text, "Music On");
menu_options[4].num_extra = 1;
menu_options[2].flags = 0;
menu_esc[2].flags  = 0;
}
else
{
strcpy(menu_options[4].text, "Music Off");
menu_options[4].num_extra = 0;
menu_options[2].flags = D_DISABLED;
menu_esc[2].flags  = D_DISABLED;
}
//Sound Volume Stuff
if(menu_options[1].num_extra ==1)
{
strcpy(menu_options[1].text, "Sound Vol Loud");
strcpy(menu_esc[1].text, "Sound Vol Loud");
}
else if(menu_options[1].num_extra ==2)
{
strcpy(menu_options[1].text, "Sound Vol Medium");
strcpy(menu_esc[1].text, "Sound Vol Medium");
}
else if(menu_options[1].num_extra ==3)
{
strcpy(menu_options[1].text, "Sound Vol Quiet");
strcpy(menu_esc[1].text, "Sound Vol Quiet");
}
if(menu_options[2].num_extra ==1)
{
strcpy(menu_options[2].text, "Music Vol Loud");
strcpy(menu_esc[2].text, "Music Vol Loud");
}
else if(menu_options[2].num_extra ==2)
{
strcpy(menu_options[2].text, "Music Vol Medium");
strcpy(menu_esc[2].text, "Music Vol Medium");
}
else if(menu_options[2].num_extra ==3)
{
strcpy(menu_options[2].text, "Music Vol Quiet");
strcpy(menu_esc[2].text, "Music Vol Quiet");
}

return 0;
}
//Lets make it look better.
int show_credits(void)
{
 FILE *fp1;
 int index = 0;
 int index2 = 0;
 int key_pressed = 0;
 char *gtext;
 char gtext2[41];
 char text[16][41];

//Loading File
      if((fp1=fopen("pnc.dat","r"))==NULL)
       {
          allegro_message("Unable to load vital data file\n");
          exit(1);
       }
//This is initializing
for(index = 0; index <16;index++)
 {
 strcpy(text[index],"");
 }
speed_counter = 0;
clear_keybuf();
//Main Loop
while(index >-1)
{
//If end of line
 if(fgets(gtext2,40,fp1)==NULL)
  {
   index = -2;
   break;
  }

//Unencrpt string
gtext = unencrypt_string(gtext2);
//Slide everything up
for(index = 1; index <16;index++)
 {
 strcpy(text[index-1],text[index]);
 }
 strcpy(text[15],gtext);

for(index = 0; index < 30;index ++)
{
blit(screen_pic,double_buffer,0,0,0,0,double_buffer->w,double_buffer->h);
  for(index2 =0;index2<16;index2++)
     textout(double_buffer,font,text[index2],50,0+30*index2 - index, makecol(0,230,0));
        key_pressed = 0;
        if(keypressed())
         {
         key_pressed = readkey() >>8;
         clear_keybuf();
         }

        if(key_pressed == KEY_SPACE || key_pressed == KEY_ENTER || key_pressed ==KEY_ESC)
         {
           clear_bitmap(double_buffer);
           index = -2;
           speed_counter = 0;
           break;
         }
while(speed_counter < 1)
  {
  blit(double_buffer,screen,0,0,0,0,double_buffer->w,double_buffer->h);
  play_music(song);
  }
speed_counter = 0;
}
}
fclose(fp1);
return 0;
}
int save_game_settings(void)
{
FILE *fp;
int index;
if((fp=fopen("game_dat.dat","wb"))==NULL) //Checks to see if opened file
 return 1;
//First We Save the paddle stats
for(index =0;index < 4;index++)
 {
fwrite(&(paddle_input[index].input),sizeof(int),1,fp);
fwrite(&paddle_input[index].right_flag,sizeof(int),1,fp);
fwrite(&paddle_input[index].left_flag,sizeof(int),1,fp);
fwrite(&paddle_input[index].down_flag,sizeof(int),1,fp);
fwrite(&paddle_input[index].up_flag,sizeof(int),1,fp);
fwrite(&paddle[index].type,sizeof(int),1,fp);
}
//Joystick in use or not
fwrite(&(menu_controls[1].num_extra),sizeof(int),1,fp);
//Now we save Song Stats, If on or off
for(index =0;index < 8;index++)
 {
fwrite(&menu_music[index].num_extra,sizeof(int),1,fp);
 }
//I think thats it.
fclose(fp); //Close The Files

return 0;
}
int load_game_settings(void)
{
FILE *fp;
int index;
if((fp=fopen("game_dat.dat","rb"))==NULL) //Checks to see if opened file
 return 1;
//First We Save the paddle stats
for(index =0;index < 4;index++)
 {
fread(&(paddle_input[index].input),sizeof(int),1,fp);
fread(&paddle_input[index].right_flag,sizeof(int),1,fp);
fread(&paddle_input[index].left_flag,sizeof(int),1,fp);
fread(&paddle_input[index].down_flag,sizeof(int),1,fp);
fread(&paddle_input[index].up_flag,sizeof(int),1,fp);
fread(&paddle[index].type,sizeof(int),1,fp);
}
//Joystick in use or not
fread(&(menu_controls[1].num_extra),sizeof(int),1,fp);
//Now we save Song Stats, If on or off
for(index =0;index < 8;index++)
 {
fread(&menu_music[index].num_extra,sizeof(int),1,fp);
 }
//I think thats it.
fclose(fp); //Close The Files

return 0;

}
/*

balls_used = 2;
score1 = 0;
score2 = 0;
paddle[0].user = 1;
paddle[1].user = 1;
paddle[0].type = 1;
paddle[1].type = 1;
paddle[2].type = 2;
paddle[3].type = 2;
paddle[0].user = 1;
paddle[1].user = 2;
paddle[2].user = 2;
paddle[3].user = 1;
paddle_input[0].input = 1;
paddle_input[0].right_flag = KEY_RIGHT;
paddle_input[0].left_flag = KEY_LEFT;
paddle_input[0].down_flag = KEY_DOWN;
paddle_input[0].up_flag = KEY_UP;
//Player 2
paddle_input[1].input = 1;
paddle_input[1].right_flag = KEY_D;
paddle_input[1].left_flag = KEY_A;
paddle_input[1].down_flag = KEY_S;
paddle_input[1].up_flag = KEY_W;
//Player 3
paddle_input[2].input = 1;
paddle_input[2].right_flag = KEY_L;
paddle_input[2].left_flag = KEY_J;
paddle_input[2].down_flag = KEY_I;
paddle_input[2].up_flag = KEY_K;
//Player 4
paddle_input[3].input = 1;
paddle_input[3].right_flag = KEY_6_PAD;
paddle_input[3].left_flag = KEY_4_PAD;
paddle_input[3].down_flag = KEY_5_PAD;
paddle_input[3].up_flag = KEY_8_PAD;


//Reset Positions
paddle[0].image.x =0;
paddle[0].image.y =120;
paddle[1].image.x =620;
paddle[1].image.y =120;
paddle[2].image.x =120;
paddle[2].image.y =64;
paddle[3].image.x =120;
paddle[3].image.y =460;
ball[0].image.x = 154;
ball[0].image.y = 106;
ball[0].image.vx = 4;
ball[0].image.vy = 3;
ball[1].image.x = 154;
ball[1].image.y = 106;
ball[1].image.vx = -4;
ball[1].image.vy = -3;
ball[2].image.x = 144;
ball[2].image.y = 106;
ball[2].image.vx = -4;
ball[2].image.vy = -3;
ball[3].image.x = 164;
ball[3].image.y = 106;
ball[3].image.vx = 4;
ball[3].image.vy = 3;
}


int menu_show(int menu_number,int menu_length, int menu_width, int menu_x, int menu_y)
{
int index = 1;
int index_right;
int index_up = 0;
int key_pressed = 0;
char text[200];
speed_counter = 0;
while(index > -1)
{
if(speed_counter)
 {

 blit(screen_pic,double_buffer,0,0,0,0,double_buffer->w,double_buffer->h);
rectfill(double_buffer,menu_x-50,menu_y,540,20+30*index_up+menu_y,53);
for(index_up =0;index_up < menu_length;index_up++)
  {
  if(menu_number == 1)
   {
   sprintf(text,"%s",menu_1_text[index_up]);
   if(index_up == index)
   christ_print(double_buffer,font,text,menu_x,30*index_up+menu_y, 1);
  else
   textout(double_buffer,font,text,menu_x,30*index_up+menu_y, 2);
   }
  if(menu_number == 3)
   {
   sprintf(text,"%s",menu_3_text[index_up]);

  if(index_up == index)
   christ_print(double_buffer,font,text,menu_x,30*index_up+menu_y, 1);
  else if(!menu_3_info[index_up])
   textout(double_buffer,font,text,menu_x,30*index_up+menu_y, 3);
  else
   textout(double_buffer,font,text,menu_x,30*index_up+menu_y, 2);
   }
  }

//KeyBoard Input System, so everything doesnt go out of control
key_pressed = 0;
if(keypressed())
 {
 key_pressed = readkey() >>8;
 clear_keybuf();
 }

 if(key_pressed == KEY_SPACE ||key_pressed== KEY_ENTER)
  {
  if(menu_number == 1)
   return index;
  if(index ==9)
    {
    clear_bitmap(double_buffer);
    break;
    }

  else if(menu_number==3)
   {
   if(menu_3_stats[index] == 0)
    {
     menu_3_stats[index] = 1;
     strcpy(menu_3_text[index],"Human");
     paddle[index /2].user = 1;
    }

   else if(menu_3_stats[index] == 1)
    {
     menu_3_stats[index] = 0;
     strcpy(menu_3_text[index],"Computer");
     paddle[index /2].user = 2;
    }

  }
 }
   //Going Up
   if(key_pressed == KEY_UP)
    {
     for (index_right = index;index_right > 0; index_right--)
     {
      index--;
     if(menu_number ==1)
      break;
     if(menu_number ==3)
      {
      if(menu_3_info[index])
        break;
      }
      }
      if(index<1)
      index =1;
     }

  //Going Down
  if(key_pressed == KEY_DOWN)
  {
   for (index_right = index;index_right < menu_length; index_right++)
   {
     index++;
    if(menu_number ==1)
      break;

    if(menu_number == 3)
     {
     if(menu_3_info[index])
       break;
     }
    }
   if(index>menu_length - 1)
    index = menu_length - 1;
  }
//      update_particles(particle_list);
//      particle_list = clean_particles(particle_list);
//      particle_list = create_snow_flake(particle_list);
//      particle_list = create_snow_flake(particle_list);
//      draw_particles(double_buffer,particle_list);
blit(double_buffer,screen,0,0,0,0,double_buffer->w,double_buffer->h);
play_music(song);
speed_counter--;
 }//end if speed counter
}

return index;
}
int menu_select_map(NPK *npk)
{
int index = 0;
int index2 = 0;
int key_pressed = 0;
char text[200];
speed_counter = 0;
while(index > -1)
{
 if(speed_counter)
 {
blit(screen_pic,double_buffer,0,0,0,0,double_buffer->w,double_buffer->h);
rectfill(double_buffer,120,180,540,200+20+30*index2,53);
for(index2 =0;index2<npk->num_maps+1;index2++)
  {
  sprintf(text,"%s",npk->map_name[index2]);
  if(index2 == npk->num_maps)
  strcpy(text,"Back");
  if(index2 == index)
   christ_print(double_buffer,font,text,0+200,0+30*index2+200, 1);
  else
   textout(double_buffer,font,text,0+200,0+30*index2+200, 2);
  }

key_pressed = 0;
if(keypressed())
 {
 key_pressed = readkey() >>8;
 clear_keybuf();
 }

if(key_pressed == KEY_SPACE || key_pressed == KEY_ENTER)
 {
   clear_bitmap(double_buffer);
   break;
 }
if(key_pressed == KEY_UP)
{
index--;
if(index<0)
 index =0;
}
if(key_pressed == KEY_DOWN)
{
index++;
if(index>npk->num_maps)
 index = npk->num_maps;
}
//      update_particles(particle_list);
//      particle_list = clean_particles(particle_list);
//      particle_list = create_snow_flake(particle_list);
//      particle_list = create_snow_flake(particle_list);
//      draw_particles(double_buffer,particle_list);
blit(double_buffer,screen,0,0,0,0,double_buffer->w,double_buffer->h);
play_music(song);
speed_counter--;
 }//end if speed counter
}


return index;
}
*/
