//Includes
#include <stdio.h>
#include <stdlib.h>
#include "allegro.h"

//Defines/////////////////////////

//Globals/////////////////////////
BITMAP *double_buffer; //Double Buffer

//Game Objects
PADDLE paddle[MAX_PADDLES]; //The 4 paddles
BALL ball[MAX_BALLS];

const int scrx = 640; //Screen Size
const int scry = 480; //X + Y

int paddles_used;     //Number of Paddles 2, or 4
int balls_used;
int game_type;        //2 paddle, 4 paddle or Solo

//Functions////////////////////////
//If Computer Runs out
void mem_error(void)
{
if(set_gfx_mode(GFX_TEXT,0,0,0,0))
  { allegro_message("Cannot Initialize Screen.\n");
    exit(1);
  }
allegro_message("Out of Memory!/n");
exit(1);
}

int sprite_collide(SPRITE *sprite1,SPRITE *sprite2)
{
if((sprite1->x+sprite1->width) <sprite2->x || (sprite2->x +sprite2->width) < sprite1->x || (sprite1->y+sprite1->height) < sprite2->y || (sprite2->y+sprite2->height) <sprite1->y)
 return 0;
else
 return 1;
}
//Will use to simplify stuff
void sprite_display(SPRITE *sprite)
{
}
void sprite_grab(SPRITE *sprite)
{
}
void sprite_init(SPRITE *sprite,int x, int y, int width, int height, int num_frame, int delay_frame)
{
 sprite->x = x;
 sprite->y = y;
 sprite->oldx = x;
 sprite->oldy = y;
 sprite->width = width;
 sprite->height = height;
 sprite->num_frame = num_frame;
 sprite->delay_frame = delay_frame;
 sprite->cur_frame = 0;
 sprite->state = SPRITE_DEAD;
}

void player_input(void)
{
if(key[KEY_UP])
 {

  paddle[0].image.y -=3 ;
  if(paddle[0].image.y < 0)
     paddle[0].image.y = 0;
 }//end if
if(key[KEY_DOWN])
 {
   paddle[0].image.y += 3;
  if(paddle[0].image.y > 480- paddle[0].image.image->h)
     paddle[0].image.y = 480 - paddle[0].image.image->h;
  }//end if
/*
if(speed_loss=0)
 {
  if(paddle[0].speed<0) paddle[0].speed+=1;
  if(paddle[0].speed>0) paddle[0].speed-=1;
  }

 paddle[0].y += paddle[0].speed;
  if(paddle[0].y > 480- paddle[0].image->h)
     paddle[0].y = 480 - paddle[0].image->h;
  if(paddle[0].y < 0)
     paddle[0].y = 0;
*/
}


void animate(void)
{
//Yep, taken from my other games...
//I like how i do this :)
//Everything will be put in their own subs later
//Draw Backround
clear_bitmap(double_buffer); //Will Change To Show Tiles
//Draw Sprites
draw_sprite(double_buffer,paddle[0].image.image,paddle[0].image.x,paddle[0].image.y);
draw_sprite(double_buffer,paddle[1].image.image,paddle[1].image.x,paddle[1].image.y);
draw_sprite(double_buffer,ball[0].image.image,ball[0].image.x,ball[0].image.y);
//Draw Buffer
blit(double_buffer,screen,0,0,0,0,double_buffer->w,double_buffer->h);
}

void comp_act(void)
{
if(ball[0].image.y<(paddle[1].image.y+25))
{
paddle[1].image.y=paddle[1].image.y-2;
 if(paddle[1].image.y<0)
  paddle[1].image.y=0;
}
else if(ball[0].image.y>(paddle[1].image.y+25))
{
paddle[1].image.y=paddle[1].image.y+2;
 if(paddle[1].image.y>scrx-paddle[1].image.image->w)
  paddle[1].image.y=scrx-paddle[1].image.image->w;
}

}
void ball_collide(void)
{

if(sprite_collide(&ball[0].image,&paddle[0].image))
 {
  ball[0].image.vx= (-ball[0].image.vx);
 }
if(sprite_collide(&ball[0].image,&paddle[1].image))
 {
  ball[0].image.vx= (-ball[0].image.vx);
 }

}
void ball_act(void)
{
ball[0].image.x=ball[0].image.x+ball[0].image.vx;
ball[0].image.y=ball[0].image.y+ball[0].image.vy;
  if(ball[0].image.x>=scrx - ball[0].image.image->w)
   {
   ball[0].image.vx=(-ball[0].image.vx);
   ball[0].image.x=scrx -ball[0].image.image->w;
   }
  if(ball[0].image.x<=0)
   {
   //ball.v_y=(-ball.v_y);
   ball[0].image.vx=(-ball[0].image.vx);
   ball[0].image.x=0;
   }
  if(ball[0].image.y<=0)
   {
   ball[0].image.vy=(-ball[0].image.vy);
   ball[0].image.y=0;
   }
  if(ball[0].image.y>=scry - ball[0].image.image->h)
   {
   ball[0].image.vy=(-ball[0].image.vy);
   ball[0].image.y=scry-ball[0].image.image->h;
   }
/*  if(Sprite_Collide((sprite_ptr)&p1_paddle,(sprite_ptr)&ball)==1)
    {
    //ball.v_y=(-ball.v_y);
    //  if(ball.x<10)
    //  ball.v_y=(-ball.v_y);
      ball.v_x=(-ball.v_x);
     }
*/
/*   if(Sprite_Collide((sprite_ptr)&c1_paddle,(sprite_ptr)&ball)==1)
    {
    //ball.v_y=(-ball.v_y);
    //  if(ball.x<10)
    //  ball.v_y=(-ball.v_y);
      ball.v_x=(-ball.v_x);
     }
  */
}
//Main////////////////////////////
int main(int argc, char* argv[])
{

//Initializing all the stuff
if (allegro_init())
   { allegro_message("Cannot Initialize Allegro.\n");
     return 1;
   }
if (install_keyboard())
   { allegro_message("Cannot Initialize Keyboard.\n");
     return 1;
   }
if(install_timer())
   { allegro_message("Cannot Initialize Timer \n.");
     return 1;
   }
if (install_mouse()<0)
   { allegro_message("Cannot Initialize Mouse.\n");
     return 1;
   }
   
//Set Graphics Mode
set_color_depth(8); //Make 256 Colours
if(set_gfx_mode(GFX_AUTODETECT,scrx,scry,0,0))
  { allegro_message("Cannot Initialize Screen.\n");
    return 1;
   }

//Create Double Buffer
 double_buffer =  create_bitmap(scrx, scry);
  if(!double_buffer) mem_error;
  clear_bitmap(double_buffer);

//Init Sprites
sprite_init(&paddle[0].image,0,120,20,60,1,0); //The Paddles
sprite_init(&paddle[1].image,619,120,20,60,1,0);
paddle[0].image.image = create_bitmap(20,60);
paddle[1].image.image = create_bitmap(20,60);
rectfill(paddle[0].image.image,0,0,19,59,2);
rectfill(paddle[1].image.image,0,0,19,59,2);

sprite_init(&ball[0].image,154,106,16,16,1,0); //The Ball
ball[0].image.image = create_bitmap(16,16);
rectfill(ball[0].image.image,0,0,16,16,1);
ball[0].image.vx = 3;
ball[0].image.vy = 3;


//Game Engine Will Move Soon
do
{
//Get Player Input
player_input();
comp_act();
ball_collide();
//player_act should be next
ball_act();
//ball_collide();
//This Sub Draws Everything

animate();
vsync();
}while(!key[KEY_ESC]);

//Closing Stuff
//Free up all allocated mem
destroy_bitmap(double_buffer);
destroy_bitmap(paddle[0].image.image);
destroy_bitmap(paddle[1].image.image);
destroy_bitmap(ball[0].image.image);
return 0;
}
END_OF_MAIN()

