//One Handicap Of Menu System is that buffered keyboard input will be cleared
//After polling, meaning attempting to get user input while running the menu
//wont work, or will very poorly.

//Also Note, Currently Uses Allegro GUI Defines, eg D_DISABLED, D_SELECTED
//May need to change in future.

//Menu Curently Sets Draw_mode, and doesnt set back. Find out how to change this

//Menu System Returns 0 if is still working, 1 if Exited via menu, 2 if pressed escape

//Current Back Menu system a memory waster, consider improving for future use

//Becuase of lots of string modification, *text was renamed text[50], perhaps in future
//dynamically allocate string data, and clear when no longer in use?(somehow)
//Like instead of *text, use *mystring, whereas mystring is a struct, and can be
//loaded via string * create_string(char *text);
 // struct mystring{ char *text;
 //                  int initialized;
 //                  int sizeofstring;};

//Last Suggestion, Use D_END to tell dialog that its at the end of the menu options
#include <stdio.h>
#include "allegro.h"
#include "gmenu.h"

int gmenu_message_alert(BITMAP *bitmap,char *text,int x, int y, int draw_mode, int colour);
// Gmenu stuff
G_MENU *game_active_menu; //
int gmenu_initialized = 0; //This is so i can set the colours up
int gmenu_back_extra = 10; //How many extra pixels to draw around the border
int gmenu_selected_color; //Like it says
int gmenu_disabled_color; //---
int gmenu_normal_color;   //---
int gmenu_text_space = 5;



//Creates A Menu System
G_MENUP * init_game_menu(G_MENU *g_menu,int x, int y, int backcolor, int drawtype)
{
G_MENUP *temp;  //Will Use to create temp menu
int index;
if(!gmenu_initialized)
  {
  set_gmenu_colors(makecol(0,255,0), makecol(0,64,0), makecol(0,164,0)); //Default Colours
  gmenu_initialized = 1;
  }
temp = (G_MENUP *)malloc(sizeof(G_MENUP));  //We Create the menu
//Now Set Variables
temp->menu = g_menu;
temp->x = x;
temp->y = y;
temp->back_color = backcolor;
temp->draw_type = drawtype;
temp->used = 1; //Thought i may need this, probably not.
temp->selected = 0; //Sets to First Option, may need to modify
//Now we get menu length
index = 0;
while((temp->menu[index].t_extra))
{
if(temp->menu[index].flags ==D_BACK)
 temp->menu[index].back = NULL;
index++;
}
temp->menu_length = index;
return temp;    //Return Newly created menu.
}

//Already Inited, now must move on to child.
int switch_game_menu(G_MENUP *g_menup, int type)
{
G_MENU *temp = NULL;
int index;
//Go to Child
if(type ==1)
 {
    temp = g_menup->menu;
    g_menup->menu = g_menup->menu[g_menup->selected].child;
 }
//Go backwards
if(type ==2)
 {
    temp = g_menup->menu;
    g_menup->menu = g_menup->menu[g_menup->selected].back;
    temp[g_menup->selected].back = NULL;
 }
//Now Set Variables
//>menu = g_menu;
//temp->x = x;
//temp->y = y;
//temp->back_color = backcolor;
//temp->draw_type = drawtype;
g_menup->used = 1; //Thought i may need this, probably not.
g_menup->selected = 0; //Sets to First Option, may need to modify
//Now we get menu length
index = 0;
while((g_menup->menu[index].t_extra))
{
if(type ==1 && g_menup->menu[index].flags ==D_BACK)
 g_menup->menu[index].back = temp;
index++;
}//Takes as little space as possible.
 //Well, Used to.
g_menup->menu_length = index;

return 0;
}
//Updates Menu Status, Maybe have draw seperate?
   //Doing so would allow for effects like scrolling menu....
   //Think About.

//Notes; Returns 0 To Keep Polling, 1 Upon Selction, 2 If User ESCapes

int update_game_menu(G_MENUP *player)
{
int index;
int key_pressed;
//For Now Print The Stuff,
key_pressed = 0;
if(keypressed()) //Have Any Keys Been Pressed Recently?
 {
 key_pressed = readkey() >>8; //If So Grab em
 clear_keybuf();              //Clears Keyboard Buffer
 }
//User Pressed Escape So we abort
   if(key_pressed == KEY_ESC)
     return 2;
//User Pressed Enter So we do some checking
if(key_pressed == KEY_ENTER)
 {
 //See if Function Can be called
 if(player->menu[player->selected].proc)
  //No we move on
   {
    game_active_menu = player->menu; //Grab it so subroutine can determine stuff
    index = player->menu[player->selected].proc(); //Call subfunction
    game_active_menu = NULL; //Dont need anymore.
    //If makes menu exit
    if(index == D_EXIT)
     return 1;
   }
 //See if Next Menu Exists
 if(player->menu[player->selected].child)
  //Now we move on
  {
  switch_game_menu(player, 1);
  return 0;
  }
 //Next See if Back Menu Exists
 if(player->menu[player->selected].flags == D_BACK)
 //Now we move on
  {
  switch_game_menu(player, 2);
  return 0;
  }
  //Next See if Menu End Menu
 if(player->menu[player->selected].flags == D_EXIT)
  //Now we move on
  {
  return 1;
  }
 }


//If User Pressed Up
   if(key_pressed == KEY_UP)
    {
     for(index = player->selected - 1;index >= 0 ; index--)
     {
      if(player->menu[index].flags !=D_DISABLED && player->menu[index].flags != D_HIDDEN )
        {
         player->selected = index;
         break;
        }
     }//End of For
    }//End Of If

//If User Pressed Down
   if(key_pressed == KEY_DOWN)
    {
     for (index = player->selected+1;index <player->menu_length; index++)
     {
      if(player->menu[index].flags !=D_DISABLED && player->menu[index].flags !=D_HIDDEN)
        {
         player->selected = index;
         break;
        }
     }//End of For
    }//End Of If

return 0;
}
//Decided To Do Becuase of double_buffer declared errors
int draw_game_menu(G_MENUP *player, BITMAP *disp)
{
int index;
int gmtext_length = 0;
int gmtext_height;
//IMPORTANT, I ONLY USE - 14 BECUASE OF THE SPECIFIC FONT
//CHANGE IN FUTURE
gmtext_height = text_height(font) - 14; //Get Text Height

//Get How Long We have to draw the backround
for(index = 0; index < player->menu_length;index++)
 if(text_length(font,player->menu[index].text) > gmtext_length && player->menu[index].flags != D_HIDDEN)
   gmtext_length = text_length(font,player->menu[index].text);
player->menu_width = gmtext_length; //For Use outside of gmenu.
player->menu_height = (gmtext_height+gmenu_text_space) * player->menu_length +gmenu_back_extra;
if(player->draw_type == 1)
{
drawing_mode(DRAW_MODE_TRANS,NULL,0,0); //Set to translucent;
rectfill(disp,player->x,player->y,player->x+gmtext_length+gmenu_back_extra,player->y+(gmtext_height+gmenu_text_space) * player->menu_length +gmenu_back_extra, player->back_color);
}

else if(player->draw_type == 2)
{
drawing_mode(DRAW_MODE_SOLID,NULL,0,0); //Set to solid;
rectfill(disp,player->x,player->y,player->x+gmtext_length+gmenu_back_extra,player->y+(gmtext_height+gmenu_text_space) * player->menu_length +gmenu_back_extra, player->back_color);
//rectfill(disp,player->x,player->y,gmtext_length+gmenu_back_extra,(gmtext_height+gmenu_text_space) * player->menu_length +gmenu_back_extra, player->back_color);
}

for(index = 0; index < player->menu_length;index++)
{
//Change Colour Occordingly

if(index == player->selected)
    textout(disp,font,player->menu[index].text,player->x + (gmenu_back_extra / 2),(gmtext_height + gmenu_text_space) * index + player->y + gmenu_back_extra, gmenu_selected_color);
else if(player->menu[index].flags == D_DISABLED)
  //  textout(disp,font,player->menu[index].text,player->x,30*index+player->y, 4);
    textout(disp,font,player->menu[index].text,player->x + (gmenu_back_extra /2),(gmtext_height + gmenu_text_space) * index + player->y + gmenu_back_extra, gmenu_disabled_color);
else if(player->menu[index].flags != D_HIDDEN)
  //      textout(disp,font,player->menu[index].text,player->x,30*index+player->y, 3);
    textout(disp,font,player->menu[index].text,player->x + (gmenu_back_extra /2),(gmtext_height + gmenu_text_space) * index + player->y + gmenu_back_extra, gmenu_normal_color);
    //   textout(double_buffer,font,text,menu_x,30*index_up+menu_y, 3);
//  textout(double_buffer,font,text,_x,30*index_up+menu_y, 2);

//printf("%s",player->menu[index].text);
//rest(200);
}
return 0;
}


//Clears Up All Use Mem
int destroy_game_menu(G_MENUP *player)
{
if(player)
 {
 free(player); //Frees Used Mem
 return 0;
 }
return 1;
}
//This is essentially Like Windows Alert, Cept, Im Making a more game oriented version
int gmenu_message_alert(BITMAP *bitmap,char *text,int x, int y,int draw_mode, int colour)
{
int gm_text_length;
gm_text_length = text_length(font,text);
//Solid Drawing Mode
if(draw_mode ==0)
  drawing_mode(DRAW_MODE_SOLID,NULL,0,0); //Set to solid;
//Trans Drawing Mode
if(draw_mode ==1)
  drawing_mode(DRAW_MODE_TRANS,NULL,0,0); //Set to translucent;
rectfill(bitmap,x,y,x+gm_text_length+20,y+75,colour);
textout(bitmap, font, text, x+10, y+20, gmenu_normal_color);
return 0;
}

//Sets gmenu_colors
void set_gmenu_colors(int selected, int disabled, int normal)
{
//Since it cant fail, dont return anything
gmenu_selected_color = selected; //Like it says
gmenu_disabled_color = disabled; //---
gmenu_normal_color = normal;   //---
}

//int do_game_menu(MENU *menu); //Wasnt gonna include this, but what the heck

