#include <time.h>
#include <string>
#include <fstream.h>
#include <allegro.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <ppcol.h>
using namespace std;

#define PADDLE_Y 550
#define MAX_XV 4
#define MAX_YV 3.5
#define MAX_PARTICLES 2000

#define BALL 0
#define BLOCK1 1
#define BLOCK2 2
#define BLOCK3 3
#define PADDLE1 4
#define PADDLE2 5
#define PADDLE3 6
#define POWUP1 7
#define POWUP2 8
#define POWUP3 9
#define POWUP4 10
#define POWUP5 11
#define POWUP6 12
#define POWUP7 13
#define POWUP8 14
#define POWUP9 15
#define TITLE1 16
#define TITLE2 17
#define PALETTE 18

volatile int counter;
volatile int fps_counter;

int qwerty = srandom(time(NULL));

int dirtyrects = 0;
int numparticles;  //the number of particles active
char msg[50];
int death;
int paused;
int keydelay;
int frames;
int fps;
int exitgame;
int gameover;
int lives;
int showfps;
int levels;
int level;
int initialized;
int totpowup;
int totdeath;
float charge[2];

typedef struct tball
{
  float x;
  float y;
  float xv;
  float yv;
  int polarity;
} tball;

typedef struct tpaddle
{
  float x;
  float xv;
  int polarity;
  int fieldstrength;
  int speed;
} tpaddle;

typedef struct tblock
{
  int x;
  int y;
  int type;
  int temp;
} tblock;

typedef struct tparticle
{
  float x;
  float y;
  float xv;
  float yv;
  int type;
  int color;
  int time;
  int oldcolor;
} tparticle;

typedef struct tpowup
{
  float x;
  float y;
  float xv;
  float yv;
  int type;
} tpowup;

typedef struct dirtyrect
{
  int x;
  int y;
  int w;
  int h;
} dirtyrect;

tball ball;
tpaddle paddle;
tblock block[31][40][20];
tparticle particle[MAX_PARTICLES];
tpowup powup[5];

dirtyrect drect[2000];  //hoping there will never be more than 2000 dirty rects at once

void create_dirty(int x, int y, int w, int h);
void draw_dirty();

void init();
void do_menu();
void do_logic();
void do_ball_movement();
void do_paddle_movement();
void draw_stats();
void do_death_anim();
void start_new_level();
void init_particle(int type, int x, int y, int color);
void do_particles();
void create_powup(int x, int y);
void do_powup();
void activate_powup(int type);
void explode_blocks(int x, int y, int level, int direction);
void draw_everything();
void clear_movers();
void clear_particles();
void draw_paddle();
void draw_powup();
void clear_particles_here(int x, int y, int w, int h);
void kill_particles();
void do_credits();
int draw_blocks();
int randposneg();
int find_free_particle();
int pixel_here(int x, int y, int w, int h);
float abs(float z);

BITMAP *back_buffer;
BITMAP *stat_buffer;
BITMAP *paddledeath;
BITMAP *ball_buffer;
BITMAP *powup_buffer[5];
BITMAP *pause_buffer;
DATAFILE *graphics;

void timer_handler()
{
  counter++;
}
END_OF_FUNCTION(timer_handler);

void fps_handler()
{
  fps_counter++;
}
END_OF_FUNCTION(fps_handler);

int main()
{
  int p;
  BEGIN_COLOR_DEPTH_LIST
    COLOR_DEPTH_8
  END_COLOR_DEPTH_LIST
  LOCK_VARIABLE(counter);
  LOCK_FUNCTION(timer_handler);
  LOCK_VARIABLE(fps_counter);
  LOCK_FUNCTION(fps_handler);
  allegro_init();
  install_keyboard();
  install_timer();
  install_int_ex(timer_handler, BPS_TO_TIMER(50));
  install_int_ex(fps_handler, BPS_TO_TIMER(1));
  if (set_gfx_mode(GFX_AUTODETECT, 800, 600, 0, 0) != 0)
  {
    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
    allegro_message("Unable to set any graphic mode\n%s\n", allegro_error);
    return 1;
  }
  graphics = load_datafile("polarity.dat");
  if (!graphics)
  {
    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
    allegro_message("Unable to load polarity.dat\n%s\n", allegro_error);
    return 1;
  }
  back_buffer = create_bitmap(800, 600);
  clear(back_buffer);
  stat_buffer = create_bitmap(800, 600 - PADDLE_Y - 20);
  clear(stat_buffer);
  paddledeath = create_bitmap(100, 20);
  clear(paddledeath);
  ball_buffer = create_bitmap(10, 10);
  clear(ball_buffer);
  pause_buffer = create_bitmap(173, 18);
  clear(pause_buffer);
  p = 0;
  while (p < 5)
  {
    powup_buffer[p] = create_bitmap(20, 20);
    clear(powup_buffer[p]);
    p++;
  }
  set_palette((RGB *)graphics[PALETTE].dat);
  showfps = 0;
  fps_counter = 0;
  frames = 0;
  keydelay = 0;
  paused = 0;
  death = 0;
  exitgame = 0;
  gameover = -1;
  counter = 0;
  numparticles = 0;
  while (exitgame == 0)
  {
    while (counter > 0)
    {
      switch(gameover)
      {
        case -1:
          do_menu();
          break;
        case 0:
          if (paused == 0)
          {
            do_logic();
          }
          if (key[KEY_S])  //grab a screenshot
          {
            save_bitmap("scrshot.bmp", back_buffer, (RGB *)graphics[PALETTE].dat);
          }
          if ((key[KEY_P]) && (keydelay == 0) && (gameover == 0))
          {
            if (paused == 0)
            {
              blit(back_buffer, pause_buffer, 314, 290, 0, 0, 173, 18);
              rect(back_buffer, 314, 290, 486, 307, 15);
              rectfill(back_buffer, 315, 291, 485, 306, 0);
              textout_centre(back_buffer, font, "P  A  U  S  E  D", 400, 295, 15);
              create_dirty(314, 290, 173, 18);
              paused = 1;
            }
            else
            {
              blit(pause_buffer, back_buffer, 0, 0, 314, 290, 173, 18);
              create_dirty(314, 290, 173, 18);
              paused = 0;
            }
            keydelay = 10;
          }
          break;
        case 1:
          rect(back_buffer, 299, 290, 501, 307, 15);
          rectfill(back_buffer, 300, 291, 500, 306, 0);
          textout_centre(back_buffer, font, "G A M E   O V E R", 400, 295, 15);
          create_dirty(299, 290, 203, 18);
          if (key[KEY_ENTER])
          {
            while (key[KEY_ENTER])
            {
            }
            gameover = -1;
            clear(back_buffer);
            create_dirty(0, 0, 800, 600);
            //exitgame = 1;
          }
          break;
        case 2:
          do_credits();
          break;
      }
      if (keydelay > 0)
      {
        keydelay--;
      }
      if (key[KEY_ESC])
      {
        exitgame = 1;
      }
      if (key[KEY_F])
      {
        if (showfps == 0)
        {
          showfps = 1;
        }
        else
        {
          showfps = 0;
          rectfill(back_buffer, 5, 5, 150, 12, 0);
          create_dirty(5, 5, 150, 12);
        }
      }
      counter--;
    }
    if (fps_counter >= 1)
    {
      fps = frames;
      frames = 0;
      fps_counter = 0;
    }
    if (showfps == 1)
    {
      rectfill(back_buffer, 5, 5, 5 + text_length(font, "FPS: 1234567"), 5 + text_height(font), 0);
      sprintf(msg, "FPS: %-1d", fps);
      textout(back_buffer, font, msg, 5, 5, 15);
      create_dirty(5, 5, text_length(font, "FPS: 1234567"), text_height(font));
    }
    draw_dirty();
    frames++;
  }
  unload_datafile(graphics);
  destroy_bitmap(back_buffer);
  destroy_bitmap(stat_buffer);
  destroy_bitmap(paddledeath);
  destroy_bitmap(ball_buffer);
  destroy_bitmap(pause_buffer);
  p = 0;
  while (p < 5)
  {
    destroy_bitmap(powup_buffer[p]);
    p++;
  }
  allegro_exit();
  return 0;
}





void create_dirty(int x, int y, int w, int h)
{
  int z;
  z = dirtyrects;
  drect[z].x = x;
  drect[z].y = y;
  drect[z].w = w;
  drect[z].h = h;
  dirtyrects++;
}





void draw_dirty()
{
  int i = 0;
  while (i < dirtyrects)
  {
    if ((drect[i].w > 1) || (drect[i].h > 1))
    {
      blit(back_buffer, screen, drect[i].x, drect[i].y, drect[i].x, drect[i].y, drect[i].w, drect[i].h);
    }
    else
    {
      putpixel(screen, drect[i].x, drect[i].y, getpixel(back_buffer, drect[i].x, drect[i].y));
    }
    i++;
  }
  dirtyrects = 0;
}





void init()
{
  int x;
  int y;
  int l;
  int i;
  totpowup = 0;
  totdeath = 0;
  lives = 3;
  ball.x = 400;
  ball.y = PADDLE_Y - 15;
  ball.xv = 1.5;
  ball.yv = -1.5;
  ball.polarity = 1;
  paddle.polarity = -1;
  paddle.x = 350;
  paddle.xv = 0;
  paddle.fieldstrength = 1;
  paddle.speed = 1;
  charge[0] = 100;
  charge[1] = 100;
  level = 0;
  initialized = 0;
  ifstream lev("levels.pol");
  if (lev.bad())
  {
    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
    allegro_message("Unable to find 'levels.pol'\n%s\n", allegro_error);
  }
  lev >> levels;
  l = 0;
  while (l < levels)
  {
    y = 0;
    while (y < 40)
    {
      x = 0;
      while (x < 31)
      {
        lev >> block[x][y][l].type;
        block[x][y][l].x = 20 + (x * 25);
        block[x][y][l].y = 12 + (y * 12);
        block[x][y][l].temp = 0;
        x++;
      }
      y++;
    }
    l++;
  }
  lev.close();
  i = 0;
  while (i < 6)
  {
    powup[i].type = 0;
    i++;
  }
  i = 0;
  while (i < MAX_PARTICLES)
  {
    particle[i].type = 0;
    i++;
  }
  clear(back_buffer);
}





void do_menu()
{
  static int t = 0;
//  static int q = 0;
  static int l = text_length(font, "P R E S S  E N T E R");
  static int h = text_height(font);
  static int delay = 0;
//  clear(back_buffer);
  rectfill(back_buffer, (t - 3) - 145, 40, t - 3, 135, 0);
  rectfill(back_buffer, 830 - (t - 3), 40, 945 - (t - 3), 135, 0);
  blit((BITMAP *)graphics[TITLE1].dat, back_buffer, 0, 0, t - 145, 40, SCREEN_W, SCREEN_H);
  blit((BITMAP *)graphics[TITLE2].dat, back_buffer, 0, 0, 830 - t, 40, SCREEN_W, SCREEN_H);
  create_dirty(t - 146, 40, 145, 75);
  create_dirty(830 - t, 40, 115, 75);
  if (t > 415)
  {
    if (delay > 0)
    {
      delay--;
    }
    t = 415;
    textout_centre(back_buffer, font, "P R E S S  E N T E R", 400, 300, 15);
    create_dirty(400 - (l / 2), 300, l, h);
    if ((key[KEY_ENTER]) && (delay == 0))
    {
      t = 0;
      initialized = 0;
      gameover = 0;  //go to logic loop
      init();  //initialize or re-initialize all the important stuff
    }
  }
  else
  {
    if (key[KEY_ENTER])
    {
      rectfill(back_buffer, (t - 3) - 145, 40, t - 3, 135, 0);
      rectfill(back_buffer, 830 - (t - 3), 40, 945 - (t - 3), 135, 0);
      create_dirty(t - 146, 40, 145, 75);
      create_dirty(830 - t, 40, 115, 75);
      t = 415;
      delay = 15;
    }
  }
  t += 3;
}





void do_logic()
{
  static int endtime = 0;
  int nextlevel = 0;
  if (initialized == 0)
  {
    draw_everything();
    create_dirty(0, 0, 800, 600);  //puts the whole back_buffer on the screen
    initialized = 1;
  }
  clear_movers();
//  clear_particles();
  if (draw_blocks() == 1)  //if the level has been cleared
  {
    endtime++;
    if (endtime > 50)  //if one second has elapsed
    {
      endtime = 0;
      nextlevel = 1;
      kill_particles();
      start_new_level();
    }
  }
  if (key[KEY_D])
  {
    nextlevel = 1;
    kill_particles();
    start_new_level();
    while (key[KEY_D])
    {
    }
  }
  if (nextlevel == 0)
  {
    if (death == 0)
    {
      do_paddle_movement();
      do_ball_movement();
    }
    else
    {
      do_death_anim();
    }
    do_powup();
    do_particles();
    if (death == 0)
    {
      draw_paddle();
      draw_sprite(back_buffer, (BITMAP *)graphics[BALL].dat, int(ball.x), int(ball.y));
      create_dirty(int(ball.x) - 5, int(ball.y) - 5, 20, 20);
    }
    draw_powup();
    create_dirty(0, PADDLE_Y - 5, 800, 5);
    draw_stats();
  }
}





void clear_movers()
{
  int i = 0;
  while (i < numparticles)
  {
    if (particle[i].type != 0)
    {
      putpixel(back_buffer, int(particle[i].x), int(particle[i].y), particle[i].oldcolor);
      create_dirty(int(particle[i].x), int(particle[i].y), 1, 1);
    }
    i++;
  }
  blit(ball_buffer, back_buffer, 0, 0, int(ball.x), int(ball.y), 10, 10);
  create_dirty(int(ball.x), int(ball.y), 10, 10);
  rectfill(back_buffer, int(paddle.x), PADDLE_Y, int(paddle.x) + 100, PADDLE_Y + 20, 0);
  create_dirty(int(paddle.x), PADDLE_Y, 100, 20);
  i = 0;
  while (i < 5)
  {
    if (powup[i].type > 0)
    {
      blit(powup_buffer[i], back_buffer, 0, 0, int(powup[i].x), int(powup[i].y), 20, 20);
      create_dirty(int(powup[i].x), int(powup[i].y), 20, 20);
    }
    i++;
  }
  i = 0;
  while (i < numparticles)
  {
    switch(particle[i].type)
    {
      case 1:
        particle[i].x += particle[i].xv;
        particle[i].y += particle[i].yv;
        particle[i].yv += .1;
        particle[i].oldcolor = getpixel(back_buffer, int(particle[i].x), int(particle[i].y));
        break;
      case 2:
        particle[i].x += particle[i].xv;
        particle[i].y += particle[i].yv;
        particle[i].oldcolor = getpixel(back_buffer, int(particle[i].x), int(particle[i].y));
        break;
    }
    i++;
  }
}





void do_ball_movement()
{
  int i;
  float pol;
//  blit(ball_buffer, back_buffer, 0, 0, int(ball.x), int(ball.y), 10, 10);
//  rectfill(back_buffer, int(ball.x), int(ball.y), int(ball.x) + 9, int(ball.y) + 9, 0);
  ball.x += ball.xv;
  if (ball.x <= 0)
  {
    ball.xv = abs(ball.xv);
  }
  else if (ball.x >= 785)
  {
    ball.xv = -abs(ball.xv);
  }
  if (paddle.polarity != -1)
  {
    if (ball.y + 10 < PADDLE_Y)
    {
      pol = -ball.y * paddle.fieldstrength / 7500;
      if (ball.polarity == paddle.polarity)
      {
        pol *= -1;
      }
      ball.yv += pol;
    }
  }
  if (ball.y <= 0)
  {
    ball.yv = abs(ball.yv);
  }
  if (ball.y > 600)
  {
    death = 1;
  }
  else if (ball.y < PADDLE_Y + 20)
  {
    if (check_pp_collision((BITMAP *)graphics[PADDLE1].dat, (BITMAP *)graphics[BALL].dat, int(paddle.x), PADDLE_Y, int(ball.x), int(ball.y)) == 1)
    {
      if (ball.x < paddle.x + 20)
      {
        ball.xv = -35 + abs(paddle.x + 5 - ball.x) / 5;
      }
      else if (ball.x > paddle.x + 65)
      {
        ball.xv = 35 - abs(paddle.x + 100 - ball.x) / 5;
      }
      if (ball.xv > MAX_XV)
      {
        ball.xv = MAX_XV;
      }
      else if (ball.xv < -MAX_XV)
      {
        ball.xv = -MAX_XV;
      }
      if (ball.y + 5 < PADDLE_Y + 10)  //if the ball is not halfway past the paddle
      {
        if (ball.yv > 0)  //if the ball if moving downward
        {
          ball.yv = -abs(ball.yv);  //bounces the ball upward
        }
      }
      i = 0;
      while (i < 10)
      {
        init_particle(2, int(ball.x + 5), int(ball.y + 9), 15);
        i++;
      }
    }
  }
  if (ball.yv > MAX_YV)
  {
    ball.yv = MAX_YV;
  }
  else if (ball.yv < -MAX_YV)
  {
    ball.yv = -MAX_YV;
  }
  ball.y += ball.yv;
  blit(back_buffer, ball_buffer, int(ball.x), int(ball.y), 0, 0, 10, 10);
//  draw_sprite(back_buffer, (BITMAP *)graphics[BALL].dat, int(ball.x), int(ball.y));
//  create_dirty(int(ball.x) - 5, int(ball.y) - 5, 20, 20);
}





void do_paddle_movement()
{
  int i = 0;
//  rectfill(back_buffer, int(paddle.x), PADDLE_Y, int(paddle.x) + 100, PADDLE_Y + 20, 0);
  if ((key[KEY_LEFT]) && (paddle.x > -20))
  {
    paddle.xv -= .5;
    if (paddle.xv < -2.5 * paddle.speed)
    {
      paddle.xv = -2.5 * paddle.speed;
    }
  }
  else if ((key[KEY_RIGHT]) && (paddle.x + 80 < 800))
  {
    paddle.xv += .5;
    if (paddle.xv > 2.5 * paddle.speed)
    {
      paddle.xv = 2.5 * paddle.speed;
    }
  }
  else
  {
    paddle.xv /= 1.25;
  }
  if (key[KEY_UP])
  {
    paddle.polarity = 0;
  }
  if (key[KEY_DOWN])
  {
    paddle.polarity = 1;
  }
  if (key[KEY_SPACE])
  {
    paddle.polarity = -1;
  }
  paddle.x += paddle.xv;
/*  switch(paddle.polarity)
  {
    case -1:
      draw_sprite(back_buffer, (BITMAP *)graphics[PADDLE3].dat, int(paddle.x), PADDLE_Y);
      i = 0;
      while (i < 2)
      {
        if (charge[i] < 99.9)
        {
          charge[i] += .025;
        }
        else
        {
          charge[i] = 100;
        }
        i++;
      }
      break;
    case 0:
      draw_sprite(back_buffer, (BITMAP *)graphics[PADDLE1].dat, int(paddle.x), PADDLE_Y);
      if (charge[0] > .24)
      {
        charge[0] -= .25;
      }
      else
      {
        paddle.polarity = -1;
      }
      break;
    case 1:
      draw_sprite(back_buffer, (BITMAP *)graphics[PADDLE2].dat, int(paddle.x), PADDLE_Y);
      if (charge[1] > .24)
      {
        charge[1] -= .25;
      }
      else
      {
        paddle.polarity = -1;
      }
      break;
  }
  create_dirty(int(paddle.x) - 5, PADDLE_Y, 110, 20);*/
}





void draw_paddle()
{
  int i;
  switch(paddle.polarity)
  {
    case -1:
      draw_sprite(back_buffer, (BITMAP *)graphics[PADDLE3].dat, int(paddle.x), PADDLE_Y);
      i = 0;
      while (i < 2)
      {
        if (charge[i] < 99.9)
        {
          charge[i] += .025;
        }
        else
        {
          charge[i] = 100;
        }
        i++;
      }
      break;
    case 0:
      draw_sprite(back_buffer, (BITMAP *)graphics[PADDLE1].dat, int(paddle.x), PADDLE_Y);
      if (charge[0] > .24)
      {
        charge[0] -= .25;
      }
      else
      {
        paddle.polarity = -1;
      }
      break;
    case 1:
      draw_sprite(back_buffer, (BITMAP *)graphics[PADDLE2].dat, int(paddle.x), PADDLE_Y);
      if (charge[1] > .24)
      {
        charge[1] -= .25;
      }
      else
      {
        paddle.polarity = -1;
      }
      break;
  }
  create_dirty(int(paddle.x) - 5, PADDLE_Y, 110, 20);
}





int draw_blocks()
{
  int i;
  int level_cleared = 1;
  int y = 0;
  int x;
  int q;
  while (y < 40)
  {
    x = 0;
    while (x < 31)
    {
      if (block[x][y][level].type != 0)
      {
        if (block[x][y][level].temp > 0)
        {
          block[x][y][level].temp--;
        }
/*        if (pixel_here(block[x][y][level].x, block[x][y][level].y, 25, 12) != -1)
        {
          switch (block[x][y][level].type)
          {
            case 1:  //normal
              draw_sprite(back_buffer, (BITMAP *)graphics[BLOCK1].dat, block[x][y][level].x, block[x][y][level].y);
              break;
            case 2:  //explosive
              draw_sprite(back_buffer, (BITMAP *)graphics[BLOCK2].dat, block[x][y][level].x, block[x][y][level].y);
              break;
            case 3:  //strong
              draw_sprite(back_buffer, (BITMAP *)graphics[BLOCK3].dat, block[x][y][level].x, block[x][y][level].y);
              break;
          }
        }*/
        level_cleared = 0;
/*        switch (block[x][y][level].type)
        {
          case 1:  //normal
            draw_sprite(back_buffer, (BITMAP *)graphics[BLOCK1].dat, block[x][y][level].x, block[x][y][level].y);
            level_cleared = 0;  //if a block is drawn, the level isn't over
            break;
          case 2:  //explosive
            draw_sprite(back_buffer, (BITMAP *)graphics[BLOCK2].dat, block[x][y][level].x, block[x][y][level].y);
            level_cleared = 0;  //if a block is drawn, the level isn't over
            break;
          case 3:  //strong
            draw_sprite(back_buffer, (BITMAP *)graphics[BLOCK3].dat, block[x][y][level].x, block[x][y][level].y);
            level_cleared = 0;  //if a block is drawn, the level isn't over
            break;
        }*/
        if (check_pp_collision((BITMAP *)graphics[BLOCK1].dat, (BITMAP *)graphics[BALL].dat, block[x][y][level].x, block[x][y][level].y, int(ball.x), int(ball.y)) == 1)
        {
          if (ball.x > block[x][y][level].x + 12)
          {
            ball.xv = abs(ball.xv);
          }
          if (ball.x + 10 < block[x][y][level].x + 12)
          {
            ball.xv = -abs(ball.xv);
          }
          if (ball.y + 10 < block[x][y][level].y + 6)
          {
            ball.yv = -abs(ball.yv);
          }
          if (ball.y > block[x][y][level].y + 6)
          {
            ball.yv = abs(ball.yv);
          }
          if (block[x][y][level].type == 2)
          {
            rectfill(back_buffer, block[x][y][level].x, block[x][y][level].y, block[x][y][level].x + 24, block[x][y][level].y + 11, 0);
            create_dirty(block[x][y][level].x, block[x][y][level].y, 25, 12);
            clear_particles_here(block[x][y][level].x, block[x][y][level].y, 25, 12);
            explode_blocks(x, y, level, 0);
            block[x][y][level].type = 0;
          }
          else if (block[x][y][level].type == 3)
          {
            block[x][y][level].type = 1;
            draw_sprite(back_buffer, (BITMAP *)graphics[BLOCK1].dat, block[x][y][level].x, block[x][y][level].y);
            create_dirty(block[x][y][level].x, block[x][y][level].y, 25, 12);
            block[x][y][level].temp = 2;  //so this block isn't instantly destoyed
          }                                    //   |
          else                                 //   |
          {                                    //   |
            if (block[x][y][level].temp == 0)  //<--|
            {
              rectfill(back_buffer, block[x][y][level].x, block[x][y][level].y, block[x][y][level].x + 24, block[x][y][level].y + 11, 0);
              create_dirty(block[x][y][level].x, block[x][y][level].y, 25, 12);
              clear_particles_here(block[x][y][level].x, block[x][y][level].y, 25, 12);
              block[x][y][level].type = 0;
            }
          }
          i = 0;
          while (i < 15)
          {
            init_particle(1, block[x][y][level].x + 12, block[x][y][level].y + 6, 14);
            i++;
          }
          if (random()%20 == 1)
          {
            create_powup(block[x][y][level].x, block[x][y][level].y);
            totpowup++;  //total powup count increases (used in credits)
          }
        }
        else if (check_bb_collision_general(block[x][y][level].x, block[x][y][level].y, 25, 12, int(ball.x), int(ball.y), 10, 10) == 1)
        {
          switch (block[x][y][level].type)
          {
            case 1:  //normal
              draw_sprite(back_buffer, (BITMAP *)graphics[BLOCK1].dat, block[x][y][level].x, block[x][y][level].y);
              break;
            case 2:  //explosive
              draw_sprite(back_buffer, (BITMAP *)graphics[BLOCK2].dat, block[x][y][level].x, block[x][y][level].y);
              break;
            case 3:  //strong
              draw_sprite(back_buffer, (BITMAP *)graphics[BLOCK3].dat, block[x][y][level].x, block[x][y][level].y);
              break;
          }
          create_dirty(block[x][y][level].x, block[x][y][level].y, 25, 12);
        }
      }
      x++;
    }
    y++;
  }
  return level_cleared;
}





void draw_stats()
{
  clear(stat_buffer);
  int y = stat_buffer->h;
  hline(stat_buffer, 0, 1, 800, 15);
  if (charge[0] > 0)
  {
    rectfill(stat_buffer, 1, 4, int(charge[0] * 3.5), y - 1, 32);
  }
  if (charge[1] > 0)
  {
    rectfill(stat_buffer, 799, 4, 800 - int(charge[1] * 3.5), y - 1, 40);
  }
  sprintf(msg, "%-1d", lives);
  textout_centre(stat_buffer, font, msg, 400, y / 2 - 5, 15);
  blit(stat_buffer, back_buffer, 0, 0, 0, PADDLE_Y + 20, stat_buffer->w, y);
  create_dirty(0, PADDLE_Y + 20, 800, y);
}





float abs(float z)
{
  if (z < 0)
  {
    return -z;
  }
  else
  {
    return z;
  }
}





void do_death_anim()
{
  static int tic = 100;
  static int rot = 0;
  static int stx = 100;
  static int sty = 20;
  clear(paddledeath);
  rectfill(back_buffer, int(paddle.x) - 1, PADDLE_Y - 50, int(paddle.x) + 100, PADDLE_Y + 20, 0);
  create_dirty(int(paddle.x) - 1, PADDLE_Y - 50, 101, 70);
  stretch_blit((BITMAP *)graphics[PADDLE3].dat, paddledeath, 0, 0, 100, 20, 100 - stx, 20 - sty, stx, sty);
  rotate_sprite(back_buffer, paddledeath, int(paddle.x), PADDLE_Y, itofix(rot));
  create_dirty(int(paddle.x), PADDLE_Y, 100, 20);
  rot += 2;
  if (rot > 256)
  {
    rot -= 256;
  }
  stx -= 1;
  if (tic % 5 == 0)
  {
    sty -= 1;
  }
  if (tic == 100)
  {
    lives--;  //player loses a life at the beginning of the death animation
    totdeath++;  //total death count increases by one (used in credits)
  }
  tic--;
  if (tic == 0)  //reset almost everything
  {
    clear(ball_buffer);
    death = 0;
    ball.x = 400;
    ball.y = PADDLE_Y - 15;
    ball.xv = 1.5;
    ball.yv = -1.5;
    ball.polarity = 1;
    paddle.polarity = -1;
    paddle.x = 350;
    paddle.xv = 0;
    paddle.speed = 1;
    paddle.fieldstrength = 1;
    charge[0] = 100;
    charge[1] = 100;
    tic = 100;
    rot = 0;
    stx = 100;
    sty = 20;
    if (lives <= 0)
    {
      gameover = 1;
    }
  }
}





void start_new_level()
{
  int i = 0;
  level++;
  if (level >= levels)
  {
    clear(back_buffer);
    create_dirty(0, 0, 800, 600);
    gameover = 2;  //go to credits screen
  }
  death = 0;
  ball.x = 400;
  ball.y = PADDLE_Y - 15;
  ball.xv = 1.5;
  ball.yv = -1.5;
  ball.polarity = 1;
  paddle.polarity = -1;
  paddle.x = 350;
  paddle.xv = 0;
  paddle.speed = 1;
  paddle.fieldstrength = 1;
  charge[0] = 100;
  charge[1] = 100;
  initialized = 0;
  while (i < 6)
  {
    powup[i].type = 0;
    i++;
  }
}





void init_particle(int type, int x, int y, int color)
{
  int q;
  int a;
  if (numparticles < MAX_PARTICLES - 1)
  {
    numparticles++;
    q = find_free_particle();
    if (q != -1)
    {
      particle[q].oldcolor = getpixel(back_buffer, x, y);
      particle[q].x = float(x);
      particle[q].y = float(y);
      particle[q].type = type;
      particle[q].color = color;
      switch(particle[q].type)
      {
        case 1:
          particle[q].xv = (float(random()%300) / 100) * float(randposneg());
          particle[q].yv = (float(random()%100) / 100) * float(randposneg());
          particle[q].time = 35;
          break;
        case 2:
          particle[q].xv = (float(random()%200) / 100) * float(randposneg());
          particle[q].yv = -(float(random()%100) / 100);
          particle[q].time = 15;
          break;
      }
    }
  }
}





void clear_particles()
{
  int i = 0;
  while (i < numparticles)
  {
    if (particle[i].type != 0)
    {
      putpixel(back_buffer, int(particle[i].x), int(particle[i].y), particle[i].oldcolor);
      create_dirty(int(particle[i].x), int(particle[i].y), 1, 1);
    }
    i++;
  }
  i = 0;
  while (i < numparticles)
  {
    switch(particle[i].type)
    {
      case 1:
        particle[i].x += particle[i].xv;
        particle[i].y += particle[i].yv;
        particle[i].yv += .1;
        particle[i].oldcolor = getpixel(back_buffer, int(particle[i].x), int(particle[i].y));
        break;
      case 2:
        particle[i].x += particle[i].xv;
        particle[i].y += particle[i].yv;
        particle[i].oldcolor = getpixel(back_buffer, int(particle[i].x), int(particle[i].y));
        break;
    }
    i++;
  }
}





void do_particles()
{
  int i = 0;
  while (i < numparticles)
  {
    switch(particle[i].type)
    {
      case 1:
        putpixel(back_buffer, int(particle[i].x), int(particle[i].y), particle[i].color);
        create_dirty(int(particle[i].x), int(particle[i].y), 1, 1);
        break;
      case 2:
        putpixel(back_buffer, int(particle[i].x), int(particle[i].y), particle[i].color);
        create_dirty(int(particle[i].x), int(particle[i].y), 1, 1);
        break;
    }
    particle[i].time--;
    if (particle[i].time <= 0)
    {
      putpixel(back_buffer, int(particle[i].x), int(particle[i].y), particle[i].oldcolor);
      create_dirty(int(particle[i].x), int(particle[i].y), 1, 1);
      particle[i].type = 0;
    }
    i++;
  }
  while ((particle[numparticles - 1].type == 0) && (numparticles > 0))
  {
    numparticles--;  //this is so do_particles only loops through the
  }                  //number of particles that are actually active
}





int randposneg()  //returns either 1 or -1 in int form
{
  int r = random()%2;
  if (r == 0)
  {
    r = -1;
  }
  return r;
}





void kill_particles()
{
  int i = 0;
  while (i < numparticles)
  {
    particle[i].type = 0;
    particle[i].oldcolor = 0;
    particle[i].time = 0;
    i++;
  }
}





int find_free_particle()
{
  int w = 0;
  while (w < MAX_PARTICLES)
  {
    if (particle[w].type != 0)
    {
      w++;
    }
    else
    {
      return w;
    }
  }
  return -1;
}





void clear_particles_here(int x, int y, int w, int h)
{
  int i = 0;
  while (i < numparticles)
  {
    if (particle[i].type != 0)
    {
      if check_bb_collision_general(x, y, w, h, int(particle[i].x), int(particle[i].y), 1, 1)
      {
        particle[i].oldcolor = 0;
      }
    }
    i++;
  }
}





int pixel_here(int x, int y, int w, int h)
{
  int i;
  while (i < numparticles)
  {
    if (particle[i].type != 0)
    {
      if check_bb_collision_general(x, y, w, h, int(particle[i].x), int(particle[i].y), 1, 1)
      {
        return i;
      }
    }
    i++;
  }
  return -1;
}





void create_powup(int x, int y)
{
  int w = random()%9;
  int i = 0;
  while (i < 5)
  {
    if (powup[i].type <= 0)
    {
      powup[i].type = w + 1;
      powup[i].x = float(x);
      powup[i].y = float(y);
      powup[i].xv = (((random()%200) / 100) + .2) * float(randposneg());
      powup[i].yv = (random()%200) / 100;
      blit(back_buffer, powup_buffer[i], int(powup[i].x), int(powup[i].y), 0, 0, 20, 20);
      i = 5;
    }
    else
    {
      i++;
    }
  }
}





void do_powup()
{
  int i = 0;
  int z;
  while (i < 5)
  {
    if (powup[i].type > 0)
    {
      z = POWUP1 + powup[i].type - 1;
//      rectfill(back_buffer, int(powup[i].x), int(powup[i].y), int(powup[i].x) + 19, int(powup[i].y) + 19, 0);
//      blit(powup_buffer[i], back_buffer, 0, 0, int(powup[i].x), int(powup[i].y), 20, 20);
//      create_dirty(int(powup[i].x), int(powup[i].y), 20, 20);
      powup[i].x += powup[i].xv;
      powup[i].y += powup[i].yv;
      blit(back_buffer, powup_buffer[i], int(powup[i].x), int(powup[i].y), 0, 0, 20, 20);
      powup[i].yv += .03;
      if (powup[i].y > 600)
      {
        powup[i].type = 0;
      }
      if ((powup[i].x < 1) || (powup[i].x + 20 > 799))
      {
        powup[i].xv *= -1;
      }
    }
    i++;
  }
}





void draw_powup()
{
  int z;
  int i = 0;
  while (i < 5)
  {
    if (powup[i].type > 0)
    {
      z = POWUP1 + powup[i].type - 1;
      draw_sprite(back_buffer, (BITMAP *)graphics[z].dat, int(powup[i].x), int(powup[i].y));
      create_dirty(int(powup[i].x), int(powup[i].y), 20, 20);
      if (check_pp_collision((BITMAP *)graphics[POWUP1].dat, (BITMAP *)graphics[PADDLE1].dat, int(powup[i].x), int(powup[i].y), int(paddle.x), PADDLE_Y) == 1)
      {
        rectfill(back_buffer, int(powup[i].x), int(powup[i].y), int(powup[i].x) + 19, int(powup[i].y) + 19, 0);
//        blit(powup_buffer[i], back_buffer, 0, 0, int(powup[i].x), int(powup[i].y), 20, 20);
        create_dirty(int(powup[i].x), int(powup[i].y), 20, 20);
        activate_powup(powup[i].type);
        powup[i].type = 0;
      }
    }
    i++;
  }
}





void activate_powup(int type)
{
  switch(type)
  {
    case 1:  //full replenish
      charge[0] = charge[1] = 100;
      break;
    case 2:  //slow ball
      ball.xv /= 2;
      ball.yv /= 2;
      break;
    case 3:  //fast paddle
      paddle.speed = 2;
      break;
    case 4:  //blue replenish
      charge[0] = 100;
      break;
    case 5:  //red replenish
      charge[1] = 100;
      break;
    case 6:  //more powerful magnet
      paddle.fieldstrength = 2;
      break;
    case 7:  //fast ball
      ball.xv *= 2;
      ball.yv *= 2;
      break;
    case 8:  //kill paddle
      death = 1;
      break;
    case 9:  //extra paddle
      lives++;
      break;
  }
}





void explode_blocks(int x, int y, int level, int direction)
{  //direction is the direction not to do: 1=up, 2=down, 3=left, 4=right
  int i;
  if ((x > 0) && (direction != 3))
  {
    if (block[x - 1][y][level].type != 0)
    {
      if (block[x - 1][y][level].type == 2)  //explosive block
      {
        block[x - 1][y][level].type = 0;
        explode_blocks(x - 1, y, level, 4);
      }
      rectfill(back_buffer, block[x - 1][y][level].x, block[x - 1][y][level].y, block[x - 1][y][level].x + 24, block[x - 1][y][level].y + 11, 0);
      block[x - 1][y][level].type = 0;
      create_dirty(block[x - 1][y][level].x, block[x - 1][y][level].y, 25, 12);
      clear_particles_here(block[x - 1][y][level].x, block[x - 1][y][level].y, 25, 12);
      i = 0;
      while (i < 15)
      {
        init_particle(1, block[x - 1][y][level].x + 12, block[x - 1][y][level].y + 6, 14);
        i++;
      }
    }
  }
  if ((x < 30) && (direction != 4))
  {
    if (block[x + 1][y][level].type != 0)
    {
      if (block[x + 1][y][level].type == 2)
      {
        block[x + 1][y][level].type = 0;
        explode_blocks(x + 1, y, level, 3);
      }
      rectfill(back_buffer, block[x + 1][y][level].x, block[x + 1][y][level].y, block[x + 1][y][level].x + 24, block[x + 1][y][level].y + 11, 0);
      block[x + 1][y][level].type = 0;
      create_dirty(block[x + 1][y][level].x, block[x + 1][y][level].y, 25, 12);
      clear_particles_here(block[x + 1][y][level].x, block[x + 1][y][level].y, 25, 12);
      i = 0;
      while (i < 15)
      {
        init_particle(1, block[x + 1][y][level].x + 12, block[x + 1][y][level].y + 6, 14);
        i++;
      }
    }
  }
  if ((y > 0) && (direction != 1))
  {
    if (block[x][y - 1][level].type != 0)
    {
      if (block[x][y - 1][level].type == 2)
      {
        block[x][y - 1][level].type = 0;
        explode_blocks(x, y - 1, level, 2);
      }
      rectfill(back_buffer, block[x][y - 1][level].x, block[x][y - 1][level].y, block[x][y - 1][level].x + 24, block[x][y - 1][level].y + 11, 0);
      block[x][y - 1][level].type = 0;
      create_dirty(block[x][y - 1][level].x, block[x][y - 1][level].y, 25, 12);
      clear_particles_here(block[x][y - 1][level].x, block[x][y - 1][level].y, 25, 12);
      i = 0;
      while (i < 15)
      {
        init_particle(1, block[x][y - 1][level].x + 12, block[x][y - 1][level].y + 6, 14);
        i++;
      }
    }
  }
  if ((y < 39) && (direction != 2))
  {
    if (block[x][y + 1][level].type != 0)
    {
      if (block[x][y + 1][level].type == 2)
      {
        block[x][y + 1][level].type = 0;
        explode_blocks(x, y + 1, level, 1);
      }
      rectfill(back_buffer, block[x][y + 1][level].x, block[x][y + 1][level].y, block[x][y + 1][level].x + 24, block[x][y + 1][level].y + 11, 0);
      block[x][y + 1][level].type = 0;
      create_dirty(block[x][y + 1][level].x, block[x][y + 1][level].y, 25, 12);
      clear_particles_here(block[x][y + 1][level].x, block[x][y + 1][level].y, 25, 12);
      i = 0;
      while (i < 15)
      {
        init_particle(1, block[x][y + 1][level].x + 12, block[x][y + 1][level].y + 6, 14);
        i++;
      }
    }
  }
}





void draw_everything()
{
  clear(back_buffer);
  int y = 0;
  int x;
  while (y < 40)
  {
    x = 0;
    while (x < 31)
    {
      if (block[x][y][level].type != 0)
      {
        switch (block[x][y][level].type)
        {
          case 1:  //normal
            draw_sprite(back_buffer, (BITMAP *)graphics[BLOCK1].dat, block[x][y][level].x, block[x][y][level].y);
            break;
          case 2:  //explosive
            draw_sprite(back_buffer, (BITMAP *)graphics[BLOCK2].dat, block[x][y][level].x, block[x][y][level].y);
            break;
          case 3:  //strong
            draw_sprite(back_buffer, (BITMAP *)graphics[BLOCK3].dat, block[x][y][level].x, block[x][y][level].y);
            break;
        }
      }
      x++;
    }
    y++;
  }
  draw_sprite(back_buffer, (BITMAP *)graphics[BALL].dat, int(ball.x), int(ball.y));
  draw_sprite(back_buffer, (BITMAP *)graphics[PADDLE3].dat, int(paddle.x), PADDLE_Y);
}





void do_credits()
{
  static int scroll = 600;
  int l;
  int l2;
  if (scroll > 200)
  {
    l = text_length(font, "Congratulations!");
    rectfill(back_buffer, 400 - l / 2, scroll, 400 + l / 2, scroll + 15, 0);
    textout_centre(back_buffer, font, "Congratulations!", 400, scroll, 10);
    create_dirty(400 - l / 2, scroll, l, 15);

    l = text_length(font, "Total Powerups Collected:");
    sprintf(msg, "%-1d", totpowup);
    l2 = text_length(font, msg);    
    rectfill(back_buffer, 300 - l, scroll + 30, 600 + l2, scroll + 45, 0);
    textout_right(back_buffer, font, "Total Powerups Collected:", 300, scroll + 30, 15);
    textout(back_buffer, font, msg, 600, scroll + 30, 10);
    create_dirty(300 - l, scroll + 30, 300 + l + l2, 15);

    l = text_length(font, "Total Deaths:");
    sprintf(msg, "%-1d", totdeath);
    l2 = text_length(font, msg);
    rectfill(back_buffer, 300 - l, scroll + 50, 600 + l2, scroll + 65, 0);
    textout_right(back_buffer, font, "Total Deaths:", 300, scroll + 50, 15);
    textout(back_buffer, font, msg, 600, scroll + 50, 10);
    create_dirty(300 - l, scroll + 50, 400 + l + l2, 15);
    
    l = text_length(font, "CREDITS");
    rectfill(back_buffer, 400 - l / 2, scroll + 80, 400 + l / 2, scroll + 95, 0);
    textout_centre(back_buffer, font, "CREDITS", 400, scroll + 80, 15);
    create_dirty(400 - l / 2, scroll + 80, l, 15);
    
    rectfill(back_buffer, 120, scroll + 100, 720, scroll + 130, 0);
    textout_right(back_buffer, font, "Everything:", 300, scroll + 100, 10);
    textout(back_buffer, font, "Kent deVillafranca", 500, scroll + 100, 10);
    textout_centre(back_buffer, font, "(Heavily influenced by DX-Ball)", 400, scroll + 115, 10);
    create_dirty(120, scroll + 100, 600, 30);
    
    scroll--;
  }
  else
  {
    textout_centre(back_buffer, font, "Press Enter", 400, 400, 15);
    create_dirty(320, 390, 160, 20);
    if (key[KEY_ENTER])
    {
      scroll = 600;
      gameover = -1;  //go to menu
      clear(back_buffer);
      create_dirty(0, 0, 800, 600);      
    }
  }
}
