#include <math.h>
#include <stdlib.h>
#include <time.h>
#include "allegro.h"
#include "rnd.h"
#include "timeloop.h"
#include "particle.h"
#include "res.h"
#include "warp.h"
#include "blur.h"

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

BITMAP *scrbuf, *blurbmp;
BITMAP *scrbufbig, *blurbmpbig;

WARP *the_warp;

void set_gradient_palette() {
 PALETTE pal;
 int c;

 for (c = 0; c < 256; c++) {
  pal[c].r = c * c / 1020;
  pal[c].g = c >> 2;
  pal[c].b = c * (255 - c) / 255;
 }

 set_palette(pal);
}

void update_spark(PARTICLE *p) {
 float xf, yf;

 get_warp_position(the_warp, p->x / WARP_XD, p->y / WARP_YD, &xf, &yf);

 p->xv += xf * 0.05;
 p->yv += yf * 0.05;

 p->x += p->xv;
 p->y += p->yv;

 if (p->x < 0 || p->x >= GFX_W ||
     p->y < 0 || p->y >= GFX_H) p->life = 0;
}

void draw_spark(PARTICLE *p) {
 int x = (int)p->x;
 int y = (int)p->y;
 int xl = (int)(p->x - p->xv);
 int yl = (int)(p->y - p->yv);

 line(scrbuf, xl, yl, x, y, 255);
}

void tl_initialise() {
 clear(scrbufbig);
 clear(blurbmpbig);
 the_warp = create_warp(GFX_W / WARP_XD + 1, GFX_H / WARP_YD + 1);
}

void tl_finish() {
 destroy_particles();
 destroy_warp(the_warp);
}

int tl_logic() {
 {
  int n;
  for (n = 0; n < 7; n++) {
   PARTICLE *p = new_particle();
   p->x = GFX_W >> 1;
   p->y = GFX_H >> 1;
   {
    float r = RND(1.5);
    float a = RND(2*M_PI);
    p->xv = r * cos(a);
    p->yv = r * sin(a);
   }
   p->update = update_spark;
   p->draw = draw_spark;
   p->freedata = 0;
  }
 }

 update_particles();

 while (keypressed()) {
  int k = readkey() >> 8;
  if (k == KEY_ESC) return 1;
 }

 propagate_warp(the_warp);

 warpblur(the_warp, scrbufbig, blurbmp);

 (int)scrbuf  = (int)scrbuf ^ (int)blurbmp; //swap
 (int)blurbmp = (int)scrbuf ^ (int)blurbmp; //the
 (int)scrbuf  = (int)scrbuf ^ (int)blurbmp; //bitmaps

 (int)scrbufbig  = (int)scrbufbig ^ (int)blurbmpbig; //swap
 (int)blurbmpbig = (int)scrbufbig ^ (int)blurbmpbig; //the
 (int)scrbufbig  = (int)scrbufbig ^ (int)blurbmpbig; //bitmaps

 draw_particles();

 return 0;
}

void tl_draw() {
 blit(scrbuf, screen, 0, 0, 0, 0, scrbuf->w, scrbuf->h);
}

int main() {
 srandom(time(0));

 allegro_init();
 install_timer();
 install_keyboard();

 initialise_timeloop();

 if (set_gfx_mode(GFX_AUTODETECT, GFX_W, GFX_H, 0, 0)) {
  allegro_exit();
  allegro_message("Failed to set graphics mode\n%s\n", allegro_error);
  return 1;
 }

 set_gradient_palette();

 initialise_warpblur();

 scrbufbig = create_bitmap(GFX_W + 2*BIGBORDER, GFX_H + 2*BIGBORDER);
 blurbmpbig = create_bitmap(GFX_W + 2*BIGBORDER, GFX_H + 2*BIGBORDER);

 scrbuf = create_sub_bitmap(scrbufbig, BIGBORDER, BIGBORDER, GFX_W, GFX_H);
 blurbmp = create_sub_bitmap(blurbmpbig, BIGBORDER, BIGBORDER, GFX_W, GFX_H);

 timeloop(BPS_TO_TIMER(20), tl_initialise, tl_finish, tl_logic, tl_draw);

 destroy_bitmap(blurbmp);
 destroy_bitmap(scrbuf);

 destroy_bitmap(blurbmpbig);
 destroy_bitmap(scrbufbig);

 return 0;
} END_OF_MAIN();
