#include "allegro.h"
#include "timeloop.h"

volatile int timer_flag;

void timer_handler() {
 timer_flag = 1;
} END_OF_FUNCTION(timer_handler);

void initialise_timeloop() {
 LOCK_FUNCTION(timer_handler);
 LOCK_VARIABLE(timer_flag);
}

/* This loop will not skip frames when the program is running too slowly,
   but it will ensure that the program does not run too fast.
*/
void timeloop(int rate, void (*initialise)(void),
                        void (*finish)(void),
                        int  (*logic)(void),
                        void (*draw)(void)) {

 int ex;

 initialise();

 timer_flag = 0;
 install_int_ex(timer_handler, rate);

 do {
  draw();

  while (timer_flag == 0) { }
  timer_flag = 0;

  ex = logic();

 } while (ex == 0);

 finish();
}
