#include <stdlib.h>
#include "particle.h"

PARTICLE *first_particle = 0;

PARTICLE *new_particle() {
 PARTICLE *p = malloc(sizeof(PARTICLE));
 p->life = -1;
 p->next = first_particle;
 first_particle = p;
 return p;
}

void update_particles() {
 {
  PARTICLE *p = first_particle;
  while (p) {
   p->update(p);
   p = p->next;
  }
 }

 {
  PARTICLE **pp = &first_particle;
  while (*pp) {
   PARTICLE *p = *pp;
   if (p->life) {
    pp = &p->next;
   } else {
    *pp = p->next;
    if (p->freedata) p->freedata(p->data);
    free(p);
   }
  }
 }
}

void draw_particles() {
 PARTICLE *p = first_particle;
 while (p) {
  p->draw(p);
  p = p->next;
 }
}

void destroy_particles() {
 PARTICLE *p = first_particle;
 first_particle = 0;
 while (p) {
  PARTICLE *n = p->next;
  if (p->freedata) p->freedata(p->data);
  free(p);
  p = n;
 }
}
