#include <string.h>
#include "allegro.h"
#include "res.h"
#include "warp.h"
#include "blur.h"

/*
src must be bigger than dst by a border of BIGBORDER on each side.
This eliminates the need for a condition when displacing points.
*/

typedef struct {
 fixed x, y;
 fixed xd, yd;
} WARPBLUR_POINT;

WARPBLUR_POINT pnt;
WARPBLUR_POINT row[GFX_W / WARP_XD + 1];

unsigned char reduce[2048];

void initialise_warpblur() {
 int n;
 for (n = 0; n < 2048; n++) reduce[n] = n * 31 / 256;
}

void warpblur(WARP *warp, BITMAP *src, BITMAP *dst) {
 int xw, yw, xs, ys, xe, ye, x, y;
 unsigned char *d;

 /* initialise row[] to the top of the warp array */
 for (xw = 0; xw < GFX_W / WARP_XD + 1; xw++) {
  row[xw].x = ftofix(warp->line[0][xw].x);
  row[xw].y = ftofix(warp->line[0][xw].y);
 }

 /* for each row of the warp array */
 for (yw = 0, ys = 0, ye = WARP_YD;
      yw < GFX_H / WARP_YD;
      yw++, ys += WARP_YD, ye += WARP_YD) {

  /* prepare to interpolate row[] */
  for (xw = 0; xw < GFX_W / WARP_XD + 1; xw++) {
   row[xw].xd = (ftofix(warp->line[yw+1][xw].x) - row[xw].x) / WARP_YD;
   row[xw].yd = (ftofix(warp->line[yw+1][xw].y) - row[xw].y) / WARP_YD;
  }

  /* for each row of pixels */
  for (y = ys; y < ye; y++) {

   /* initialise pnt to the left of row[] */
   pnt.x = row[0].x;
   pnt.y = row[0].y;

   /* for each point in row[] */
   for (xw = 0, xs = 0, xe = WARP_XD;
        xw < GFX_W / WARP_XD;
        xw++, xs += WARP_XD, xe += WARP_XD) {

    /* prepare to interpolate pnt */
    pnt.xd = (row[xw+1].x - pnt.x) / WARP_XD;
    pnt.yd = (row[xw+1].y - pnt.y) / WARP_XD;

    /* for each pixel */
    d = dst->line[y];
    for (x = xs; x < xe; x++) {

     /* apply the blur effect */
     int ysrc = BIGBORDER + y + fixtoi(pnt.y);
     int xsrc = BIGBORDER + x + fixtoi(pnt.x);

     d[x] = reduce[(src->line[ysrc][xsrc] << 2) +
                    src->line[ysrc][xsrc-1] +
                    src->line[ysrc][xsrc+1] +
                    src->line[ysrc-1][xsrc] +
                    src->line[ysrc+1][xsrc]];

     /* interpolate pnt */
     pnt.x += pnt.xd;
     pnt.y += pnt.yd;
    }
   }

   /* interpolate row[] */
   for (xw = 0; xw < GFX_W / WARP_XD + 1; xw++) {
    row[xw].x += row[xw].xd;
    row[xw].y += row[xw].yd;
   }
  }
 }
}
