#include "score.h"

Score::Score() : Object(0, 0, 0, 0), value(0), delta(12), addedScore(0), fnt(font) {
}


Score::~Score() {
}


void Score::Setup(int x_, int y_, FONT *fnt_) {
	x = x_;
	y = y_;
	fnt = fnt_;
}


int Score::operator+=(int v) {
	addedScore += v;
	return value + v;
}


int Score::Get() {
	return value + addedScore;
}


void Score::Update() {
	if (addedScore > 2000) {
		delta = 240;
	}
	else if (addedScore > 400) {
		delta = 48;
	}
	else {
		delta = 12;
	}
	if (addedScore >= delta) {
		value += delta;
		addedScore -= delta;
	}
	else if (addedScore > 0) {
		value += addedScore;
		addedScore = 0;
	}
}


void Score::Draw(BITMAP *bmp) {
	static char buf[48];
	usprintf(buf, "%07d", value);
	textout_right(bmp, fnt, buf, x, y, makecol(96,96,96));
}


bool Score::Done() {
	return (addedScore == 0);
}


void Score::Reset() {
	value = 0;
	addedScore = 0;
	delta = 0;
}
