#ifndef		PARANOID_H
#define		PARANOID_H

#include "game.h"
#include "paddle.h"
#include "ball.h"
#include "grid.h"
#include "score.h"
#include "powerup.h"
#include "bullet.h"
#include "scroll.h"
#include "menus.h"
#include "highscore.h"
#include "dumbplayer.h"
#include "sinescroller.h"
#include <list>
using namespace std;

class Paranoid : public Game {
	private:
		Paddle paddle;
		list<Ball *> balls;
		list<Powerup *> powerups;
		list<Bullet *> bullets;
		Grid grid;
		int nBalls;
		Score score;
		int lives;
		static RGB_MAP rgbTable;
		int shotDelay, endLevelDelay, musicPlayerDelay;
		ScrollText *scrollingText;
		bool pressingSpace;
		DumbPlayer mPlayer;
		SineScroller *sinescroller;
	
		enum GameState {
			PLAYING_GAME,
			DOING_MAIN_MENU,
			DOING_OPTIONS_MENU,
			DOING_CREDITS_MENU,
			DOING_LEVEL_CLEARED_MENU,
			DOING_HSC_MENU,
			DOING_GAME_OVER_MENU,
			DOING_GAME_OVER_MENU2,
			DOING_HSC_EDIT_MENU,
			DOING_HSC_MENU2,
			DOING_HELP_MENU,
			DOING_SHORTCUTS_MENU,
			DOING_PAUSE_MENU,
			DOING_FINISHED_MENU,
			DOING_FINISHED_MENU2,
			DOING_EXIT_SCREEN
		};
		GameState gameState;
		int transitionCounter, maxTransitionCounter;
		
		MainMenu *mainMenu;
		OptionsMenu *optionsMenu;
		CreditsMenu *creditsMenu;
		LevelClearedMenu *levelClearedMenu;
		HighscoreMenu *hscMenu;
		GameOverMenu *gameOverMenu;
		HscEditMenu *hscEditMenu;
		HelpMenu *helpMenu;
		ShortcutsMenu *shortcutsMenu;
		PauseMenu *pauseMenu;
		FinishedMenu *finishedMenu;
		
		bool UpdateGame();
		void DrawGame();
		void DrawBackground();
		void DrawExitScreen();
		BITMAP *titleBitmap;
		
		Highscore *hscTable;
	
	protected:
		BITMAP *tvscreen;
		void TVBlit(BITMAP *src, BITMAP *dest);
		void RadarBlit(BITMAP *src, BITMAP *dest);
		void StretchBlit(BITMAP *src, BITMAP *dest);
	
		void NewGame();
		void NextLevel();
		void GameFinished();
		void GameOver();
		void Reset();
	
		void Draw();
		bool Update();
	
		void NewBall();
		void ExtraBalls();
		void UpdateBalls();
		void MakePowerup(int x, int y);
		void UpdatePowerups();
		void ChangeBallSpeed(float factor);
		void NewBullet();
		void UpdateBullets();
		bool CheckForNewLife(int delta);
		void RemoveBalls();

		virtual Error InitDoubleBuffer();
		virtual void DestroyDoubleBuffer();
		virtual void DrawDoubleBuffer();

	public:
		Paranoid();
		virtual ~Paranoid();

		Error Init();
};

#endif		//PARANOID_H
