#include "paddle.h"
#include "params.h"
#include <math.h>


Paddle::Paddle(int x_, int vx_) :
	Object(x_, 0, vx_, 0),
	min(0),
	max(SCREEN_W),
	ball(NULL),
	sticky(0),
	delta(0),
	toGrow(0),
	bullets(),
	ballVx(0.0f),
	ballVy(0.0f),
	ballOffset(0.75f)
{
}


Paddle::~Paddle() {
}


void Paddle::Update() {
	if (key[KEY_LEFT]) {
		vx -= acc;
		if (vx < -maxVx) {
			vx = -maxVx;
		}
	}
	else if (key[KEY_RIGHT]) {
		vx += acc;
		if (vx > maxVx) {
			vx = maxVx;
		}
	}
	else {
		if (fabs(vx) > 1.0f) {
			vx *= dec;
		}
		else {
			vx = 0.0f;
		}
	}
	
	//float oldx = x;
	
	w += delta;
	x -= (delta>>1);
	toGrow -= delta;
	if (toGrow == 0) {
		delta = 0;
	}
	
	x += vx;
	if (x < min) {
		x = (float)min;
		vx = -vx/2.0f;
	}
	else if (x+w > max) {
		x = (float)(max-w);
		vx = -vx/2.0f;
	}
	
	if (ball) {
		ball->SetX(GetX() + Width()*ballOffset - (ball->Width()>>1));

		if (key[KEY_SPACE]) {
			LaunchBall();
		}
	}
	
	if (sticky) {
		//--sticky;
		
		if (!sticky && ball) {
			LaunchBall();
		}
	}
}


void Paddle::LaunchBall() {
	if (!ball) return;
	
	float v = ballVx*ballVx + ballVy*ballVy;
	if (v < 0.25f) {
		v = 3.5f;
	}
	float bvx = 2*sqrt(v)*((MID(0.1f, ballOffset, 0.9f)) - 0.5f);
	if (bvx >= 0.0f) {
		if (bvx < Params::ballMinVx) {
			bvx = Params::ballMinVx;
		}
	}
	else {
		if (bvx > -Params::ballMinVx) {
			bvx = -Params::ballMinVx;
		}
	}
	float bvy = sqrt(v - bvx*bvx);
	if (bvy < Params::ballMinVy) bvy = Params::ballMinVy;
	ball->Launch(bvx, -bvy);
	
	ball = NULL;
}


bool Paddle::BounceBall(Ball *ball) {
	if (ball->GetVy() == 0.0f) return false;

	if (sticky && !(this->ball)) {
		GrabBall(ball);
	}
	else {
		float v = ball->GetVx()*ball->GetVx() + ball->GetVy()*ball->GetVy();
		float factor = (ball->GetX() + (ball->Width()>>1) - GetX()) / Width();
		factor = MID(0.1f, factor, 0.9f);
		float bvx = 2*sqrt(v) * (factor - 0.5f);
		if (bvx >= 0.0f) {
			if (bvx < Params::ballMinVx) {
				bvx = Params::ballMinVx;
			}
		}
		else {
			if (bvx > -Params::ballMinVx) {
				bvx = -Params::ballMinVx;
			}
		}
		float bvy = sqrt(v - bvx*bvx);
		if (bvy < Params::ballMinVy) bvy = Params::ballMinVy;
		ball->SetY(y);
		ball->Launch(bvx, -bvy);
	}
	
	return true;
}


void Paddle::GrabBall(Ball *ball) {
	if (this->ball) {
		LaunchBall();
	}
	
	this->ball = ball;
	ballVx = ball->GetVx();
	ballVy = ball->GetVy();
	ball->SetVx(0.0f);
	ball->SetVy(0.0f);
	ball->SetY(y);
	
	ballOffset = (ball->GetX() + ball->Width() - GetX()) / Width();
}


void Paddle::Draw(BITMAP *buffer) {
	int ix = (int)x;
	int iy = (int)y;
	int sw = sprite->w/3;
	int sh = sprite->h;
	
	blit(sprite, buffer, 0, 0, ix, iy, sw, sh);
	for (ix += sw; ix < x + Width() - sw; ix += sw) {
		blit(sprite, buffer, sw, 0, ix, iy, sw, sh);
	}
	blit(sprite, buffer, sw<<1, 0, (int)(x + Width() - sw), iy, sw, sh);
}


void Paddle::SetRange(int min, int max) {
	this->min = min;
	this->max = max;
	
	Initialize();
}


void Paddle::Initialize() {
	x = (min + max - w)/2;
	vx = 0.0f;
	maxVx = Params::paddleMaxSpeed;
	acc = Params::paddleAcceleration;
	dec = Params::paddleDeceleration;
}


void Paddle::SetY(int y) {
	this->y = y - h;
}


void Paddle::GiveBall(Ball *ball) {
	if (this->ball || bullets > 0) {
		LaunchBall();
	}
	this->ball = ball;
	//ballOffset = 0.75f;
	ball->SetX(x + ballOffset*w - (ball->Size()>>1));
	ball->SetY(y);
}


int Paddle::Range() {
	return max - w - min;
}


void Paddle::MakeSticky() {
	sticky = 1;
	bullets = 0;
}


void Paddle::Shrink() {
	if (Width() + toGrow > 16) {
		toGrow -= 8;
		if (toGrow > 0)
			delta = 2;
		else if (toGrow < 0)
			delta = -2;
		else
			delta = 0;
	}
}


void Paddle::Grow() {
	if (Width() + toGrow <= 40) {
		toGrow += 8;
		if (toGrow > 0)
			delta = 2;
		else if (toGrow < 0)
			delta = -2;
		else
			delta = 0;
	}
}


void Paddle::Reset() {
	sticky = 0;
	bullets = 0;
	toGrow = 24 - Width();
	delta = toGrow > 0 ? 2 : (toGrow < 0 ? -2 : 0);
	ballVx = 0.0f;
	ballVy = 0.0f;
	ball = NULL;
	//ballOffset = 0.75f;
}


void Paddle::GiveBullet() {
	if (sticky) {
		if (ball) {
			LaunchBall();
		}
		sticky = 0;
	}
	
	if (bullets < 3) {
		++bullets;
	}
}
