#include "menus.h"
#include "params.h"
#include "dataGfx.h"


MainMenu::MainMenu() : Menu() {
	AddItem(new MenuText("NEW GAME"));
	AddItem(new MenuText("RESUME GAME"));
	AddItem(new MenuText("OPTIONS"));
	AddItem(new MenuText("HIGH SCORES"));
	AddItem(new MenuText("HELP"));
	AddItem(new MenuText("SHORTCUTS"));
	AddItem(new MenuText("CREDITS"));
	AddItem(new MenuText("EXIT"));
	items[0]->Select();
}


bool MainMenu::Update() {
	Menu::Update();

	if (!keyCounter) {
		if (key[KEY_ENTER]) {
			keyCounter = maxKeyCounter;
			return true;
		}
	}

	return false;
}


///////////////////////////////////////////////////////////////////////////////


OptionsMenu::OptionsMenu() : Menu() {
	AddItem(new MenuToggle("FULLSCREEN", Params::fullscreen ? true : false));
	AddItem(new MenuToggle("ENABLE VSYNC", Params::vsync ? true : false));
	AddItem(new MenuToggle("LIMIT FRAMERATE", Params::unlimitedFPS ? false : true));
	AddItem(new MenuToggle("SHOW FRAMERATE", Params::showFPS ? true : false));
	AddItem(new MenuSlider("SOUND - ", Params::soundVolume/16, 16, 60));
	AddItem(new MenuSlider("MUSIC - ", Params::musicVolume/16, 16, 60));
	AddItem(new MenuText("BACK"));
	items[MENU_BACK]->Select();
	currentState = MENU_BACK;
}


bool OptionsMenu::Update() {
	Menu::Update();

	if (keyCounter == 0) {
		if (key[KEY_ENTER]) {
			keyCounter = maxKeyCounter;
			return true;
		}
	}
	
	int input = items[currentState]->AcceptInput();
	if (input != -1) {
		switch (currentState) {
			case OPTION_FULLSCREEN:
				Params::fullscreen = input;
				break;
			
			case OPTION_VSYNC:
				Params::vsync = input;
				break;
			
			case OPTION_LIMIT_FPS:
				Params::unlimitedFPS = input ? 0 : 1;
				break;
			
			case OPTION_SHOW_FPS:
				Params::showFPS = input;
				break;
			
			case OPTION_SOUND_VOLUME:
				Params::soundVolume = input*16;
				break;
			
			case OPTION_MUSIC_VOLUME:
				Params::musicVolume = input*16;
				break;
		};
	}

	return false;
}


///////////////////////////////////////////////////////////////////////////////


CreditsMenu::CreditsMenu() : Menu() {
	AddItem(new MenuText("PARANOID v1.0"));
	AddItem(new MenuText("COPYRIGHT (C) 2003 BY"));
	AddItem(new MenuText("MIRAN AMON"));
	AddItem(new MenuText(""));
	AddItem(new MenuText("CODE, GRAPHICS AND SOUND"));
	AddItem(new MenuText("BY MIRAN AMON"));
	AddItem(new MenuText(""));
	AddItem(new MenuText("THIS GAME WAS MADE WITH"));
	AddItem(new MenuText("ALLEGRO"));
	Disable();
}



///////////////////////////////////////////////////////////////////////////////


LevelClearedMenu::LevelClearedMenu() : Menu() {
	AddItem(new MenuText("LEVEL CLEARED"));
	AddItem(new MenuText("PREPARE"));
	AddItem(new MenuText("FOR NEXT LEVEL"));
	Disable();
}


///////////////////////////////////////////////////////////////////////////////


HighscoreMenu::HighscoreMenu(Highscore *hsc) : Menu() {
	list<HighscoreItem *> items = hsc->GetTable();
	
	AddItem(new MenuText("    NAME     LEVEL SCORE"));
	int rank = 0;
	char buf[32];
	char name[9];
	HighscoreItem *item;
	for (list<HighscoreItem *>::iterator i = items.begin(); i != items.end(); ++i) {
		item = *i;
		ustrncpy(name, item->name, 8);
		name[8] = 0;
		usprintf(buf, "%2d. %-8s %3d %7d", ++rank, name, item->level, item->score);
		AddItem(new MenuText(buf));
	}
	Disable();
}


///////////////////////////////////////////////////////////////////////////////


GameOverMenu::GameOverMenu() : Menu() {
	AddItem(new MenuText("GAME OVER"));
	Disable();
}


///////////////////////////////////////////////////////////////////////////////


HscEditMenu::HscEditMenu() : Menu() {
	AddItem(new MenuText("CONGRATULATIONS!"));
	AddItem(new MenuText("YOU HAVE A HIGHSCORE"));
	AddItem(new MenuText("ENTER YOUR NAME"));
	AddItem(new MenuEdit(""));
	
	for (int i=0; i<3; ++i) {
		items[i]->Disable();
	}
	items[3]->Select();
	currentState = 3;
}


bool HscEditMenu::Update() {
	Menu::Update();

	if (keyCounter == 0) {
		if (key[KEY_ENTER]) {
			keyCounter = maxKeyCounter;
			return true;
		}
	}
	
	items[currentState]->AcceptInput();
	return false;
}


char *HscEditMenu::GetText() {
	return ((MenuEdit *)items[3])->GetText();
}


///////////////////////////////////////////////////////////////////////////////


HelpMenu::HelpMenu(DATAFILE *d) : Menu() {
	AddItem(new MenuBitmap("LEFT, RIGHT, SPACE", (BITMAP *)d[SPRITE_PADDLE].dat, NULL));
	AddItem(new MenuBitmap("BREAK 1x", (BITMAP *)d[BLOCK1].dat, NULL));
	AddItem(new MenuBitmap("BREAK 2x", (BITMAP *)d[BLOCK2].dat, NULL));
	AddItem(new MenuBitmap("BREAK 3x", (BITMAP *)d[BLOCK3].dat, NULL));
	AddItem(new MenuBitmap("BREAK 4x", (BITMAP *)d[BLOCK4].dat, NULL));
	AddItem(new MenuBitmap("UNBREAKABLE", (BITMAP *)d[BLOCK0].dat, NULL));
	AddItem(new MenuBitmap("RESIZE PADDLE", (BITMAP *)d[POWERUP00].dat, (BITMAP *)d[POWERUP01].dat));
	AddItem(new MenuBitmap("CHANGE BALL SPEED", (BITMAP *)d[POWERUP03].dat, (BITMAP *)d[POWERUP02].dat));
	AddItem(new MenuBitmap("MONEY", (BITMAP *)d[POWERUP04].dat, (BITMAP *)d[POWERUP05].dat));
	AddItem(new MenuBitmap("STICKY PADDLE", (BITMAP *)d[POWERUP06].dat, NULL));
	AddItem(new MenuBitmap("EXTRA BALL", (BITMAP *)d[POWERUP07].dat, NULL));
	AddItem(new MenuBitmap("BULLETS", (BITMAP *)d[POWERUP08].dat, NULL));
	AddItem(new MenuBitmap("EXTRA LIFE", (BITMAP *)d[POWERUP09].dat, NULL));
	Disable();
}


///////////////////////////////////////////////////////////////////////////////


ShortcutsMenu::ShortcutsMenu() : Menu() {
	AddItem(new MenuText("P - PAUSE"));
	AddItem(new MenuText("Q - ZAP BALLS"));
	AddItem(new MenuText("8 - MUSIC VOLUME UP"));
	AddItem(new MenuText("2 - MUSIC VOLUME DOWN"));
	AddItem(new MenuText("9 - SOUND VOLUME UP"));
	AddItem(new MenuText("3 - SOUND VOLUME DOWN"));
	AddItem(new MenuText("4 - PREVIOUS TRACK"));
	AddItem(new MenuText("5 - REPLAY TRACK"));
	AddItem(new MenuText("6 - NEXT TRACK"));
	AddItem(new MenuText("F - TOGGLE FPS DISPLAY"));
	AddItem(new MenuText("U - TOGGLE FPS LIMITER"));
	AddItem(new MenuText("V - TOGGLE VSYNC"));
	AddItem(new MenuText("Y - TOGGLE YIELD TIMESLICE"));
	AddItem(new MenuText("M - CHANGE SCREEN MODE"));
	AddItem(new MenuText("PRTSCR - TAKE SCREENSHOT"));
	Disable();
}


///////////////////////////////////////////////////////////////////////////////


PauseMenu::PauseMenu() : Menu() {
	AddItem(new MenuText("PAUSED"));
	Disable();
}


///////////////////////////////////////////////////////////////////////////////


FinishedMenu::FinishedMenu() : Menu() {
	AddItem(new MenuText(""));
	AddItem(new MenuText("CONGRATULATIONS!"));
	AddItem(new MenuText(""));
	AddItem(new MenuText("YOU HAVE FINISHED"));
	AddItem(new MenuText("THE GAME"));
	AddItem(new MenuText(""));
	Disable();
}
