#include "menu.h"
#include "dataSounds.h"
#include "global.h"

BITMAP *Menu::back = NULL;
int Menu::maxKeyCounter = 8;
BITMAP *Menu::saved = NULL;


Menu::Menu() : currentState(0), counter(0), keyCounter(0), w(0), h(0), disabled(false) {
}


Menu::~Menu() {
	for (vector<MenuItem *>::iterator i = items.begin(); i != items.end(); ++i) {
		delete *i;
		*i = NULL;
	}
	
	items.clear();
}


void Menu::AddItem(MenuItem *item) {
	items.push_back(item);
	int nw = item->GetWidth() + 32;
	if (nw > w) {
		w = nw;
	}
	h += item->GetHeight();
}


bool Menu::Update() {
	for (vector<MenuItem *>::iterator i = items.begin(); i != items.end(); ++i) {
		(*i)->Update();
	}
	
	int oldSel = currentState;
	int newSel = oldSel;
	
	if (keyCounter) {
		--keyCounter;
		return false;
	}
	else if (!disabled) {
		if (key[KEY_UP]) {
			if (newSel == 0) {
				newSel = items.size();
			}
			while (newSel > 0) {
				--newSel;
				if (!items[newSel]->Disabled()) {
					break;
				}
				
				if (newSel == 0) {
					newSel = oldSel;
				}
			}
			if (currentState != newSel) {
				items[currentState]->Deselect();
				currentState = newSel;
				items[currentState]->Select();
				keyCounter = maxKeyCounter;
				PlaySample(SMP_BLOCK);
			}
		}
	
		if (key[KEY_DOWN]) {
			if (newSel == (signed)items.size()-1) {
				newSel = -1;
			}
			while (newSel < (signed)items.size()-1) {
				++newSel;
				if (!items[newSel]->Disabled()) {
					break;
				}
				
				if (newSel == (signed)items.size()-1) {
					newSel = oldSel;
				}
			}
			if (currentState != newSel) {
				items[currentState]->Deselect();
				currentState = newSel;
				items[currentState]->Select();
				keyCounter = maxKeyCounter;
				PlaySample(SMP_BLOCK);
			}
		}
	}
	
	if (key[KEY_ENTER]) {
		PlaySample(SMP_CLEAR);
	}
	
	return (key[KEY_ESC] || key[KEY_ENTER]);
}


void Menu::Draw(BITMAP *bmp) {
	int x = (bmp->w - w)>>1;
	int y = (bmp->h - h)>>1;
	int iy = y;
	int ih;
	
	DrawBack(bmp, x - back->w/3+1, y - back->h/3+1, w + 2*back->w/3-1, h + 2*back->h/3-1);
	
	for (vector<MenuItem *>::iterator i = items.begin(); i != items.end(); ++i) {
		ih = (*i)->GetHeight();
		(*i)->Draw(bmp, x, iy, w, ih);
		iy += ih;
	}
	
	//rect(bmp, x-1, y-1, x+w+1, iy+1, makecol(255,255,255));
}


void Menu::DrawBack(BITMAP *buf, int x, int y, int w, int h) {
	int bw = back->w/3;
	int bh = back->h/3;
	
	for (int i=x+bw; i<x+w-bw; i+=bw) {
		blit(back, buf, bw, 0, i, y, bw, bh);
	}
	for (int i=x+bw; i<x+w-bw; i+=bw) {
		blit(back, buf, bw, bh<<1, i, y+h-bh, bw, bh);
	}
	for (int j=y+bh; j<y+h-bh; j+=bh) {
		blit(back, buf, 0, bh, x, j, bw, bh);
	}
	for (int j=y+bh; j<y+h-bh; j+=bh) {
		blit(back, buf, bw<<1, bh, x+w-bw, j, bw, bh);
	}
	
	masked_blit(back, buf, 0, 0, x, y, bw, bh);
	masked_blit(back, buf, bw<<1, 0, x+w-bw, y, bw, bh);
	masked_blit(back, buf, 0, bh<<1, x, y+h-bh, bw, bh);
	masked_blit(back, buf, bw<<1, bh<<1, x+w-bw, y+h-bh, bw, bh);
}


void Menu::Start(BITMAP *bmp) {
	keyCounter = maxKeyCounter;
	
	saved = create_bitmap(w + 2*back->w/3, h + 2*back->h/3);

	int x = ((bmp->w - w)>>1) - back->w/3;
	int y = ((bmp->h - h)>>1) - back->h/3;
	int mw = saved->w;
	int mh =  saved->h;
	blit(bmp, saved, x, y, 0, 0, mw, mh);
}


void Menu::Stop(BITMAP *bmp) {
	int x = ((bmp->w - w)>>1) - back->w/3;
	int y = ((bmp->h - h)>>1) - back->h/3;
	int mw = saved->w;
	int mh =  saved->h;
	blit(saved, bmp, 0, 0, x, y, mw, mh);
	destroy_bitmap(saved);
	saved = NULL;
}


void Menu::Disable() {
	disabled = true;

	for (vector<MenuItem *>::iterator i = items.begin(); i != items.end(); ++i) {
		(*i)->Disable();
	}
}
