#include "ball.h"
#include "params.h"
#include "global.h"
#include <math.h>


Ball::Ball() :
	Object(0, 0, 0, 0),
	minX(0),
	maxX(SCREEN_W),
	minY(0),
	maxY(SCREEN_H),
	dead(false),
	wall(0)
{
}


Ball::~Ball() {
}


void Ball::Update() {
	wall = 0;
	x += vx;
	if (x < minX) {
		vx = -vx;
		x = minX;
		wall = 1;
	}
	else if (x + w >= maxX) {
		vx = -vx;
		x = (float)(maxX-w-1);
		wall = 2;
	}

	y += vy;
	if (y < minY) {
		vy = -vy;
		y = minY;
		wall = 3;
	}
	else if (y - h >= maxY) {
		dead = true;
		wall = 4;
	}

	ChangeSpeed(Params::ballAcceleration);
}


void Ball::BounceX() {
	vx = -vx;
	x += vx;
}


void Ball::BounceY() {
	vy = -vy;
	y += vy;
}


void Ball::Draw(BITMAP *buffer) {
	//rectfill(buffer, (int)x, (int)y, (int)x+size, (int)y+size, makecol(255,255,255));
	//draw_sprite(buffer, sprite, (int)x, (int)y);
	draw_sprite_f(buffer, sprite, x, y);
}


void Ball::SetRange(int minX, int maxX, int minY, int maxY) {
	this->minX = minX;
	this->maxX = maxX;
	this->minY = minY;
	this->maxY = maxY;
	
	Initialize();
}


void Ball::Initialize() {
	x = (minX + maxX - w)/2;
	y = (minY + maxY - h)/2;
	vx = 0.0f;
	vy = 0.0f;
	maxVx = maxVy = 6.0f;
}


void Ball::SetX(float x) {
	this->x = x - w/2.0f;
}


void Ball::SetY(float y) {
	this->y = y - h;
}


void Ball::Launch(float vx, float vy) {
	this->vx = vx;
	this->vy = vy;
	dead = false;
}


void Ball::ChangeSpeed(float factor) {
	vy *= factor;
	if (vy >= Params::ballMaxSpeed) {
		vy = Params::ballMaxSpeed;
	}

	vx *= factor;
	if (vx >= Params::ballMaxSpeed) {
		vx = Params::ballMaxSpeed;
	}
}
