#include "sinescroller.h"


SineScroller::SineScroller(const char *t) : A(12), freq(0.08f), phase(0.0f), text(NULL) {
	text = new char[ustrsizez(t)];
	ustrcpy(text, t);
	cw = text_length(font, "A");
}


SineScroller::~SineScroller() {
	delete [] text;
}


void SineScroller::Update() {
	phase += 0.08f;
}


void SineScroller::Draw(BITMAP *bmp) {
	int count = bmp->w / cw + 1;
	int iy = bmp->h - (int)A - 4 - text_height(font);
	int len = ustrlen(text);

	int x, y;
	int col = makecol(140,140,140);

	for (int ix = 0; ix < count; ix++) {
		x = ix*cw - ((int)(cw*phase)%cw);
		y = iy + (int)fn((float)x);
		textprintf(bmp, font, x, y, col, "%c", text[(int)(ix + phase)%len]);
	}
}
