#include "powerup.h"
#include "params.h"

Powerup::Powerup(int x_, int y_, int t, BITMAP *spr) : Object(x_, y_, 0, 1), type(t) {
	SetSprite(spr);
}

Powerup::~Powerup() {
	sprite = NULL;
}


void Powerup::Update() {
	y += vy;
}


void Powerup::Draw(BITMAP *bmp) {
	draw_sprite(bmp, sprite, x, y);
}


int Powerup::probability[N_OF_POWERUPS];

void Powerup::Init() {
	int i = 0;
	i += Params::pwuSizeUp;		probability[SIZEUP] = i;
	i += Params::pwuSizeDown;		probability[SIZEDOWN]  = i;
	i += Params::pwuSpeedUp;		probability[SPEEDUP] = i;
	i += Params::pwuSpeedDown;	probability[SPEEDDOWN] = i;
	i += Params::pwuMoney;		probability[MONEY] = i;
	i += Params::pwuMoneyBig;		probability[MONEYBIG] = i;
	i += Params::pwuGlue;			probability[GLUE] = i;
	i += Params::pwuExtraBall;		probability[MULTIBALL] = i;
	i += Params::pwuShoot;		probability[SHOOT] = i;
	i += Params::pwuExtraLife;		probability[EXTRALIFE] = i;
	i *= (int)(1.0f / Params::pwuRatio);	probability[N_OF_POWERUPS] = i;
}


int Powerup::RandomPowerup() {
	int rnd = rand() % probability[N_OF_POWERUPS];

	int count;
	for (count=0; count<N_OF_POWERUPS; count++) {
		if (rnd < probability[count])
			break;
	}

	if (count == N_OF_POWERUPS)
		return -1;
	else
		return count;
}
