#ifndef		PADDLE_H
#define		PADDLE_H

#include "object.h"
#include "ball.h"

class Paddle : public Object {
	protected:
		int min, max;
		Ball *ball;
	
		float x, vx, maxVx, acc, dec;
		void GrabBall(Ball *ball);
		int sticky;
		int delta, toGrow;
		int bullets;
	
		float ballVx, ballVy;
		float ballOffset;

	public:
		Paddle(int x_ = 0, int vx_ = 4);
		virtual ~Paddle();

		void Update();
		void Draw(BITMAP *buffer);
	
		void SetRange(int min, int max);
		void Initialize();
		float GetX() { return x; }
		float GetY() { return y; }
		void SetY(int y);
		void GiveBall(Ball *b);
		float Speed() { return vx; }
		int Range();
		bool BounceBall(Ball *b);
		void MakeSticky();
		void Shrink();
		void Grow();
		void Reset();
		void GiveBullet();
		void LaunchBall();
		int Bullets() { return bullets; }
};

#endif		//PADDLE_H
