#ifndef		MUSIC_PLAYER
#define		MUSIC_PLAYER

#include <allegro.h>
#include <list>
#include <vector>
using namespace std;

class MusicPlayer {
	protected:
		list<char *> playlist;
		vector<int> order;
		int index;
		bool isPlaying;
		int random;
		int loop;

	public:
		MusicPlayer();
		virtual ~MusicPlayer();

		virtual void Load();
		virtual void Play(int i = -1);
		virtual void Pause();
		virtual void Resume();
		virtual void Stop();
		virtual void Next();
		virtual void Previous();
		virtual void Select(int i);
		virtual bool IsPlaying();

		void AddFile(const char *file);
		void RemoveFile(int i);
		void ClearPlaylist();
		char *GetSelectedFilename();
		void LoadPlaylist(const char *file);
		void SetRandom(int r);
		void SetLoop(int l);
		virtual void Setup(const char *f, int random, int loop);
		void Shuffle();
		void Order();
};


#endif		//MUSIC_PLAYER
