#ifndef		MENUITEM_H
#define		MENUITEM_H

#include <allegro.h>

class MenuItem {
	protected:
		enum ItemState { NORMAL, SELECTED, DISABLED };
		ItemState currentState;
		int stateCounter;
		static int maxCounter;
		int keyCounter;
		static int maxKeyCounter;
		float colFactor;
		float dCF;
		
		virtual void DrawContent(BITMAP *bmp, int x, int y, int w, int h) = 0;

	public:
		MenuItem();
		virtual ~MenuItem();

		virtual void Update();
		virtual void Draw(BITMAP *bmp, int x, int y, int w, int h);
		virtual int AcceptInput() { return -1; }

		virtual int GetWidth() { return 8; }
		virtual int GetHeight();
		
		void Select();
		void Deselect();
		void Enable();
		void Disable();
		
		bool Disabled() { return (currentState == DISABLED); }
};


class MenuText : public MenuItem {
	protected:
		char *text;
		void DrawContent(BITMAP *bmp, int x, int y, int w, int h);
	
	public:
		MenuText(const char *t);
		virtual ~MenuText();
	
		int GetWidth();
};


class MenuToggle : public MenuText {
	protected:
		bool on;
		void DrawContent(BITMAP *bmp, int x, int y, int w, int h);
	
	public:
		MenuToggle(const char *t, bool on);
		virtual ~MenuToggle();
	
		int AcceptInput();
		int GetWidth();
};


class MenuEnum : public MenuText {
	protected:
		int sel;
		int maxSel;
		void DrawContent(BITMAP *bmp, int x, int y, int w, int h);
	
	public:
		MenuEnum(const char *t, int sel, int max);
		virtual ~MenuEnum();
	
		int AcceptInput();
		int GetWidth();
};


class MenuSlider : public MenuEnum {
	protected:
		int width;
		void DrawContent(BITMAP *bmp, int x, int y, int w, int h);
	
	public:
		MenuSlider(const char *t, int sel, int max, int w);
		virtual ~MenuSlider();
	
		int GetWidth();
		int AcceptInput();
};


class MenuEdit : public MenuItem {
	protected:
		char text[9];
		int cur;
		int counter;
		void DrawContent(BITMAP *bmp, int x, int y, int w, int h);
	
	public:
		MenuEdit(const char *t);
		virtual ~MenuEdit();
	
		int GetWidth();
		int AcceptInput();
		char *GetText() { return text; }
};


class MenuBitmap : public MenuText {
	protected:
		BITMAP *icon1, *icon2;
		void DrawContent(BITMAP *bmp, int x, int y, int w, int h);
	
	public:
		MenuBitmap(const char *t, BITMAP *b1, BITMAP *b2);
		virtual ~MenuBitmap() {}
	
		int GetWidth();
};




#endif		//MENUITEM_H
