#include "highscore.h"


HighscoreItem::HighscoreItem(const char *n, int s, int l) : score(s), level(l) {
	ustrncpy(name, n, 8);
}


HighscoreItem::~HighscoreItem() {
}
	

Highscore::Highscore(const char *fileName) : nItems(10), fileName(NULL) {
	packfile_password("PARAHSCR");
	
	this->fileName = new char[ustrsizez(fileName)];
	ustrcpy(this->fileName, fileName);

	PACKFILE *file = pack_fopen(fileName, "r");
	if (!file) {
		MakeDefaultTable();
	}
	else {
		Load(file);
		pack_fclose(file);
	}
	
	packfile_password(NULL);
}


Highscore::~Highscore() {
	packfile_password("PARAHSCR");

	PACKFILE *file = pack_fopen(fileName, "w");
	if (file) {
		Save(file);
		pack_fclose(file);
	}
	
	delete [] fileName;
	fileName = NULL;

	DestroyTable();

	packfile_password(NULL);
}


bool Highscore::CanAdd(int score) {
	return ((*(--items.end()))->score < score);
}


void Highscore::Add(const char *name, int score, int level) {
	list<HighscoreItem *>::iterator i;
	for (i = items.begin(); i != items.end(); ++i) {
		if ((*i)->score < score) {
			break;
		}
	}
	
	items.insert(i, new HighscoreItem(name, score, level));
	i = --items.end();
	delete *i;
	*i = NULL;
	items.erase(i);
}


void Highscore::MakeDefaultTable() {
	for (int i=0; i<nItems; ++i) {
		items.push_back(new HighscoreItem("NOBODY", 1000*(nItems - i), nItems - i));
	}
}


void Highscore::Load(PACKFILE *f) {
	char buf[8];
	int score;
	int level;

	DestroyTable();
	for (int i=0; i<nItems; ++i) {
		pack_fread(buf, 8, f);
		score = pack_igetl(f);
		level = pack_getc(f);
		items.push_back(new HighscoreItem(buf, score, level));
	}
}


void Highscore::Save(PACKFILE *f) {
	HighscoreItem *item;
	for (list<HighscoreItem *>::iterator i = items.begin(); i != items.end(); ++i) {
		item = *i;
		pack_fwrite(item->name, 8, f);
		pack_iputl(item->score, f);
		pack_putc(item->level, f);
	}
}


void Highscore::DestroyTable() {
	for (list<HighscoreItem *>::iterator i = items.begin(); i != items.end(); ++i) {
		delete *i;
		*i = NULL;
	}
	items.clear();
}


list<HighscoreItem *>& Highscore::GetTable() {
	return items;
}
