#ifndef		GRID_H
#define		GRID_H

#include "block.h"
#include "ball.h"
#include "bullet.h"
#include <vector>
using namespace std;

class Grid : public Object {
	protected:
		vector<Block> blocks;
		int nBricks;
		int currentLevel;
	
		void CountBricks();

	public:
		Grid();
		virtual ~Grid();

		void Update();
		void Draw(BITMAP *);
	
		bool Load(int i, DATAFILE *dataGfx, DATAFILE *dataLevels);
		bool FirstLevel(DATAFILE *dataGfx, DATAFILE *dataLevels);
		bool NextLevel(DATAFILE *dataGfx, DATAFILE *dataLevels);
		int Level() { return currentLevel + 1; }
		bool CollisionDetection(Ball *b, int &destroyedBricks, int &destroyedIndex);
		bool CollisionDetection(Bullet *b, int &destroyedBricks, int &destroyedIndex);
		bool IsWall(int x, int y);
		bool IsHit(int x, int y);
	
		int BlockWidth() { return blocks[0].Width(); }
		int BlockHeight() { return blocks[0].Height(); }
		bool Clear() { return (nBricks == 0); }
};

#endif		//GRID_H
