#include "global.h"

DATAFILE *dataGfx, *dataLevels, *dataSounds, *dataFont;
int soundVolume;

void PlaySample(int i) {
	stop_sample((SAMPLE *)dataSounds[i].dat);
	play_sample((SAMPLE *)dataSounds[i].dat, soundVolume, 128, 1000, 0);
}


void putpixel_f(BITMAP *bmp, float x, float y, int col) {
	int p;
	int r = getr8(col);
	int g = getg8(col);
	int b = getb8(col);
	
	int ix = (int)x;
	int iy = (int)y;
	
	float qx = x - ix;
	float qy = y - iy;
	float o4 = qx*qy;
	float o3 = (1.0f - qx)*qy;
	float o2 = qx*(1.0f - qy);
	float o1 = (1.0f - qx)*(1.0f - qy);

	o1 = sqrt(sqrt(o1));
	o2 = sqrt(sqrt(o2));
	o3 = sqrt(sqrt(o3));
	o4 = sqrt(sqrt(o4));
	
	p = ((unsigned char *)bmp->line[iy])[ix];
	bmp->line[iy][ix] = makecol((int)(getr(p)*(1.0f-o1) + r*o1), (int)(getg(p)*(1.0f-o1) + g*o1), (int)(getb(p)*(1.0f-o1) + b*o1));

	p = ((unsigned char *)bmp->line[iy])[ix+1];
	bmp->line[iy][ix+1] = makecol((int)(getr(p)*(1.0f-o2) + r*o2), (int)(getg(p)*(1.0f-o2) + g*o2), (int)(getb(p)*(1.0f-o2) + b*o2));

	p = ((unsigned char *)bmp->line[iy+1])[ix];
	bmp->line[iy+1][ix] = makecol((int)(getr(p)*(1.0f-o3) + r*o3), (int)(getg(p)*(1.0f-o3) + g*o3), (int)(getb(p)*(1.0f-o3) + b*o3));
		
	p = ((unsigned char *)bmp->line[iy+1])[ix+1];
	bmp->line[iy+1][ix+1] = makecol((int)(getr(p)*(1.0f-o4) + r*o4), (int)(getg(p)*(1.0f-o4) + g*o4), (int)(getb(p)*(1.0f-o4) + b*o4));
}


void draw_sprite_f(BITMAP *bmp, BITMAP *spr, float x, float y) {
	int w = spr->w;
	int h = spr->h;
	int col;
	for (int j=0; j<h; ++j) {
		for (int i=0; i<w; ++i) {
			if ((col = ((unsigned char *)spr->line[j])[i]) != 0) {
				putpixel_f(bmp, x+i, y+j, col);
			}
		}
	}
}
