#include "error.h"
#include <allegro.h>


const char *errorDescription[] = {
	"No error.\n",
	"Error: initializing Allegro!\n",
	"Error: installing keyboard module!\n",
	"Error: installing mouse module!\n",
	"Error: installing timer module!\n",
	"Error: initializing graphics mode!\n",
	"Error: installing sound module!\n",
	"Error: ran out of memory!!!\n",
	"Error: can't load data!\n",
	"An unknown error occured!\n"
};


Error::Error(Type t)
	:type(t)
{
}


const char *Error::GetDescription() {
	return errorDescription[type];
}


Error::operator bool() const {
	return !(type == NONE);
}


bool Error::operator==(const Type  &t) {
	return (type == t);
}


bool Error::operator!=(const Type  &t) {
	return (type != t);
}
