#include "block.h"

	
Block::Block() : Object(0, 0, 0, 0), hp(0), state(DEAD), stateCounter(0), unbreakable(false) {
	w = 12;
	h = 6;
}


void Block::Reset() {
	hp = 0;
	state = DEAD;
	stateCounter = 0;
	unbreakable = false;
}


void Block::Create(int x_, int y_, int hp_, BITMAP *sprite) {
	x = x_;
	y = y_;
	hp = hp_ >= 0 ? hp_ : 0;
	if (hp > 0) {
		state = NORMAL;
	}
	else {
		if (sprite) {
			unbreakable = true;
			state = NORMAL;
		}
		else {
			state = DEAD;
		}
	}
	
	stateCounter = 0;
	this->sprite = sprite;
}


Block::~Block() {
}


void Block::Update() {
	switch (state) {
		case HIT:
			--stateCounter;
			if (stateCounter <= 0) {
				if (hp <= 0) {
					state = DYING;
					stateCounter = 10;
				}
				else {
					state = NORMAL;
				}
			}
			break;
		case DYING:
			--stateCounter;
			if (stateCounter <= 0) {
				state = DEAD;
			}
			break;
		case NORMAL:
		case DEAD:
		default:
			break;
	};
}


void Block::Draw(BITMAP *buffer) {
	int c;
	switch (state) {
		case NORMAL:
			draw_sprite(buffer, sprite, x, y);
			break;
		case HIT:
			rectfill(buffer, x, y, x+w-1, y+h-1, makecol8(224,224,224));
			break;
		case DYING:
			c = stateCounter*255/10;
			rectfill(buffer, x, y, x+w-1, y+h-1, makecol8(c,c,c));
			break;
		case DEAD:
		default:
			break;
	};
}


int Block::Hit() {
	if (unbreakable) return 0;
		
	--hp;
	if (state != HIT) {
		state = HIT;
		stateCounter = 4;
	}
	
	return hp <= 0 ? 1 : 0;
}


bool Block::Dead() {
	return ((state == DEAD) || (state == DYING) || (state == HIT));
}


bool Block::Unbreakable() {
	return unbreakable;
}
