#ifndef		BALL_H
#define		BALL_H

#include "object.h"

class Ball : public Object {
	protected:
		int minX, maxX, minY, maxY;
	
		float x, vx, maxVx;
		float y, vy, maxVy;
	
		bool dead;
		int wall;

	public:
		Ball();
		virtual ~Ball();

		void Update();
		void Draw(BITMAP *buffer);
	
		void SetRange(int minX, int maxX, int minY, int myxY);
		void Initialize();
		float GetX() { return x; }
		float GetY() { return y; }
		void SetY(float y);
		void SetX(float x);
		float GetVx() { return vx; }
		float GetVy() { return vy; }
		void SetVx(float vx_) { vx = vx_; }
		void SetVy(float vy_) { vy = vy_; }
		void Launch(float vx, float vy);
		bool Dead() { return dead; }
		void BounceX();
		void BounceY();
		int Size() { return w; }
		void ChangeSpeed(float factor);
		int HitWall() { return wall; }
};

#endif		//BALL_H
