#include "scroll.h"


ScrollText::ScrollText(int x_, int y_, int w_, FONT *f, const char *t1, const char *t2)
	:x(x_),
	y(y_),
	w(w_),
	fnt(f),
	text1(NULL),
	text2(NULL),
	buf(NULL),
	state(PAUSING4),
	stateCounter(500.0f)
{
	buf = new char[w+1];
	SetText1(t1);
	SetText2(t2);
}


ScrollText::~ScrollText() {
	if (text1) {
		delete [] text1;
		text1 = NULL;
	}

	if (text2) {
		delete [] text2;
		text2 = NULL;
	}
	
	if (buf) {
		delete [] buf;
		buf = NULL;
	}
}


void ScrollText::Update() {
	switch (state) {
		case PAUSING1:
			if (stateCounter > 0.0f) {
				stateCounter -= 1.0f;
			}
			else {
				state = SCROLLING;
			}
			break;

		case PAUSING2:
			if (stateCounter > 0.0f) {
				stateCounter -= 1.0f;
			}
			else {
				state = SCROLLING_BACK;
				stateCounter = ustrsizez(text1) - w;
			}
			break;

		case PAUSING3:
			if (stateCounter > 0.0f) {
				stateCounter -= 1.0f;
			}
			else {
				state = SCROLLING_DOWN;
			}
			break;

		case PAUSING4:
			if (stateCounter > 0.0f) {
				stateCounter -= 1.0f;
			}
			else {
				state = SCROLLING_UP;
				stateCounter = text_height(fnt);
			}
			break;

		case SCROLLING:
			if (stateCounter < ustrsizez(text1) - w) {
				stateCounter += 0.4f;
			}
			else {
				state = PAUSING2;
				stateCounter = 250.0f;
			}
			break;

		case SCROLLING_BACK:
			if (stateCounter > 0.0f) {
				stateCounter -= 1.0f;
			}
			else {
				state = PAUSING3;
				stateCounter = 500.0f;
			}
			break;

		case SCROLLING_DOWN:
			if (stateCounter < text_height(fnt)) {
				stateCounter += 0.4f;
			}
			else {
				state = PAUSING4;
				stateCounter = 500.0f;
			}
			break;

		case SCROLLING_UP:
			if (stateCounter > 0.0f) {
				stateCounter -= 0.4f;
			}
			else {
				state = PAUSING1;
				stateCounter = 500.0f;
			}
			break;
	};
}


void ScrollText::Draw(BITMAP *bmp) {
	text_mode(-1);
	
	switch (state) {
		case PAUSING1:
		case PAUSING3:
			ustrncpy(buf, text1, w);
			textout(bmp, fnt, buf, x, y, makecol(127,127,127));
			break;

		case PAUSING2:
			ustrncpy(buf, text1 + ustrsizez(text1) - w, w);
			textout(bmp, fnt, buf, x, y, makecol(127,127,127));
			break;

		case PAUSING4:
			textout(bmp, fnt, text2, x, y, makecol(127,127,127));
			break;

		case SCROLLING:
		case SCROLLING_BACK:
			ustrncpy(buf, text1 + (int)stateCounter, w);
			textout(bmp, fnt, buf, x, y, makecol(127,127,127));
			break;
		
		case SCROLLING_DOWN:
		case SCROLLING_UP:
			set_clip(bmp, x, y, x+w*text_length(fnt, "A"), y+text_height(fnt));
			ustrncpy(buf, text1, w);
			textout(bmp, fnt, buf, x, (int)(y-stateCounter), makecol(127,127,127));
			textout(bmp, fnt, text2, x, (int)(y-stateCounter+text_height(fnt)), makecol(127,127,127));
			set_clip(bmp, 0, 0, bmp->w-1, bmp->h-1);
			break;
	};
}


void ScrollText::SetText1(const char *t) {
	if (text1) {
		delete [] text1;
	}
	
	text1 = new char[ustrsizez(t)];
	ustrcpy(text1, t);
	
	ustrncpy(buf, text1, w);
	buf[w] = 0;
}


void ScrollText::SetText2(const char *t) {
	if (text2) {
		delete [] text2;
	}
	
	text2 = new char[ustrsizez(t)];
	ustrcpy(text2, t);
}
