#include <allegro.h>
#include "params.h"

int Params::w = 640;
int Params::h = 480;
int Params::bpp = 8;
int Params::fullscreen = 1;
int Params::refresh = 60;
int Params::vsync = 1;
int Params::fps = 50;
int Params::unlimitedFPS = 0;
int Params::showFPS = 0;
int Params::yield = 0;

int Params::soundVolume = 96;
int Params::musicVolume = 240;

int Params::screenWidth = 200;
int Params::screenHeight = 160;
int Params::updateMethod = 0;
float Params::paddleMaxSpeed = 3.0f;
float Params::paddleAcceleration = 0.75f;
float Params::paddleDeceleration = 0.65f;

float Params::ballMaxSpeed = 4.0f;
float Params::ballAcceleration = 1.000110f;
float Params::ballMinVx = 0.15f;
float Params::ballMinVy = 0.25f;

int Params::pwuSizeUp = 12;
int Params::pwuSizeDown = 24;
int Params::pwuSpeedUp = 24;
int Params::pwuSpeedDown = 10;
int Params::pwuMoney = 16;
int Params::pwuMoneyBig = 2;
int Params::pwuGlue = 8;
int Params::pwuExtraBall = 12;
int Params::pwuShoot = 10;
int Params::pwuExtraLife = 1;
float Params::pwuRatio = 0.4f;

char Params::dataGfx[128];
char Params::dataLevels[128];
char Params::dataSounds[128];
char Params::dataMusic[128];
char Params::dataFont[128];


void Params::Load(const char *file) {
	set_config_file(file);
	
	w = get_config_int("GENERAL", "w", w);
	h = get_config_int("GENERAL", "h", h);
	bpp = get_config_int("GENERAL", "bpp", bpp);
	fullscreen = get_config_int("GENERAL", "fullscreen", fullscreen);
	refresh = get_config_int("GENERAL", "refresh", refresh);
	vsync = get_config_int("GENERAL", "vsync", vsync);
	yield = get_config_int("GENERAL", "yield", yield);
	fps = get_config_int("SPEED", "fps", fps);
	unlimitedFPS = get_config_int("SPEED", "unlimitedFPS", unlimitedFPS);
	showFPS = get_config_int("SPEED", "showFPS", showFPS);
	soundVolume = get_config_int("GENERAL", "soundVolume", soundVolume);
	musicVolume = get_config_int("GENERAL", "musicVolume", musicVolume);

	screenWidth = get_config_int("GENERAL", "screenWidth", screenWidth);
	screenHeight = get_config_int("GENERAL", "screenHeight", screenHeight);
	updateMethod = get_config_int("GENERAL", "updateMethod", updateMethod);
	
	paddleMaxSpeed = get_config_float("PADDLE", "maxSpeed", paddleMaxSpeed);
	paddleAcceleration = get_config_float("PADDLE", "acceleration", paddleAcceleration);
	paddleDeceleration = get_config_float("PADDLE", "deceleration", paddleDeceleration);

	ballMaxSpeed = get_config_float("BALL", "maxSpeed", ballMaxSpeed);
	ballAcceleration = get_config_float("BALL", "acceleration", ballAcceleration);
	ballMinVx = get_config_float("BALL", "minSpeedX", ballMinVx);
	ballMinVy = get_config_float("BALL", "minSpeedY", ballMinVy);

	pwuSizeUp = get_config_int("POWERUP", "sizeUp", pwuSizeUp);
	pwuSizeDown = get_config_int("POWERUP", "sizeDown", pwuSizeDown);
	pwuSpeedUp = get_config_int("POWERUP", "speedUp", pwuSpeedUp);
	pwuSpeedDown = get_config_int("POWERUP", "speedDown", pwuSpeedDown);
	pwuMoney = get_config_int("POWERUP", "money", pwuMoney);
	pwuMoneyBig = get_config_int("POWERUP", "moneyBig", pwuMoneyBig);
	pwuGlue = get_config_int("POWERUP", "glue", pwuGlue);
	pwuExtraBall = get_config_int("POWERUP", "extraBall", pwuExtraBall);
	pwuShoot = get_config_int("POWERUP", "shoot", pwuShoot);
	pwuExtraLife = get_config_int("POWERUP", "extraLife", pwuExtraLife);
	pwuRatio = get_config_float("POWERUP", "ratio", pwuRatio);

	usprintf(dataGfx, get_config_string("DATA", "gfx", "./data/gfx.dat"));
	usprintf(dataLevels, get_config_string("DATA", "levels", "./data/levels.dat"));
	usprintf(dataSounds, get_config_string("DATA", "sounds", "./data/sounds.dat"));
	usprintf(dataMusic, get_config_string("DATA", "music", "./data/music.pls"));
	usprintf(dataFont, get_config_string("DATA", "font", "./data/font.dat"));
}


void Params::Save(const char *file) {
	set_config_file(file);
	
	set_config_int("GENERAL", "w", w);
	set_config_int("GENERAL", "h", h);
	set_config_int("GENERAL", "bpp", bpp);
	set_config_int("GENERAL", "fullscreen", fullscreen);
	set_config_int("GENERAL", "refresh", refresh);
	set_config_int("GENERAL", "vsync", vsync);
	set_config_int("GENERAL", "yield", yield);
	set_config_int("SPEED", "fps", fps);
	set_config_int("SPEED", "unlimitedFPS", unlimitedFPS);
	set_config_int("SPEED", "showFPS", showFPS);
	set_config_int("GENERAL", "soundVolume", soundVolume);
	set_config_int("GENERAL", "musicVolume", musicVolume);

	set_config_int("GENERAL", "screenWidth", screenWidth);
	set_config_int("GENERAL", "screenHeight", screenHeight);
	set_config_int("GENERAL", "updateMethod", updateMethod);
	
	set_config_float("PADDLE", "maxSpeed", paddleMaxSpeed);
	set_config_float("PADDLE", "acceleration", paddleAcceleration);
	set_config_float("PADDLE", "deceleration", paddleDeceleration);
	
	set_config_float("BALL", "maxSpeed", ballMaxSpeed);
	set_config_float("BALL", "acceleration", ballAcceleration);
	set_config_float("BALL", "minSpeedX", ballMinVx);
	set_config_float("BALL", "minSpeedY", ballMinVy);

	set_config_int("POWERUP", "sizeUp", pwuSizeUp);
	set_config_int("POWERUP", "sizeDown", pwuSizeDown);
	set_config_int("POWERUP", "speedUp", pwuSpeedUp);
	set_config_int("POWERUP", "speedDown", pwuSpeedDown);
	set_config_int("POWERUP", "money", pwuMoney);
	set_config_int("POWERUP", "moneyBig", pwuMoneyBig);
	set_config_int("POWERUP", "glue", pwuGlue);
	set_config_int("POWERUP", "extraBall", pwuExtraBall);
	set_config_int("POWERUP", "shoot", pwuShoot);
	set_config_int("POWERUP", "extraLife", pwuExtraLife);
	set_config_float("POWERUP", "ratio", pwuRatio);
	
	set_config_string("DATA", "gfx", dataGfx);
	set_config_string("DATA", "levels", dataLevels);
	set_config_string("DATA", "sounds", dataSounds);
	set_config_string("DATA", "music", dataMusic);
	set_config_string("DATA", "font", dataFont);

	flush_config_file();
}
