#include "musicplayer.h"


MusicPlayer::MusicPlayer()
	:index(-1),
	isPlaying(false),
	random(1),
	loop(0)
{
}


MusicPlayer::~MusicPlayer() {
	if (IsPlaying()) Stop();
	ClearPlaylist();
}


void MusicPlayer::AddFile(const char *f) {
	char *file = new char[ustrsizez(f)];
	ustrcpy(file, f);
	playlist.push_back(file);
	order.push_back(order.size());
}


void MusicPlayer::RemoveFile(int i) {
	if (i<0 || i>=(signed)playlist.size()) return;
	if (IsPlaying() && i==index) Stop();

	list<char *>::iterator listIterator = playlist.begin();
	for (int c=0; c<i; ++c) {
		++listIterator;
	}
	
	delete *listIterator;
	*listIterator = NULL;
	playlist.erase(listIterator);

	int n = order.size() - 1;
	order.clear();
	order.reserve(n);
	for (int j=0; j<n; j++) {
		order.push_back(j);
	}
	if (random) {
		Shuffle();
	}
	
	if (index >= (signed)order.size()) {
		--index;
	}
}


void MusicPlayer::ClearPlaylist() {
	while (!playlist.empty())
		RemoveFile(0);
	index = -1;
}



void MusicPlayer::Play(int i) {
	if (playlist.empty()) {
		return;
	}

	if (i>=(signed)playlist.size()) {
		return;
	}
	index = i >= 0 ? i : index;

	if (IsPlaying()) {
		Stop();
	}

	Load();
	isPlaying = true;
}


void MusicPlayer::Pause() {
	isPlaying = false;
}


void MusicPlayer::Resume() {
	isPlaying = true;
}


void MusicPlayer::Stop() {
	isPlaying = false;
}


bool MusicPlayer::IsPlaying() {
	return isPlaying;
}


void MusicPlayer::Next() {
	++index;
	if (index >= (signed)order.size()) {
		index = 0;
		Shuffle();
	}
	if (IsPlaying()) Play();
}


void MusicPlayer::Previous() {
	--index;
	if (index < 0) {
		index = order.size() - 1;
	}
	if (IsPlaying()) Play();
}


void MusicPlayer::Select(int i) {
	if (i<=0 || i>=(signed)playlist.size()-1) return;

	index = i;
	if (IsPlaying()) Play();
}


char *MusicPlayer::GetSelectedFilename() {
	if (playlist.empty())
		return NULL;
	else {
		list<char *>::iterator listIterator = playlist.begin();
		for (int c=0; c<order[index]; ++c) {
			++listIterator;
		}
		return *listIterator;
	}
}


void MusicPlayer::Load() {
}


void MusicPlayer::LoadPlaylist(const char *file) {
	char song[] = "FileXXXX\0";
	char *pls = new char[ustrsizez(file)];
	ustrcpy(pls, file);
	set_config_file(pls);
	int n = get_config_int("playlist", "NumberOfEntries", 0);
	order.clear();
	order.reserve(n);

	for (int i=0; i<n; i++) {
		usprintf(song, "File%d", i+1);
		const char *path = get_config_string("playlist", song, NULL);
		if (!path) continue;
		AddFile(path);
	}
	
	if (random) {
		Shuffle();
	}
	else {
		Order();
	}

	delete [] pls;
}


void MusicPlayer::SetRandom(int r) {
	random = r;
	if (random) {
		Shuffle();
	}
	else {
		Order();
	}
}


void MusicPlayer::SetLoop(int l) {
	loop = l;
}


void MusicPlayer::Setup(const char *f, int random, int loop) {
	LoadPlaylist(f);
	SetRandom(random);
	SetLoop(loop);
}


void MusicPlayer::Order() {
	for (int i=0; i<(signed)order.size(); i++) {
		order[i] = i;
	}
}


void MusicPlayer::Shuffle() {
	int size = order.size();
	for (int i=0; i<size; i++) {
		int j = rand()%size;
		int k = rand()%size;
		int l = order[j];
		order[j] = order[k];
		order[k] = l;
	}
}
