#ifndef		MENUS_H
#define		MENUS_H

#include "menu.h"
#include "highscore.h"

class MainMenu : public Menu {
	public:
		MainMenu();
		virtual ~MainMenu() {}

		bool Update();
		int State() { return currentState; }
		enum { MENU_NEW_GAME=0, MENU_RESUME_GAME, MENU_OPTIONS, MENU_SCORES, MENU_HELP, MENU_SHORTCUTS, MENU_CREDITS, MENU_EXIT };
};


class OptionsMenu : public Menu {
	public:
		OptionsMenu();
		virtual ~OptionsMenu() {}

		bool Update();
		int State() { return currentState; }
		enum { OPTION_FULLSCREEN=0, OPTION_VSYNC, OPTION_LIMIT_FPS, OPTION_SHOW_FPS, OPTION_SOUND_VOLUME, OPTION_MUSIC_VOLUME, MENU_BACK };
};


class CreditsMenu : public Menu {
	public:
		CreditsMenu();
		virtual ~CreditsMenu() {}
};


class LevelClearedMenu : public Menu {
	public:
		LevelClearedMenu();
		virtual ~LevelClearedMenu() {}
};


class HighscoreMenu : public Menu {
	public:
		HighscoreMenu(Highscore *hsc);
		virtual ~HighscoreMenu() {}
};


class GameOverMenu : public Menu {
	public:
		GameOverMenu();
		virtual ~GameOverMenu() {}
};


class HscEditMenu : public Menu {
	public:
		HscEditMenu();
		virtual ~HscEditMenu() {}
		bool Update();
		
		char *GetText();
};


class HelpMenu : public Menu {
	public:
		HelpMenu(DATAFILE *dataGfx);
		virtual ~HelpMenu() {}
};


class ShortcutsMenu : public Menu {
	public:
		ShortcutsMenu();
		virtual ~ShortcutsMenu() {}
};


class PauseMenu : public Menu {
	public:
		PauseMenu();
		virtual ~PauseMenu() {}
};


class FinishedMenu : public Menu {
	public:
		FinishedMenu();
		virtual ~FinishedMenu() {}
};

#endif		//MENUS_H
