#include "fps.h"

FPS::FPS(int fps) {
	nSamples = fps;
	samples = new int[nSamples];
	for (int i=0; i<nSamples; i++) {
		samples[i] = 1;
	}
	curSample = 0;
	frameCounter = 0;
	framesPerSecond = fps;
}


FPS::~FPS() {
	delete [] samples;
	samples = NULL;
	nSamples = 0;
	frameCounter = 0;
}


void FPS::Tick() {
	curSample++;
	curSample %= nSamples;
	framesPerSecond -= samples[curSample];
	framesPerSecond += frameCounter;
	samples[curSample] = frameCounter;
	frameCounter = 0;
}


void FPS::Frame() {
	++frameCounter;
}


int FPS::Get() {
	return framesPerSecond;
}

void FPS::Draw(BITMAP *buffer) {
	textprintf(buffer, font, 0, 0, makecol(255,255,255), "%d FPS", Get());
}
