#ifndef			ERROR_H
#define			ERROR_H


class Error {
	public:
		enum Type {
			NONE,
			ALLEGRO,
			KEYBOARD,
			MOUSE,
			TIMER,
			GFX,
			SOUND,
			MEMORY,
			NOBITMAP,
			UNKNOWN
		};

	private:
		Type type;
	
	public:
		Error(Type t = NONE);
		virtual ~Error() {}
	
		virtual const char *GetDescription();
		virtual operator bool() const;
		virtual bool operator==(const Type &t);
		virtual bool operator!=(const Type &t);
};

#endif			//ERROR_H
