#include "dumbplayer.h"


DumbPlayer::DumbPlayer() 
	:MusicPlayer(),
	song(NULL),
	dp(NULL),
	length(0),
	volume(1.0f)
{
}


DumbPlayer::~DumbPlayer() {
	if (song) {
		unload_duh(song);
		song = NULL;
		dp = NULL;
	}
}


void DumbPlayer::Load() {
	if (song) {
		if (dp) {
			al_stop_duh(dp);
			dp = NULL;
		}
		unload_duh(song);
		song = NULL;
	}

	char *filename = GetSelectedFilename();
	char *ext = get_extension(filename);
	if (ustrcmp(ext, "s3m") == 0 || ustrcmp(ext, "S3M") == 0) {
		song = dumb_load_s3m(GetSelectedFilename());
	}
	else if (ustrcmp(ext, "it") == 0 || ustrcmp(ext, "IT") == 0) {
		song = dumb_load_it(GetSelectedFilename());
	}
	else if (ustrcmp(ext, "mod") == 0 || ustrcmp(ext, "MOD") == 0) {
		song = dumb_load_mod(GetSelectedFilename());
	}
	else if (ustrcmp(ext, "xm") == 0 || ustrcmp(ext, "XM") == 0) {
		song = dumb_load_xm(GetSelectedFilename());
	}

	if (!song) {
		length = 0;
	}
	else {
		length = duh_get_length(song);
	}
}


void DumbPlayer::Play(int i) {
	MusicPlayer::Play(i);
	dp = al_start_duh(song, 2, 0, volume, 8192, 22050);
}


void DumbPlayer::Pause() {
	MusicPlayer::Pause();
	al_pause_duh(dp);
}


void DumbPlayer::Resume() {
	MusicPlayer::Resume();
	al_resume_duh(dp);
}


void DumbPlayer::Stop() {
	MusicPlayer::Stop();
	al_stop_duh(dp);
	dp = NULL;
}


void DumbPlayer::Update() {
	if (IsPlaying() && !loop && al_duh_get_position(dp) >= length)
		Next();
	else
		al_poll_duh(dp);
}


void DumbPlayer::SetVolume(int vol) {
	volume = (float)vol / 256.0f;
	if (dp) {
		al_duh_set_volume(dp, volume);
	}
}
