#ifndef		BLOCK_H
#define		BLOCK_H

#include "object.h"

class Block : public Object {
	protected:
		int hp;
		enum State { NORMAL, HIT, DYING, DEAD };
		State state;
		int stateCounter;
		bool unbreakable;
	
	public:
		Block();
		virtual ~Block();

		void Create(int x_, int y_, int hp_, BITMAP *sprite);
		void Update();
		void Draw(BITMAP *buffer);
		int Hit();
		bool Dead();
		bool Unbreakable();
		bool IsBrick() { return (hp > 0); }
		bool IsHit() { return (state == HIT); }
		void Reset();
};

#endif		//BLOCK_H
