/*
 *  Packdude game engine
 *  Copyright (C) 2003  Jaan Pullerits
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------
 * Game internal timers to time events
 *
 * 	Created by JP on 27th February 2003
 *
 */

#include <stdio.h>
#include "Python.h"
#include "game.h"

static struct {
	// Defineable vars
	int time;
	char cmd[32];
	int autorm;

	// internal vars
	int begin;
	int active;
} tmr[32];

/* 
 * Clears all timers
 *
 */
void clear_timers(void)
{
	int i;
	for (i = 0; i < 36; i++)
		tmr[i].active = 0;
}

/*
 * Add timer
 *
 */
int timer_add(int num, char *cmd, int time, int autoremove)
{
	if (num > 31 || num < 0) {
		fprintf(stderr,
			"Timer insert to slot higher than 31 or lower than 0 requested!\n");
		return 0;
	}
	if (strlen(cmd) > 32) {
		fprintf(stderr,
			"Timer insert with command longer than 32 characters requested!\n");
		return 0;
	}

	tmr[num].active = 1;
	tmr[num].time = time;
	tmr[num].autorm = autoremove;

	tmr[num].begin = timer;

	strcpy(tmr[num].cmd, cmd);

	return 1;
}

/*
 * Remove timer
 */
int timer_remove(int num)
{
	if (num > 31 || num < 0) {
		fprintf(stderr,
			"Timer remove from slot higher than 31 or lower than 0 requested!\n");
		return 0;
	}

	if (!tmr[num].active)
		return 0;

	tmr[num].active = 0;
	return 1;
}

/*
 * List timers
 *
 */
void timer_ls(void)
{

	int i, tmp = timer;


	for (i = 0; i < 32; i++) {
		if (tmr[i].active) {
			fprintf(stdout,
				"timer [%i]: Updates after every %i/100 seconds (next after %i/100), runs command: \"%s\"",
				i, tmr[i].time,
				tmr[i].time - (tmp - tmr[i].begin),
				tmr[i].cmd);

			if (tmr[i].autorm)
				fprintf(stdout, " (autoremove)");

			fprintf(stdout, "\n");
		}
	}
}

/*
 * Reset timers
 *
 */
void timer_reset(void)
{
	int tmp = timer, i;

	for (i = 0; i < 32; i++) {
		if (tmr[i].active)
			tmr[i].begin = tmp;
	}
}

/**********************
 * INTERNAL FUNCTIONS *
 *********************/

/*
 * Updates timers and runs commands
 */
void update_timers(void)
{
	int i;

	for (i = 0; i < 32; i++) {
		if (tmr[i].active
		    && tmr[i].time - (timer - tmr[i].begin) <= 0) {
			PyRun_SimpleString(tmr[i].cmd);
			if (tmr[i].autorm)
				timer_remove(i);
			else
				tmr[i].begin = timer;
		}
	}
}
