/*
 *  Packdude game engine
 *  Copyright (C) 2003  Jaan Pullerits
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------
 * TILESET header file
 *
 *  Created on 19 May 2002 by JP
 *
 */

// Variable declarations
PALETTE pal;			// Memory for palette
struct {
	char fname[1025];
	BITMAP *dat;
} ts;
int current_tile;		// Working tile

//Function protos
void load_tile(BITMAP *image, int tile);
void load_sub_tile(BITMAP *image, int tile);
void load_masked_tile(BITMAP *image, int tile);
void save_tile(BITMAP *image);
int load_tileset(char *fname);
void save_tileset(char *fname);
int select_tile(BITMAP *image);
void init_tileset();
void remove_tileset();

// Macros

// Mouse to sprite coord calculation macro
#define M2C(coord) ((coord) >> 2)
#define M2S(coord) ((coord) >> 5)
#define S2M(coord) ((coord) << 5)
// Makes keys easyer to read
#define ISKEY(scancode)  ((inkey >> 8) == scancode)
