/*
 *  Packdude game engine
 *  Copyright (C) 2003  Jaan Pullerits
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------
 * TILESET routines
 *
 *  Created by JP on 19 May 2002
 *
 * -- Edit on Sun, 2 Mar 2003 20:03:28 +0200
 *  Indenting of this file needs fixing. Back then I used 2 space indent
 *  in some very strange form. ;)
 * 
 */

#include <allegro.h>
#include "tileset.h"
#include <stdio.h>
#include "main.h"
#include "animators.h"

/*****************************************************************************

    Function: init_tileset()

    Description: Initializes tileset
    Parameters:  none
    Return:      none

*****************************************************************************/

void init_tileset()
{
	strcpy(ts.fname, "");
	ts.dat = create_bitmap(1, 1);	// Something to waste some space. ;)
}


/*****************************************************************************

    Function: load_tile(BITMAP *image, int tile)

    Description: Loads tile from the tileset
    Parameters:  pointer to tile BITMAP and tile number
    Return:      none

*****************************************************************************/

void load_tile(BITMAP *image, int tile)
{
	int column, row;

	column = tile % 16;	// Calculate column
	row = (int) ((tile - column) / 16);	// and row coords

	blit(ts.dat, image, column * 32,	// Blit image to buffer
	     row * 32, 0, 0, 32, 32);
}


/*****************************************************************************

    Function: load_masked_tile(BITMAP *image, int tile)

    Description: Loads masked tile to image
    Parameters:  pointer to tile BITMAP
    Return:      none

*****************************************************************************/

void load_masked_tile(BITMAP *image, int tile)
{

	int column, row;

	column = tile % 16;	// Calculate column
	row = (tile - column) / 16;	// and row coords

	masked_blit(ts.dat, image, column * 32,	// Blit image to buffer
		    row * 32, 0, 0, 32, 32);

}


/*****************************************************************************

    Function: save_tile(BITMAP *image)

    Description: Saves current_tile to the tileset
    Parameters:  Pointer to image
    Return:      none

*****************************************************************************/
void save_tile(BITMAP *image)
{
	int column, row;

	column = current_tile % 16;	// Calculate column
	row = (current_tile - column) / 16;	// and row coords

	blit(image, ts.dat, 0, 0, column * 32,	// Blit image to tileset
	     row * 32, 32, 32);
}

/*****************************************************************************

    Function: int load_tileset(char *fname)

    Description: Loads tileset to memory.
    Parameters:  none
    Return:      TRUE on success, FALSE on error

*****************************************************************************/

int load_tileset(char *fname)
{
	destroy_bitmap(ts.dat);

	if (!(ts.dat = load_bitmap(fname, pal)))
		return FALSE;

	strncpy(ts.fname, fname, 1024);
	return TRUE;
}

/*****************************************************************************

    Function: save_tileset()

    Description: Saves tileset from memory
    Parameters:  none
    Return:      none

*****************************************************************************/

void save_tileset(char *fname)
{
	get_palette(pal);
	strcpy(txtbuf, ts.fname);
	save_bitmap(txtbuf, ts.dat, pal);
}

/*****************************************************************************

    Function: select_tile(BITMAP *image);

    Description: Draws the tileset window, and starts the selection loop
    Parameters:  Image pointer
    Return:      none

*****************************************************************************/

int select_tile(BITMAP *image)
{

	int x, y;
	int screen_x;
	int screen_y;
	int inkey;

	int tile = 0;
	int old_tile = -1;
	int temp_tile;
	BITMAP *temp_bitmap;

	signed char aborted = FALSE;
	signed char tileset_changed = FALSE;

      ts_start:

	scare_mouse();

	if (!tileset_changed)
		clear_bitmap(screen);	// clear screen

	screen_x = 0;
	screen_y = 0;

	for (y = 0; y < 16; y++) {
		for (x = 0; x < 16; x++) {
			blit(ts.dat, screen, x * 32, y * 32, screen_x * 32, screen_y * 32, 32, 32);	// Blit tiles to screen
			tile = x + y * 16;

			// Draw boxes around tiles, and specify if it belongs to
			// Some player animation, or is any other way special

			rect(screen, S2M(screen_x), S2M(screen_y),
			     S2M(screen_x) + 32, S2M(screen_y) + 32, 8);

			if (tile >= 0 && tile <= 2)
				textout(screen, font, "PL1",
					S2M(screen_x) + 1,
					S2M(screen_y) + 1, 14);
			if (tile >= 3 && tile <= 5)
				textout(screen, font, "PL2",
					S2M(screen_x) + 1,
					S2M(screen_y) + 1, 10);
			if (tile >= 6 && tile <= 8)
				textout(screen, font, "EN1",
					S2M(screen_x) + 1,
					S2M(screen_y) + 1, 4);
			if (tile >= 9 && tile <= 11)
				textout(screen, font, "EN2",
					S2M(screen_x) + 1,
					S2M(screen_y) + 1, 7);
			if (tile >= 12 && tile <= 14)
				textout(screen, font, "EN3",
					S2M(screen_x) + 1,
					S2M(screen_y) + 1, 8);
			if (tile == 255)
				textout(screen, font, "EMP",
					S2M(screen_x) + 1,
					S2M(screen_y) + 1, 1);
			if (animator_lut[tile] > -1)
				textprintf(screen, font, S2M(screen_x) + 1,
					   S2M(screen_y) + 24, 15, "ANM%i",
					   (int) animator_lut[tile]);


			if (screen_x == 19) {	// Calculate screen coords
				screen_x = 0;	// where to blit the tiles
				screen_y++;
			} else {
				screen_x++;
			}

		}
	}

	unscare_mouse();

	while (!aborted) {
		x = M2S(mouse_x);	// Calculate slide coords
		y = M2S(mouse_y);
		tile = x + y * 20;	// Calculate tile number

		if (tile != old_tile) {	// If mouse has moved to
			// another sector
			if (tile < 256) {	// and if it is valid sect
				scare_mouse();
				textprintf(screen, font, 0, 471, 15,
					   "Tile: %i  ", tile);
				unscare_mouse();
			} else {
				scare_mouse();
				textprintf(screen, font, 0, 471, 15,
					   "Tile:     ");
				unscare_mouse();
			}

			old_tile = tile;

		}

		while (keypressed()) {	// ESC exits aswell
			inkey = readkey();
			if(ISKEY(KEY_ESC)) aborted = 2;
		}

		if (mouse_b & 1 || mouse_b & 2) {	// On mouse click
			if (tile < 256) {	// if is valid tile
				while (mouse_b & 1 || mouse_b & 2);	// Mouse drag

				if (tile !=
				    M2S(mouse_x) + M2S(mouse_y) * 20) {

					temp_tile =
					    M2S(mouse_x) +
					    M2S(mouse_y) * 20;

					if (temp_tile > 255)
						goto ts_start;

					current_tile = temp_tile;

					temp_bitmap =
					    create_bitmap(32, 32);

					load_tile(image, tile);
					load_tile(temp_bitmap,
						  current_tile);

					save_tile(image);
					current_tile = tile;
					save_tile(temp_bitmap);
					current_tile = temp_tile;

					destroy_bitmap(temp_bitmap);

					tileset_changed = TRUE;

					goto ts_start;

				}
				current_tile = tile;	// Set current tile number
				load_tile(image, current_tile);	// Load tile to buffer
				aborted = 1;	// Abort
			} else {
				aborted = 2;	// Else just abort
			}

		}

	}

	if (tileset_changed) {
		if (prompt("Save changes?"))
			save_tileset(ts.fname);
		else
			load_tileset(ts.fname);
	}

	if (aborted == 2)
		return 0;
	else
		return -1;
}

/*****************************************************************************

    Function:    remove_tileset()

    Description: Uninstalls tileset
    Parameters:  none
    Return:      none

*****************************************************************************/

void remove_tileset()
{
	destroy_bitmap(ts.dat);
}
