/*
 *  Packdude game engine
 *  Copyright (C) 2003  Jaan Pullerits
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------
 * SOUND FX functions header file
 * 
 * 	Created by JP on 3rd March 2003
 *
 */

int sound_load(int num, char *fname);
/* Loads sound sample to internal sound pool. You can load up to 32 samples.
 * The file can be one of WAV, MP2, MP3, OGG or other similar formats.
 *
 * Returns non-zero on success and zero on error. Error message is also
 * printed to stderr.
 *
 * NOTE: Check sample_* configurations to see what samples some events in the
 * game use.
 */

int sound_free(int num);
/* Frees the sample. You don't have to call it before loading new sample
 * to slot. sound_load() does it automatically for you.
 */

void sound_clear(void);
/* Free all samples. */

int sound_play(int num);
/* Play sound. */

int sound_stop(int num);
/* Stop sound.
 * 
 * Be careful with this. If the sample isn't playing the thing may give 
 * unexpected results.
 */

int sound_attr_set(int num, int frequency, int volume, int panning);
/* Set attributes of sample. 
 *
 * It includes frequenzy, volume and panning. They are all in the scale
 * of 0 - 255. If you want to leave some of those things untouched while 
 * setting others pass -1 to arguments you don't want to change.
 *
 * Note that this thing won't affect the sample while it is playing but
 * only when it starts playing after making this call.
 *
 * Returns zero (and prints message to stderr) on error and non-zero
 * on success.
 */

int sound_freq_get(int num);
/* Get sound frequency. */

int sound_vol_get(int num);
/* Get sound volume. */

int sound_pan_get(int num);
/* Get sound panning. */
