/*
 *  Packdude game engine
 *  Copyright (C) 2003  Jaan Pullerits
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------
 * SIC header file
 *
 * 	Created by JP on 1st March 2003
 */

void sic_clear(void);
/* Clear all the SIC structures including all images and zones. */

int sic_image_load(int num, char *fname);
/* Load image to SIC pool to slot num. You can insert up to 32 images to pool at
 * once, in another words num can be in range from 0 to 31. Fname must be valid
 * path to JPEG file on HDD.
 *
 * If image allready exists in this slot it will be replaced.
 *
 * Return zero on some on error (and error message will be printed to stderr) or
 * non-zero on sucess.
 */

int sic_image_free(int num);
/* Frees the image in slot num.
 *
 * Returns zero on error (and prints error message to stderr) and non-zero on
 * success. Note that non-zero is also returned if the request is made to free
 * image what is allready free.
 */

int sic_image_put(int num, int x, int y);
/* Put image on screen. The x and y coordinates are interpreted as left top
 * corner of image.
 *
 * Note that this function can be only used if SIC is active (sic_do() is
 * called). And that means you can call this function only from zone mover
 * and mout callbacks. 
 *
 * Returns zero (and prints error message to stderr) on error and non-zero
 * on success.
 */

void sic_zone_clear(void);
/* Clears the SIC zone table
 */

int sic_zone_add(int num, int x1, int y1, int x2, int y2, char *mover,
		 char *mout, char *click);
/* Adds zone to SIC zone table (ztab) to slot num. You can define up to 32
 * zones in the table. Next four parameters give the two opposite corners of
 * the rectangle to define the zone. And last two parameters define two
 * callback python strings what will be run if mouse enter the sector (mover) 
 * and if mouse exits the sector (mout). Note that first if the interface is
 * intialized the system calls mout strings for _all_ active zones in the ztab,
 * so you shouldn't do much else than just put images on screen.
 *
 * mover and mout commands may include up to three symbols '%i' what will be
 * replaced with (in this order): number of zone, x coordinate of top left
 * corner of the zone and y coordinate of top left corner of the zone. These
 * things should aid you a little on the creation of interfaces.
 *
 * Returns zero on error (and prints the message to stderr) on error and
 * non-zero on success.
 */

int sic_zone_remove(int num);
/* Removes zone from ztab.
 *
 * Returns zero on error (and prints message to stderr), and non-zero on
 * success. Note that non-zero is also returned if the slot is already
 * inactive.
 */

int sic_do(int background);
/* Starts the SIC interface. Before calling this you have to initalize atleast
 * one zone and atleast one image. The background is the image in the SIC image
 * pool what will be used as the background of the current interface.
 *
 * Function doesn't return before user has clicked in one zone. (Or pressed
 * escape). It rerturns the number of the zone where user clicked or 0 if error
 * occured or user pressed escape. On error the message is also printed to
 * stderr.
 */
