/*
 *  Packdude game engine
 *  Copyright (C) 2003  Jaan Pullerits
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------
 * REFRESH routines
 *
 *   Created on 11 June 2002
 *
 * Here are the screen refresh functions for
 * the game.
 *
 */

#include <allegro.h>
#include <stdio.h>
#include "player.h"
#include "tileset.h"
#include "refresh.h"
#include "mapform.h"
#include "animators.h"
#include "main.h"
#include "game.h"

/*****************************************************************************

    Function:    dirtify_blocks()

    Description: Fills dirty block array with TRUE (e.g. makes all blocks
                 dirty)
    Parameters:  none
    Return:      none

*****************************************************************************/
void dirtify_blocks(void)
{
	int x, y;
	for (x = 0; x < 20; x++) {
		for (y = 0; y < 15; y++) {
			dirty_block[x][y] = TRUE;
		}
	}
}


/*****************************************************************************

    Function:    redraw_block(int x, int y);

    Description: Redraws one block (ugly, ugly, ugly)
    Parameters:  x and y coords of the block
    Return:      none

*****************************************************************************/
inline void redraw_block(int x, int y)
{
	int number;
	int block_x_offset = x * 32;
	int block_y_offset = y * 32;
	int angle;
	int flip = 0;

	// Blit background
	blit(bgbuf, tilebuf, S2M(x), S2M(y), 0, 0, 32, 32);

	// Check wether we should draw the tile _under_ the players
	if ((map_parm.block[x][y] > 9 && map_parm.block[x][y] < 20)
	    || map_parm.block[x][y] == 21)
		load_masked_tile(tilebuf, tile_data[x][y]);

	//Scan if any of the players is in this block
	for (number = 0; number < MAX_PLAYERS; number++) {
		if (plobj.active) {
			if (((int) M2S((int) player[number].x) == x
			     && (int) M2S((int) player[number].y) == y)
			    || ((int) M2S((int) player[number].x) == x
				&& (int) M2S((int) player[number].y +
					     32) == y)
			    || ((int) M2S((int) player[number].x + 32) == x
				&& (int) M2S((int) player[number].y) ==
				y)) {
				angle = 0;
				flip = 0;
				if (plobj.direction == 1)
					angle = 64;

				else if (plobj.direction == 2) {
					angle = 128;
					flip = TRUE;
				}

				else if (plobj.direction == 3)
					angle = 192;
				if (!(plobj.hurt && hurtcounter == 0)) {
					if (flip)
						rotate_sprite_v_flip
						    (tilebuf,
						     plobj.tile[plobj.
								frame],
						     (int) plobj.x -
						     block_x_offset,
						     (int) plobj.y -
						     block_y_offset,
						     itofix(angle));

					else
						rotate_sprite(tilebuf,
							      plobj.
							      tile[plobj.
								   frame],
							      (int) plobj.
							      x -
							      block_x_offset,
							      (int) plobj.
							      y -
							      block_y_offset,
							      itofix
							      (angle));
					plobj.oldx = (plobj.x);
					plobj.oldy = (plobj.y);
				}
			}
		}
	} if (!(map_parm.block[x][y] > 9 && map_parm.block[x][y] < 20)
	      && !(map_parm.block[x][y] == 21))
		load_masked_tile(tilebuf, tile_data[x][y]);
	blit(tilebuf, screen, 0, 0, block_x_offset, block_y_offset, 32,
	     32);
	dirty_block[x][y] = FALSE;	//This block isn't dirty anymore...
}


/* static update_animators:
 *
 * 	May I mention that this looks ugly. ;)
 */
static void update_animators(void)
{
	int n, x, y, oldframe;
	static int previous = -1;

#define anm animator[n]
	if (timer == previous)
		return;
	for (n = 0; n < 10; n++) {
		if (anm.frames > 0 && anm.clock <= 0) {
			anm.clock = anm.speed;
			oldframe = anm.cur_frame;

			//FORWARD
			if (anm.cur_frame + 1 < anm.frames)
				anm.cur_frame++;

			else
				anm.cur_frame = 0;
			for (x = 0; x < 20; x++) {
				for (y = 0; y < 15; y++) {
					if (tile_data[x][y] ==
					    anm.tile[oldframe]) {
						tile_data[x][y] =
						    anm.tile[anm.
							     cur_frame];
						dirty_block[x][y] = TRUE;
					}
				}
			}
		} else
			anm.clock--;
	}
	previous = timer;
}


/* M A I N *******************************************************************

    Function:    refresh_screen(void)

    Description: Redraws the screen
    Parameters:  none
    Return:      none

*****************************************************************************/
void refresh_screen()
{
	int x, y;
	update_animators();
	for (x = 0; x < 20; x++) {
		for (y = 0; y < 15; y++) {
			if (dirty_block[x][y])
				redraw_block(x, y);
		}
	}
	if (hurtcounter == 0)
		hurtcounter = 1;

	else
		hurtcounter = 0;
}
