/*
 *  Packdude game engine
 *  Copyright (C) 2003  Jaan Pullerits
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------
 * DOCUMENTATION MAIN FILE
 */

%section "Introduction"
%subsection "What is Packdude"
%text %{

Packdude is nothing more than just a game. Just a regular game like all other
games out there. In fact this is even a lame game, it is just a Pacman clone.
But at the same time, it has something that gives it much more power than any
Pacman clone has ever had. It is most powerful and sophisticated scripting
language. ;) That gives this game a great flexibility and allows you to build
extremely powerful and complicated adventures complete with different graphics,
animations sounds and music. If you like you can build the game as just regular
arcader or if you have more fantasy why not to back this thing up with
interesting and exciting story.<p>

Packdude is designed for people who want to create, but also for people who
enjoy cool two/player activity on their linux box. If you think you belong to
one of those two groups then I hope you enjoy my creation and if you find
something missing or something annoying, let me know.
%}

%subsection "How does it work"
%text %{
It uses quite different system from the normal games or even programs. Normal
programs usually come in one executable what does all the thing from reading the
configuration files to handling game logic. Packdude doesn't come in executable.
It comes in a library (packdudemodule.so) instead, what does the low level
functions and handles the general game logic. To get these things working one
needs a python script what calls functions from that library. Sounds scary and
complicated, doesn't it. In reality it's not so. The Python is really trivial
to learn, and I have made the functions to use really simple and basic. Here is
an example:
<pre>
	# This is a comment
	# Very simple missionpack file
	# 
	# Created by JP <jp@surnuaed.ee> on 24th Feb 2003
	# 
	# Bla bla bla
	
	from packdude import * 

	init_system()
	
	load_tileset("mygfx/winter.pcx")
	load_animators("mygfx/winter.anm")
	load_map("mymaps/test.map")
	
	game_main()
	
	shutdown_system()
</pre>
This is really simple example, in reality things are bit more complicated, you
might want to enable music and sounds, display images, menus and other neat
things. This thing only loads tileset, animations and map and starts the game.
If game finishes for some reason (user quits, lives run out or the level is
finished) the gamesystem is shut down (memory is freed, gfx modes are restored)
and program exits.
%}

%section "Important keys"

%subsection "Map editor"
%text %{
<ul>
<li>0 - Null tag
<li>1 - Player 1 start
<li>2 - Player 2 start
   
<li>T - Edit tag
<li>G - Get block
<li>P - Put block
   
<li>C - Clear map
   
<li>L - Load map
<li>S - Save map

<li>B - Background editor

<li>M - Toggle display mode (Tag/Tile/Background display)

<li>E - Tile editor

<li>F5 - Start game

<li>SPC - Select tile
<li>ENT - Toggle fullscreen/windowed mode. (I would be careful with this thing
if I were you. Allegro's X windowed stuff is worse than bad.) 

<li>LMB - Insert tile
<li>RMB - Clear block
</ul>
%}

%subsection "Graphics editor"

%text %{
<ul>
<li>G - Get tile
<li>P - Put tile

<li>F - Floodfill
<li>R - Replace color
<li>O - Outline tile

<li>V - Flip tile vertically
<li>H - Flip tile horizontally
   
<li>ARROWS - Translate tile

<li>C - Clear tile

<li>F3 - Edit palette

<li>S - Save tileset

<li>SPC - Select tile

<li>LMB - Insert pixel (select color, select tool)
<li>RMB - Get pixel (select color, select tool)
</ul>
%}
%subsection "Animator"
%text %{
<ul>
<li>SPC     - Add tile
<li>BACKSPC - Remove tile
   
<li>S       - Change speed
<li>(SFT)M  - Change mode
<li>(SFT)A  - Change animator
</ul>

<b>NOTE:</b> Animator is NOT yet complete. It works, but not really good.
   
%}
%subsection "Tile selector"
%text %{

<ul>
<li>ESC - Quit the tile selector without changing current tile
</ul>

NOTE: You can drag around tiles to displace them!
%}
%subsection "Game"
%text %{

<ul>
<li>Arrows  - Move 1st player
<li>A,S,D,W - Move 2nd player
<li>F12     - Do a screendump
</ul>

There might be other keys too...
%}

%section "Tag system"
%text %{
<ul>
<li>  000 - Usual non blocking cell
<li>  001 - Player 1 start position
<li>  002 - Player 2 start position

<li>  010 - Pickable objects (Points = (block - 10) * 10 + 10)
<li>  011 -    -"-
<li>  012 -    -"-
<li>  013 -    -"-
<li>  014 -    -"-
<li>  015 -    -"-
<li>  016 -    -"-
<li>  017 -    -"-
<li>  018 -    -"-
<li>  019 -    -"-

<li>  020 - Blocking cell (solid wall)
<li>  021 - Walk over the tile
<li>  022 - Enemy blocker (Enemies can't walk through this block)

<li>  030 - Death sector

<li>  040 - Teleporters
<li>  041 -    -"-
<li>  042 -    -"-
<li>  043 -    -"-
<li>  044 -    -"-
<li>  045 -    -"-
<li>  046 -    -"-
<li>  047 -    -"-
<li>  048 -    -"-
<li>  049 -    -"-                 

<li>  100 -- 199 = Enemies

<li>  253 - Run Python string (Enemies only)
<li>  254 - Run Python string (Players only)
<li>  255 - Run Python string
</ul>

NOTE: You don't need to pad numbers with zeros. I use it here only
cause it looks better that way...

%}
%subsection "The principle of enemies"
%text %{

<ol>
<li>First digit in enemy tag is 1 (as in 100). This shows the game that user
    wants to see the enemy there.
<li>Second digit represents enemy type. See table below.
<li>Third digit represents enemy tile offset. First tile in three tile sequence
    is calculated with following formula: digit * 3 + 6. In another words when
    the digit is 3 then first tile is 3 * 3 + 6 = 9. Other tiles used in the
    animation are then 10 and 11.
</ol>

As you see, you can use up to ten different looking enemies in one tileset.
This takes exactly 30 tiles. BUT, if you don't use so many enemies you can use
those tiles for whatever you like. Only three first enemy tiles are marked in
tile selector. This is cause it's quite normal that user wants to have atleast
three different enemies on the map. Ofcourse you can use more, but it's not
too common that anyone uses less, so only three are marked.<p>

Enemy looks and behaviour isn't any way connected. Enemy behaviour is modified
by second digit in tag. See table below. So you can have several same looking
creatures on map, behaving totally different, and several different looking
creatures behaving the same. ;)<p>

<b>NOTE:</b> Different enemy tiles don't have to be in a row. You can put any other
tiles in those places too in case you just don't use enemies with that tile
offset digit. For example, when you use tags like 1?3, 1?4, 1?5 for enemies,
you have other places free for other things.
%}

%subsection "Enemy types"
%text %{

 <b>Slow</b><p>
 
 0     = Confused wonderer (random)<br>
 1     = Commanded wonderer (left)<br>
 2     = Commanded wonderer (right)<br>
 3     = Manic chaser<br>
 4     = Guard (left - right)<br>
 5     = Guard (up - down)<br><br>
 
<b>Fast</b><p>

 6     = Confused wonderer (random)<br>
 7     = Commanded wonderer (left)<br>
 8     = Commanded wonderer (right)<br>
 9     = Manic chaser<br><br>

That's right, there is no fast guards. Sorry. :/<br><br>

EXAMPLE: Let's take an enemy tag 125. It will create an slow commanded
wonderer (2) with tiles 21, 22 and 23.
%}
%subsection "Run python string"
%text %{

Most powerful thing in the tag system is the set of RunPythonString tags. These
evaluate a short (32 byte) Pyhton string each time someone is discovered in that
sector. The 32 byte limit might sound rediculously small, but this is really all
you need. You can define the function itself in the game file, and later on call
only that function from the map file. Anyway it's not intelligent to write too
long scripts as they might take too long time to execute and may cause breakups
in the game.<p>

The string also may contain magic symbol '%i' three times. The first %i will be
replaced by the number of creature on the sector. Second with x coordinates of
the sector and third one with y coordinate. For example let's say creature
number 1 (what happens to be the number of second player) steps into the sector
at coordinates 10x, 13y. If the string for this sector is:<p>

<b><i>do_evil_stuff(%i, %i, %i)</b></i><p>

Then it will be passed to Python as:<p>

<b><i>do_evil_stuff(1, 10, 13)</b></i><p>

You can leave out some or all %i's if you want to, but you can't access
coordinates without also getting player number. If for example you need only the
y coordinate of the array, but none of the other things you still have to define
them in your function, but you just don't have to use them.<p>

NOTE: The function is evaluated every time something is found from that
sector. If a player or enemy is standing on the sector this function is called
on every logic update what kindof means 60 times in one second. ;) If this
behaviour is not desireable then you should use some sort of variable to make
sure that function won't be called several times, or even better set the
corresponding block tag to 0 with set_block().<p>

There also are timers, what can be useful to use timing events like restoring
the sector after some time or things like that. You can get more info about
stuff like that in the right section.
%}

%section "Important things to know"

%text %{
Tiles marked in tile selector are special. If your maps don't use certain 
number enemies then you are safe to use those tiles for something else.
Otherwise they will be used for enemy animation. Tile nr 255 is marked EMP,
it means "empty" and it should be always left that way. Game uses this tile
as empty tile. You can put some graphics to that slot, but it's not very
intelligent. Try it out, and see what happens. ;) Nothing to worry really,
as you know: *you can displace tiles with simple drag'n'drop in tile
selector. (SPACE)*<p>

You can check the block tags in maped by entering tag display mode by
pressing M. You can get back by pressing M again.<p>

Currently built in number of players (that includes players and enemies) is 20.
If you try to put more of those things on map the game will evilly crash. ;)
I still don't recommend you to put more than 10 enemies on map. It will make
the map fuzzy, and difficult to play, not to mention that many players make
game run slower.
%}

%section "Teleporters"
%text %{
To make a teleporter you just have to make two blocks with same tag from the 40
to 49. Teleporters don't yet work perfectly. When they are placed in the center
of field they might not work when entered from some positions if you create
a some sort of  hole for teleporter, it should work nicely. <p>                   

<pre>
###   # - Blocking cell (20)
#T    T - Teleporter
###
</pre>
%}

%section "Configuration"
%text %{
Packdude has powerful configuration system. And that both for players and
developers. This section explains some details of this sophisticated yet simple
to use system.<p>

The game has built in databases for storing integers and 32 character strings
what can be accessed with very simple functions. As there are two separate
databases there are two separate classes of functions for the thing, these are
functions beginning with 'cfg_' and others beginning with 'scfg_'. Only
difference between those two is that scfg_* functions work with string database
and cfg_* functions with integer database. As they are so similar of nature I am
going to explain only cfg_* functions to detail in this chapter.<p>

Every directive changes something in the game, for example if we give the
command cfg_set("gfx_fullscreen", 1) then the game runs on fullscreen.
(Which is default anyway) if we give cfg_set("gfx_fullscreen", 0) it
switches to windowed mode if possible. So you can see the functions are
pretty self explanatory. 0 is false and everything other than zero is true.
And the configuration strings make sense aswell. To get list of them use
included utility packdude-cfgls.<p>

<b>NOTE:</b> Right now (1.0.03) not all configuration strings are
working, and some are allready obsolete. I am working on this.

%}

%section "Knowng bugs"
%text %{
I have been writing this code for about a year now, and I started it when
my C skills were worse than bad. Strangely enough parts of this thing can even
be called bit less than elegant but still usable. But there are many bugs
also... Let's list few...

<ul>
<li> Collision detection is damn wrong. I looked the code and it looks so ugly
that I didn't have the guts to figure out how it works again. If I get more
energy some day, I will try again, or if you can come up with better one
<b>please</b> send me a patch.
<li> The timing mechanisms on some events are wrong. I should use the game
internal timers for those things, but I haven't had any time to figure those out
yet.
<li> Documentation is out of date and incomplete.
<li> Not all configuration strings are implemented.
<li> Engine specifications are not complete.

</ul>
%}

%section "FAQ"
%text %{

<b>Q:</b> I have seen you mentioning AS in many places, what that means?<br>
<b>A:</b> AS is acronym for Artificial Stupidity. ;)<br><br>

<b>Q:</b> Is Packdude game or library?<br>
<b>A:</b> I am afraid that it is still a game. It looks like a library or Pyton module,
   but in reality it is too highlevel to be a library. It is a game, but it 
   just uses different approach. Most programs create their own sophisticated
   interfaces with lots of buttons and bars. I just picked the Python as a
   interface, what leaves me a lot of energy to develop the game itself and
   gives much more power than buttons or scrollbars ever could.<br><br>

<b>Q:</b> I made a Python script that does some cool stuff when any creature
steps into one perticular sector, I wrote the function name to block callback
box but when I run the game... Nothing happens.<br>
<b>A:</b> It is very likely that you forgot to include parentheses. You wrote
  "my_function" instead of "my_function()". If this is not the case then there
  might be the same bug as with teleporters (see the fix in teleporters
  section).<p>

%}

/*
<b>Q:</b> <br>
<b>A:</b> <p>
*/

// vim:ft=text
