/*
 *  Packdude game engine
 *  Copyright (C) 2003  Jaan Pullerits
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------
 * PLAYER header file
 *
 *     Created on 11 June 2002
 *
 * This file contains all neccesary function protos,
 * variables and definition to deal with players.
 *
 */

#define MAX_PLAYERS 20		//Maximum players allowed

/* THE PLAYER OBJECT array */
typedef struct PLAYER {
	float x;
	float y;
	float oldx;
	float oldy;
	float speed;
	int startx;
	int starty;
	int type;
	int direction;
	int active;
	int lives;
	int frame;
	int framecount;
	int framedelay;
	int score;
	int hurt;
	BITMAP *tile[3];
} PLAYER;
PLAYER player[MAX_PLAYERS];
PALETTE cur_pal;
signed char fading_pal;

#define isvalid(number) if ((0 > (number) > MAX_PLAYERS) || !plobj.active) return 0;
#define plobj player[number]
#define pl1 player[0]
#define pl2 player[1]
#define in_sector(number) ((((int)player[(number)].x) % 32) == 0 && (((int)player[(number)].y) % 32) == 0)

#define PLAYER_FRAME_DELAY 3
#define FADE_STEP 5
#define HURT_TIME 500
int clear_player(int number);
int move_player(int number);
int can_move(int number);
void init_player(int x, int y, int number);
void fade_back(void);
void player_die(int number);
