/*
 *  Packdude game engine
 *  Copyright (C) 2003  Jaan Pullerits
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------
 * PLAYER routines
 *
 *    Created on 11 June 2002
 *
 * This file contains everything concerned to players.
 * It also means enemies.
 *
 */

#include <allegro.h>
#include <stdio.h>
#include "player.h"
#include "tileset.h"
#include "mapform.h"
#include "refresh.h"
#include "config.h"

/*************************
*                        *
* PLAYER DIRECTION TABLE *
*                        *
* 0 - Right    ^    ******
* 1 - Down     3    *
* 2 - Left   <2*0>  *
* 3 - Up       1    *
*              v    *
*                   *
********************/

void init_player(int x, int y, int number)
{

	plobj.x = x;
	plobj.y = y;
	plobj.oldx = x;
	plobj.oldy = y;

	plobj.startx = x;
	plobj.starty = y;

	plobj.active = TRUE;

	plobj.hurt = FALSE;

	plobj.speed = cfg_get("player_initial_speed");
	plobj.lives = cfg_get("player_initial_lives");

	for (x = 0; x < 3; x++) {
		plobj.tile[x] = create_bitmap(32, 32);
		load_tile(plobj.tile[x], x + number * 3);
	}

}

/*****************************************************************************

    Function:    int clear_player(int number)

    Description: Clears the player
    Parameters:  Number of the player
    Return:      FALSE on error, TRUE on success

*****************************************************************************/

int clear_player(int number)
{

	int x;

	isvalid(number);	//If number is valid!

	plobj.x = 0;
	plobj.y = 0;
	plobj.speed = 0;
	plobj.direction = 0;
	plobj.active = 0;
	plobj.lives = 0;
	plobj.frame = 0;
	plobj.framecount = 0;
	plobj.hurt = 0;
	plobj.score = 0;

	for (x = 0; x < 3; x++) {
		destroy_bitmap(plobj.tile[x]);
	}


	return TRUE;

}

/*****************************************************************************

    Function:    int can_move(int number)

    Description: Checks wether player can move or not
    Parameters:  Player number
    Return:      TRUE if player can move, FALSE otherwise

*****************************************************************************/

int can_move(int number)
{

	if (in_sector(number)) {

		int check_x = 0;
		int check_y = 0;

		if (plobj.direction == 0) {
			check_x = plobj.x + 31 + plobj.speed;
			check_y = plobj.y;
		}
		if (plobj.direction == 1) {
			check_x = plobj.x;
			check_y = plobj.y + 31 + plobj.speed;
		}
		if (plobj.direction == 2) {
			check_x = plobj.x - plobj.speed;
			check_y = plobj.y;
		}
		if (plobj.direction == 3) {
			check_x = plobj.x;
			check_y = plobj.y - plobj.speed;
		}

		check_x = M2S(check_x);
		check_y = M2S(check_y);

		if (check_x > 19 || check_y > 14 || check_y < 0
		    || check_x < 0)
			return FALSE;

		if (map_data[check_x][check_y] == 20)
			return FALSE;
		if (number > 1 && map_data[check_x][check_y] == 22)
			return FALSE;
		else
			return TRUE;
	}
	return TRUE;

}


/*****************************************************************************

    Function:    int move_player(int number)

    Description: Moves player to it's destiny
    Parameters:  Player number
    Return:      TRUE on success, FALSE on failiour

*****************************************************************************/

int move_player(int number)
{

	int n, x, y, touched = FALSE;

	char x1_offset;
	char x2_offset;

	char y1_offset;
	char y2_offset;


	isvalid(number);

	dirty_block[(int) (M2S((int) plobj.x))][(int) (M2S((int) plobj.y))]
	    = TRUE;
	dirty_block[(int) (M2S(((int) plobj.x + 31)))][(int)
						       (M2S
							(((int) plobj.y +
							  31)))] = TRUE;

	if (plobj.hurt)
		plobj.hurt--;

	if (number < 2) {	// If it's user controllable player

		for (n = 2; n < MAX_PLAYERS; n++) {
			// Check if they are in the same block
			if (player[n].active == TRUE) {
				if (((int) M2S((int) player[n].x) ==
				     M2S((int) plobj.x)
				     && (int) M2S((int) player[n].y) ==
				     M2S((int) plobj.y))
				    || ((int) M2S((int) player[n].x) ==
					M2S((int) plobj.x)
					&& (int) M2S((int) player[n].y +
						     31) ==
					M2S((int) plobj.y))
				    || ((int) M2S((int) player[n].x + 31)
					== M2S((int) plobj.x)
					&& (int) M2S((int) player[n].y) ==
					M2S((int) plobj.y))
				    ) {

					// FIXME:
					// This thing here is the collision detection system,
					// but it doesn't work perfectly. I have terrible
					// headache of thinking what is wrong with it. If
					// you can help then please, please and another please,
					// do it.

					x1_offset =
					    plobj.x -
					    (M2S((int) plobj.x) * 32) - 1;
					x2_offset =
					    player[n].x -
					    (M2S((int) player[n].x) * 32) -
					    1;

					y1_offset =
					    plobj.y -
					    (M2S((int) plobj.y) * 32) - 1;
					y2_offset =
					    player[n].y -
					    (M2S((int) player[n].y) * 32) -
					    1;

					for (x = 0; x < 32 && !touched;
					     x++) {
						for (y = 0;
						     y < 32 && !touched;
						     y++) {

							if (getpixel
							    (plobj.
							     tile[plobj.
								  frame],
							     x + x1_offset,
							     y +
							     y1_offset) > 0
							    &&
							    getpixel(player
								     [n].
								     tile
								     [player
								      [n].
								      frame],
								     x +
								     x2_offset,
								     y +
								     y2_offset)
							    > 0)
								touched =
								    TRUE;
						}
					}

					if (touched && !plobj.hurt
					    &&
					    cfg_get
					    ("player_die_if_enemy_collide"))
					{
						player_die(number);
					}
					//plobj.hurt = TRUE
				}
			}
		}
	}


	if (can_move(number)) {

		if (plobj.direction == 0)
			plobj.x += plobj.speed;
		if (plobj.direction == 1)
			plobj.y += plobj.speed;
		if (plobj.direction == 2)
			plobj.x -= plobj.speed;
		if (plobj.direction == 3)
			plobj.y -= plobj.speed;

		if (plobj.framedelay == PLAYER_FRAME_DELAY) {
			if (plobj.frame == 0)
				plobj.framecount = 0;
			else if (plobj.frame == 2)
				plobj.framecount = 1;

			if (plobj.framecount == 0)
				plobj.frame++;
			else
				plobj.frame--;
			plobj.framedelay = 0;
		} else
			plobj.framedelay++;

		dirty_block[(int) (M2S((int) plobj.x))][(int)
							(M2S
							 ((int) plobj.
							  y))] = TRUE;
		dirty_block[(int) (M2S(((int) plobj.x + 31)))][(int)
							       (M2S(((int)
								     plobj.
								     y +
								     31)))]
		    = TRUE;

		return TRUE;
	}
	return FALSE;
}

/******************************************************************************************

   fade_back() fades game palette back to pal from white_pal.

******************************************************************************************/

void fade_back(void)
{

#define FADE(col) if(cur_pal[x].col - FADE_STEP < pal[x].col) \
		cur_pal[x].col = pal[x].col; \
	else { \
		\
		cur_pal[x].col = cur_pal[x].col - FADE_STEP; \
		fading_pal = TRUE; \
		}

	int x;

	if (!fading_pal)
		return;

	fading_pal = FALSE;

	for (x = 0; x < 256; x++) {

		FADE(r);
		FADE(g);
		FADE(b);

	}

	set_palette(cur_pal);
}

/******************************************************************************************

   player_die(number) kills player, and sets up everything neccesary to make effects

******************************************************************************************/
void player_die(int number)
{

	int x;
	char tmp[256];

	if ((0 > (number) > MAX_PLAYERS) || !plobj.active)
		return;

	if (number < 2) {	// Players
		for (x = 0; x < 256; x++) {

			cur_pal[x].r = 63;
			cur_pal[x].g = 63;
			cur_pal[x].b = 63;
		}
		set_palette(cur_pal);
		fading_pal = TRUE;
	} else {

	}

	if (plobj.lives == 0)
		plobj.active = FALSE;
	else {
		plobj.x = plobj.startx;
		plobj.y = plobj.starty;
		plobj.lives--;
		plobj.hurt = HURT_TIME;
	}
	if (number < 2)
		sound_play(cfg_get("sample_player_die"));
	else
		sound_play(cfg_get("sample_enemy_die"));

	sprintf(tmp, scfg_get("call_player_die"), number);
	PyRun_SimpleString(tmp);
}
