/*
 *  Packdude game engine
 *  Copyright (C) 2003  Jaan Pullerits
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------
 * GAME CONFIGURATION
 *
 * 	Created by JP on 26th February 2003
 *
 */

#include <allegro.h>
#include <stdio.h>

// The config structure
static struct {
	char *key;
	int val;
} cfg[] = {
	/* *INDENT-OFF* */
	// Don't wanna GNU indent to screw up my beautiful format. ;)
	
	// GFX mode
	{"gfx_fullscreen", 1}, 
	{"gfx_display_copyright", 1},
	
	// Soundsystem
	{"sound_init", 1},
	{"sound_mixrate", 44100},
	{"sound_channels", 64}, {"sound_music", 1},
	{"sound_sfx", 1},
	{"sound_music", 1},
	{"sound_music_volume", 255},
	{"sound_sfx_volume", 255},
	
	// Samples
	{"sample_player_die", 0},
	{"sample_enemy_die", 1},
	{"sample_pick_item", 2},
	
	// Player
	{"player_initial_lives", 5},
	{"player_initial_speed", 2},
	{"player_die_if_enemy_collide", 1},
	
	// Game
	{"game_num_players", 1},
	
	// Timer
	{"timer_reset_on_game_start", 1},
	
	// SIC
	{"sic_exit_any_key", 0},
	{"sic_exit_esc", 0},
	
	// Null to terminate the array
	{NULL, 0}
	/* *INDENT-ON* */
};
static struct {
	char *key;
	char val[33];
} scfg[] = {
	/* *INDENT-OFF* */
	// Calls ------------------------
	{"call_player_enemy_collide", ""}, // TODO
	{"call_player_wall_collide", ""},  // TODO
	{"call_game_pause", ""},
	{"call_player_die", ""},
	
	// Null to terminate the array
	{NULL, 0}
	/* *INDENT-ON* */
};

/* 
 * Get variable from cfg array
 *
 */
int cfg_get(char *key)
{
	int i;

	for (i = 0;; i++) {
		if (cfg[i].key == NULL) {
			fprintf(stderr,
				"Requested key '%s' not found from cfg array.",
				key);
			return 0;
		}

		if (!strcmp(key, cfg[i].key))
			return (cfg[i].val);
	}
}

/*
 * Set variable in cfg array
 *
 */
int cfg_set(char *key, int val)
{
	int i;
	for (i = 0;; i++) {

		if (cfg[i].key == NULL) {
			fprintf(stderr,
				"Requested key '%s' not found from cfg array.",
				key);
			return 0;
		}

		if (!strcmp(key, cfg[i].key)) {
			cfg[i].val = val;
			return 1;
		}
	}
}

/* 
 * List cfg array
 *
 */
void cfg_ls(void)
{
	int i;

	for (i = 0;; i++) {

		if (cfg[i].key == NULL)
			break;

		fprintf(stderr, "%s = %i\n", cfg[i].key, cfg[i].val);
	}
}

/* 
 * Get variable from scfg array
 *
 */
char *scfg_get(char *key)
{
	int i;

	for (i = 0;; i++) {
		if (scfg[i].key == NULL) {
			fprintf(stderr,
				"Requested key '%s' not found from scfg array.",
				key);
			return 0;
		}

		if (!strcmp(key, scfg[i].key))
			return (scfg[i].val);
	}
}

/*
 * Set variable in scfg array
 *
 */
int scfg_set(char *key, char *val)
{
	int i;

	if (strlen(val) > 32) {
		fprintf(stderr,
			"Entry in scfg array may not be longer than 32 characters.");
		return 0;
	}

	for (i = 0;; i++) {

		if (scfg[i].key == NULL) {
			fprintf(stderr,
				"Requested key '%s' not found from scfg array.",
				key);
			return 0;
		}

		if (!strcmp(key, scfg[i].key)) {
			strcpy(scfg[i].val, val);
			return 1;
		}
	}
}

/* 
 * List scfg array
 *
 */
void scfg_ls(void)
{
	int i;

	for (i = 0;; i++) {

		if (scfg[i].key == NULL)
			break;

		fprintf(stderr, "%s = '%s'\n", scfg[i].key, scfg[i].val);
	}
}
