/*
 *  Packdude game engine
 *  Copyright (C) 2003  Jaan Pullerits
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------
 * 
 * PALETTE EDITOR made by JP on 27  April 2003
 * 
 */

#include <allegro.h>
#include <stdio.h>
#include "main.h"
#include "tileset.h"


BITMAP *tmp_buf;

#define PE_XOFFSET 300
#define PE_YOFFSET 200

/* get_tiles_using:
 * 
 * 	Checks how many tiles are using specified color
 */
static int get_tiles_using(int col){
	int c, x, y, count = 0, found;

	for(c = 0; c < 255; c++){
		load_tile(scrbuf, c);
		for(y = 0; y < 32 && !found; y++)
			for(x = 0; x < 32 && !found; x++){
				if(getpixel(scrbuf, x, y) == col){
					count++;
					found = 1;
				}
			}
		found = 0;
	}
	return count;
}

/* draw_color_bar:
 *
 * 	Redraws specified color bar.
 *
 * 	0 - red
 * 	1 - green
 * 	2 - blue
 */
static void draw_color_bar(int col, int amount)
{
	int offset = col * 12;

	scare_mouse();
		
	if(col == 0)
		col = 12;
	else if(col == 1)
		col = 10;
	else
		col = 9;
	
	rect(tmp_buf, 7, 7 + offset, 71, 16 + offset, 7);
	rectfill(tmp_buf, 8, 8 + offset, 7 + amount, 15 + offset, col);
	
	if (amount < 63)
		rectfill(tmp_buf, 8 + amount, 8 + offset, 70, 15 + offset, 0);

	unscare_mouse();
}


/* draw_tiles_used:
 *
 * 	Draws the number of tiles using the color
 */
static void draw_tiles_used(int col)
{
	textprintf(tmp_buf, font, 8, 144, 15, "%i", 
			get_tiles_using(col));
}


/* draw_color_sample:
 *
 * 	Draws the color sample
 */
void static draw_color_sample(int col)
{
	rect(tmp_buf, 7, 159, 72, 169, 7);
	rectfill(tmp_buf, 8, 160, 71, 168, col);	
}


/* draw_dialog:
 *
 * 	Redraws the entire dialog
 */
static void draw_dialog(int coln, RGB col)
{
	scare_mouse();
	
	// Box around the whole thing
	rect(tmp_buf, 0, 0, 80, 176, 7);

	// color bars
	draw_color_bar(0, col.r);
	draw_color_bar(1, col.g);
	draw_color_bar(2, col.b);

	// the used tileset counter
	draw_tiles_used(coln);

	// the sample
	draw_color_sample(coln);
	
	unscare_mouse();
}

/* do_pe_loop:
 *
 * 	The main palette editor loop with keyboard and mouse handlers
 */
int do_pe_loop(int coln, RGB col)
{
	int inkey, add, x, y;

#define ADD_COL(COL) \
	if(key[KEY_LCONTROL] || key[KEY_RCONTROL]) \
		add = add * 2; \
	if(col.COL + add < 64 && col.COL + add >= 0) \
		col.COL += add; \
	else if (add < 0) \
		col.COL = 0; \
	else \
		col.COL = 63;\
	pal[coln] = col;\
	set_palette(pal)
	
	while(1){	
		// Keyboard
		if(keypressed()){
			inkey = readkey();
		
			if(ISKEY(KEY_ENTER))
				return 1;
			else if(ISKEY(KEY_ESC))
				return 0;
			else if(ISKEY(KEY_R)){
				if(key[KEY_LSHIFT] || key[KEY_RSHIFT])
					add = -1;
				else
					add = 1;
				ADD_COL(r);
				draw_color_bar(0, col.r);
			}
			else if(ISKEY(KEY_G)){
				if(key[KEY_LSHIFT] || key[KEY_RSHIFT])
					add = -1;
				else
					add = 1;
				ADD_COL(g);
				draw_color_bar(1, col.g);
			}
			else if(ISKEY(KEY_B)){
				if(key[KEY_LSHIFT] || key[KEY_RSHIFT])
					add = -1;
				else
					add = 1;
				ADD_COL(b);
				draw_color_bar(2, col.b);
			}
			while(keypressed())
				clear_keybuf();
		}
		
		// Mouse
		x = mouse_x - PE_XOFFSET; y = mouse_y - PE_YOFFSET;

		if(mouse_b & 1)
			add = 1;
		else if(mouse_b & 2)
			add = -1;
		else 
			add = 0;

		//fprintf(stderr, "x = %i; y = %i; add = %i;\n\a", x, y, add);

		if(add != 0 && x > 8 && x < 72){

			if(y > 8 && y < 18){ // Red
				ADD_COL(r);
				draw_color_bar(0, col.r);
			}
			if(y > 20 && y < 30){ // Green
				ADD_COL(g);
				draw_color_bar(1, col.g);
			}
			if(y > 32 && y < 42){ // Blue
				ADD_COL(b);
				draw_color_bar(2, col.b);
			}
			add = 0;
			while(mouse_b & 2 || mouse_b & 1);
		}
		else if ((((mouse_x > 9 && mouse_x < 138) && 
				(mouse_y > 9 && mouse_y < 138)) ||
				((mouse_x > 9 && mouse_x < 139) &&
				(mouse_y > 148 && mouse_y < 276))) &&
				add) {
			scare_mouse();
			get_color(getpixel(screen, mouse_x, mouse_y), &col);
			unscare_mouse();
			pal[coln] = col; 
			set_palette(pal);
			// color bars
			draw_color_bar(0, col.r);
			draw_color_bar(1, col.g);
			draw_color_bar(2, col.b);
			while(mouse_b & 2 || mouse_b & 1);
		}
	}
}


/* edit_palette:
 *
 * 	Starts the palette editor on the color colnum.
 * 	Returns true if color was modified false otherwise
 */
int edit_palette(int colnum)
{

	RGB col;
	PALETTE tmp;
	int ret;
		
	// Check if it is modifiable color.
	// colors 1 - 15 and 255 are used by GUI and
	// it is just not wise to modify the color 0.
	if(colnum > 254 || colnum < 16){
		reperr("Colors 0 - 15 and 255 are not modifiable!");
		return 0;
	}

	tmp_buf = create_sub_bitmap(screen, PE_XOFFSET, PE_YOFFSET, 81, 177);
	col = pal[colnum];
	get_palette(tmp);

	draw_dialog(colnum, col);

	ret = do_pe_loop(colnum, col);
	
	destroy_bitmap(tmp_buf);

	if(!ret)
		set_palette(tmp);

	while(keypressed())
		clear_keybuf();

	return ret;
}
