/*
 *  Packdude game engine
 *  Copyright (C) 2003  Jaan Pullerits
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------
 * SWIG INTERFACE DEFINITION 
 */
%title   "Packdude v1.0.XX documentation"
%module packdude
%include embed.i
%style tabify
%{
#include <allegro.h>
#include "game.h"
#include "main.h"
#include "mapedit.h"
#include "mapform.h"
#include "config.h"
#include "timer.h"
#include "sic.h"
#include "animators.h"
#include "music.h"
#include "sound.h"
#undef main
%}

%include "readme.i"

%section "Library reference", pre
%text %{

These functions are those what you can call from your Python scripts
to design new missionpacks or even new games. Ofcourse you can use your
own functions or standard Python ones. These are those what control the
game, and set up the library functions.<p>

	from packdude import *
	
%}

// ----------------------------------------------------------------------------
// SYSTEM FUNCTIONS
// ----------------------------------------------------------------------------
%subsection "System functions"

int init_system();
/* CALL THIS THING FIRST!!! Initializes the system. */

int shutdown_system(void);
/* Shuts down the system. Last thing to do. */

// ----------------------------------------------------------------------------
// GAME FUNCTIONS
// ----------------------------------------------------------------------------
%subsection "Game functions"

int game_main(void);
/* Starts up the game
 *
 * returns:
 *   
 *   0 - User exit
 *   1 - Player die
 *   2 - Mission complete
 */

void player_die(int number);
/* Kills the player responding to number. */


// ----------------------------------------------------------------------------
// MAP FUNCTIONS
// ----------------------------------------------------------------------------
%subsection "Map functions"

int edit_map(void);
/* Enters the map editor */
int load_map(char *fname);
/* Loads map file pointed by fname
 *
 * Returns an integer by the following table:
 *
 *   0) OK (Map loaded/saved sucessfuly)
 *   1) Not valid map file
 *   2) Unsupported map version
 *   3) File not found or disk read/write error 
 */
int save_map(char *fname);
/* Saves map file to file pointed by fname. Error codes are same as in the
 * previous function. I doubt that this function really has any use here. ;)
 */
int block_set(int x, int y, int tag, int tile, char *cmd = "0");
/* Sets the block tag, tile and command pointed by x and y. If you want to
 * leave one of the things intact then pass negative interger to the tag. It
 * works for tile and tag, but for cmd you have to pass string containing 
 * zero. Zero as ASCII zero "0" (48) not zero code "\0" (0). If you pass zero
 * or empty string the block command will be set to empty string. Also you may
 * just omit the last parameter.
 *
 * Returns zero (and prints error message to stderr) on error and non-zero on
 * success. 
 */
int block_get_tile(int x, int y);
/* Gets block tile number.
 *
 * Returns tile number in range 0 to 255. If x or y coordinates are out of grid
 * the zero is also returned, but also error message is printed to stderr.
 */
int block_get_tag(int x, int y);
/*	Gets the block tag. Everything else is similar to block_get_tile() function.
 */
char *block_get_cmd(int x, int y);
/* Gets block command. On error returns empty string and prints error message to
 * stderr.
 */

// ----------------------------------------------------------------------------
// TILESET FUNCTIONS
// ----------------------------------------------------------------------------
%subsection "Tileset functions"

int load_tileset(char *fname);
/* Loads the tileset. Returns zero if it fails and non-zero if it succeeds. */

// ----------------------------------------------------------------------------
// ANIMATOR FUNCTIONS
// ----------------------------------------------------------------------------
%subsection "Animator functions"

int load_animators(char *filename);
/* Load animators.
 *
 * Return codes are the same as of the load_map() function.
 */

int save_animators(char *filename);
/* Save animators
 *
 * Return codes are the same as of save_map() function.
 */

// ----------------------------------------------------------------------------
// MUSIC FUNCTIONS
// ----------------------------------------------------------------------------
%subsection "Music functions"

%include "music.h"

// ----------------------------------------------------------------------------
// CONFIGURATION ARRAY FUNCTIONS
// ----------------------------------------------------------------------------
%subsection "Configuration array functions"
%include "config.h"

// ----------------------------------------------------------------------------
// TIMER FUNCTIONS
// ----------------------------------------------------------------------------
%subsection "Timer functions"

void clear_timers(void);
/* Clears all timers */

int  timer_add(int num, char *cmd, int time, int autoremove=0);
/* Add a new timer to the timer pool. You can add up to 32 timers to slots
 * from 0 to 31 (indicated by num). They run a command (32 character string)
 * after time in the "time" argument has elapsed. The time is given in ticks,
 * there is hundred ticks in one second. The optional autoremove argument shows
 * whether to remove the timer after the call has been made.
 *
 * Returns zero if the timer could not be set (reason is printed to stderr)
 * and non-zero if the insert was successful.
 * 
 * Timer functions are active only in game, and are paused while game is in
 * pause mode.
 */

int  timer_remove(int num);
/* Remove timer.
 *
 * Returns zero if timer is allready inactive and non-zero if the remove was
 * sucessful. Also returns zero if request for invalid timer slot was made, but
 * then there also will be error message sent to stderr.
 */

void timer_reset(void);
/* Reset all active timers
 *
 * This doesn't remove timers, it only restarts them.
 */

void timer_ls(void);
/* List currently active timers.
 *
 * Not very useful thing for anything really, but added for completness and some
 * debugging.
 *
 * Data is print to stdout.
 */

// ----------------------------------------------------------------------------
// SIMPLE INTERFACE CREATION FUNCTIONS
// ----------------------------------------------------------------------------
%subsection "Simple Interface Creation (SIC) functions"

%include "sic.h"

// ----------------------------------------------------------------------------
// SOUND SAMPLE FUNCTIONS
// ----------------------------------------------------------------------------
%subsection "Sound sample functions"

%include "sound.h"

// ----------------------------------------------------------------------------
// MISC FUNCTIONS
// ----------------------------------------------------------------------------
%subsection "Miscellaneous functions"

void add_datapath(char *path);
/* Add path where to find datafiles. Up to 16 paths can be defined by
 * multiple calls to this function.
 */

char *pd_f(char *path);
/* Find file on datafile search paths. All functions loading any data
 * should use this. For example load_music(pd_f("mymusic.xm"))
 */

char *pd_fw(char *path);
/* Find file on datafile search paths and make sure that the file is
 * writable. If it doesn't find any files by specified name then it
 * looks up first writable directory and gives path to nonexisting file in
 * this directory. Useful for saving files.
 */

int prompt(char *question);
/* Prompts the user for question and provides the dialog box with yes and no
 * aswers. Returns zero if user hits NO and non-zero otherwise.
 */

char *select_file(char *title, char *extension);
/* File selection dialog. Returns the filename selected or zero if user
 * pressed cancel. Note that internal buffer of this thing is 1024 byte
 * file paths longer than this will be truncated.
 */

int set_video(int depth);
/* Sets the video mode. This function is automagically called by all other
 * functions that need video mode change. But if you need to reset
 * fullscreen windowed mode for example then calling this function with
 * the same color depth as using is neccesary.
 */
	


// For documentation
%include "authors.i"
%section "Copyright"

%text %{
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.<p>

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.<p>

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA<p>
%}

// vim:ft=c
