/*
 *  Packdude game engine
 *  Copyright (C) 2003  Jaan Pullerits
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------
 * MUSIC routines
 * 	
 * 	Created by JP on 3rd March 2003
 */

int music_load(char *fname);
/* Load music file. Format may be one of those
 *
 *  - .MOD (protracker/fasttracker modules)
 *  - .S3M (screamtracker 3 modules)
 *  - .XM (fasttracker 2 modules)
 *  - .IT (impulse tracker modules)
 *  - .MID (MIDI files)
 *  - .RMI (MIDI files)
 *  - .SGT (DirectMusic segment files)
 *
 * Retuns zero on errror and non-zero on success
 */

void music_free(void);
/* Frees the music. You don't have to call it before loading another song, the
 * system does it for you */

int music_play(void);
/* Self commenting */

int music_stop(void);
/* Self commenting */

int music_order_get(void);
/* Self commenting */

int music_row_get(void);
/* Self commenting */

int music_order_set(int i);
/* Self commenting */

int music_pause(signed char i);
/* If you pass non zero to this function it will pause the music. Passing zero
 * will unpause it.
 */
