/*
 *  Packdude game engine
 *  Copyright (C) 2003  Jaan Pullerits
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------
 * MUSIC routines
 * 	
 * 	Created by JP on 3rd March 2003
 */

#include <stdio.h>
#include "fmod.h"
#include "music.h"
#include "config.h"

static FMUSIC_MODULE *mod;

/* music_load:
 *
 * 	Loads the music into memory
 */
int music_load(char *fname)
{
	music_free();
	
	if(!cfg_get("sound_music"))
		return 1;
	
	mod = FMUSIC_LoadSong(fname);
	if (mod == NULL) {
		fprintf(stderr, "Music (%s) load failed.\n", fname);
		return 0;
	}
	return 1;
}


/* music_free:
 *
 * 	frees the music
 */
void music_free(void)
{
	if (mod != NULL)
		FMUSIC_FreeSong(mod);
}


/* music_play:
 * 	Plays the music
 */
int music_play(void)
{
	if(!cfg_get("sound_music"))
		return 1;
	return FMUSIC_PlaySong(mod);
}


/* music_stop:
 * 	Stops the music
 */
int music_stop(void)
{
	return FMUSIC_StopSong(mod);
}


/* music_order_get:
 */
int music_order_get(void)
{
	return FMUSIC_GetOrder(mod);
}


/* music_row_get:
 */
int music_row_get(void)
{
	return FMUSIC_GetRow(mod);
}


/* music_order_set:
 */
int music_order_set(int i)
{
	return FMUSIC_SetOrder(mod, i);
}

/* music_pause:
 */
int music_pause(signed char i)
{
	return FMUSIC_SetPaused(mod, i);
}
