/*
 *  Packdude game engine
 *  Copyright (C) 2003  Jaan Pullerits
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------
 * MAPFORMAT header file
 *
 *  Created on 22 May 2002 by JP
 *
 */
int save_map(char *filename);
int load_map(char *filename);
int report_map_err(int code);
int block_set(int x, int y, int tag, int tile, char *cmd);
int block_get_tile(int x, int y);
int block_get_tag(int x, int y);
char *block_get_cmd(int x, int y);
typedef struct {
	unsigned char tile[20][15];	   // Tile data
	unsigned char bglayer[20][15];	// Background layer
	unsigned char block[20][15];	   // Map data
	unsigned char cmd[20][15][33];	// Commands
	unsigned char path[1025];	// Map fname
	unsigned char bg[5];	// Background colours
	unsigned char numbg;	// Number of background colours
} MAP_PARM;
MAP_PARM map_parm;
MAP_PARM temp_mparm;

#define map_data  map_parm.block
#define tile_data map_parm.tile
#define bg_data   map_parm.bglayer
#define map_path  map_parm.path
