/*
 *  Packdude game engine
 *  Copyright (C) 2003  Jaan Pullerits
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------
 * MAP EDITOR
 *
 *  Created 18 May 2002 by JP as main()
 *
 * Modified to edit_map() 19 May 2002 by JP
 *
 */

#include <allegro.h>
#include "tileset.h"
#include "mapform.h"
#include "game.h"
#include "graphed.h"
#include "background.h"
#include <ctype.h>
#include <stdio.h>
#include "main.h"
#include "animators.h"
BITMAP *image;
int static edit_mode = 0;
unsigned char static map_changed = 0;

/*****************************************************************************

    Function: clean_mapdata

    Description: Cleans up map arrays
    Parameters:  none
    Return:      none

*****************************************************************************/
void clean_mapdata()
{
	int x, y;
	for (x = 0; x < 20; x++) {
		for (y = 0; y < 15; y++) {
			tile_data[x][y] = (char) 255;
			bg_data[x][y]   = (char) 255;
			map_data[x][y]  = (char) 0;
			strcpy(map_parm.cmd[x][y], "");
		}
	}
}

/*****************************************************************************

    Function:    redraw_block(int x, int y);

    Description: Draws one block
    Parameters:  x and y coords of block
    Return:      none

*****************************************************************************/
void static redraw_block(int x, int y)
{
	int block_tag;
	int color;
	int cx, cy;
	
	scare_mouse();
	if (edit_mode == 0) {
		load_tile(image, tile_data[x][y]);
		blit(image, screen, 0, 0, x * 32, y * 32, 32, 32);
		if (tile_data[x][y] == 255)
			rect(screen, x * 32, y * 32, x * 32 + 31,
			     y * 32 + 31, 8);
	} else if (edit_mode == 1) {
		block_tag = (int) map_data[x][y];
		// SYNTAX Highlighting ;)
		color = 0;
		if (block_tag == 20)
			color = 7;	// Blocking cell
		if (block_tag == 1)
			color = 14;	// Player 1      
		if (block_tag == 2)
			color = 10;	// Player 2      
		if (block_tag == 30)
			color = 4;	// Death
		if (block_tag > 39 && block_tag < 50)
			color = 1;	// Teleporter
		if (block_tag > 9 && block_tag < 20)
			color = 11;	// Pickable thingy
		if (block_tag >= 100 && block_tag <= 199)
			color = 5;	// Enemy
		if (block_tag == 21)
			color = 6;	// Walkover
		if (block_tag == 22)
			color = 8;	// Enemy blocker
		if (block_tag >= 253)
			color = 13;	// Run command
		rectfill(screen, x * 32 + 1, y * 32 + 1, x * 32 + 30,
			 y * 32 + 30, color);
		rect(screen, x * 32, y * 32, x * 32 + 31, y * 32 + 31, 8);
		textprintf(screen, font, x * 32 + 1, y * 32 + 1,	// Block tag
			   7, "%i", block_tag);
	} else {
		load_tile(image, bg_data[x][y]);
		blit(image, screen, 0, 0, x * 32, y * 32, 32, 32);
		load_tile(image, tile_data[x][y]);
		for(cy = 0; cy < 32; cy++)
			for(cx = 0; cx < 32; cx++){
				if((cx + cy) % 2)
					putpixel(image, cx, cy, 0);
			}
		masked_blit(image, screen, 0, 0, x * 32, y * 32, 32, 32);
		if (bg_data[x][y] == 255)
			rect(screen, x * 32, y * 32, x * 32 + 31,
			     y * 32 + 31, 4);
	}
	unscare_mouse();
}


/*****************************************************************************

    Function:    redraw_screen()

    Description: Redraws the whole screen
    Parameters:  none
    Return:      none

*****************************************************************************/
void static redraw_screen()
{
	int x, y;
	clear_bitmap(screen);
	for (x = 0; x < 20; x++) {
		for (y = 0; y < 15; y++) {
			redraw_block(x, y);
		}
	}
}


/*****************************************************************************

    Function:    insert_block(int x, int y)

    Description: Inserts tile to tile_data and 20 to map_data at specified
                 location.
    Parameters:  x and y coords of block
    Return:      none

*****************************************************************************/
void insert_block(int x, int y)
{
	if (x > 19)
		x = 19;
	if (x < 0)
		x = 0;
	if (y > 14)
		y = 14;
	if (y < 0)
		y = 0;
	if(edit_mode == 2){
		bg_data[x][y] = current_tile;
	} else {
		tile_data[x][y] = current_tile;
		if (map_data[x][y] == 0)
			map_data[x][y] = (char) 20;
	}
		redraw_block(x, y);

	map_changed = TRUE;
}

/*****************************************************************************

    Function:    clear_block(int x, int y);

    Description: Sets tile_data to 255 and map_data to 0 at specified coords
    Parameters:  x and y coords of block
    Return:      none

*****************************************************************************/
void static clear_block(int x, int y)
{
	if(edit_mode == 2){
		bg_data[x][y] = (char) 255;
	} else {
		map_data[x][y] = (char) 0;
		tile_data[x][y] = (char) 255;
	}
	redraw_block(x, y);
	map_changed = TRUE;
}

/*****************************************************************************

    Function:    edit_tag(int x, int y)

    Description: Prompts user for new block tag
    Parameters:  x and y pos of block
    Return:      none
    
*****************************************************************************/
static void edit_tag(int x, int y)
{
	char tag[4] = "";
	char cmd[33] = "";
	int new_tag;
	// GNU indent rocks, doesn't it ;)
	DIALOG the_dialog[] = {
		{
		 d_box_proc, 0, 0, 110, 60, 255, 0, 0, 0, 0, 0,
		 NULL, NULL, NULL}, {
				     d_edit_proc, 10, 20, 89, 8, 0, 255, 0,
				     0, 3, 0,
				     tag, NULL, NULL}, {
							d_button_proc, 10,
							30, 90, 10, 255, 0,
							13, D_EXIT,
							0, 0, "OK", NULL,
							NULL}, {
								d_button_proc,
								10, 40, 90,
								10, 255, 0,
								27, D_EXIT,
								0, 0,
								"Cancel",
								NULL,
								NULL}, {
									NULL,
									0,
									0,
									0,
									0,
									0,
									0,
									0,
									0,
									0,
									0,
									NULL,
									NULL,
									NULL}
	};
	DIALOG the_second_dialog[] = {

		/* (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)  (d1) (d2)  (dp)       (dp2) (dp3) */
		{
		 d_box_proc, 0, 0, 110, 60, 255, 0, 0, 0, 0, 0,
		 NULL, NULL, NULL}, {
				     d_edit_proc, 10, 20, 89, 8, 0, 255, 0,
				     0, 33, 0,
				     cmd, NULL, NULL}, {
							d_button_proc, 10,
							30, 90, 10, 255, 0,
							13, D_EXIT,
							0, 0, "OK", NULL,
							NULL}, {
								NULL, 0, 0,
								0, 0, 0, 0,
								0, 0, 0, 0,
								NULL, NULL,
								NULL}
	};
	sprintf(tag, "%i", (int) map_data[x][y]);
	strcpy(cmd, map_parm.cmd[x][y]);
	centre_dialog(the_dialog);
	centre_dialog(the_second_dialog);
	if (popup_dialog(the_dialog, 1) == 2) {
		new_tag = (int) atol(tag);
		if (new_tag > 255 || new_tag < 0)
			new_tag = 0;
		map_data[x][y] = (char) new_tag;
		if (new_tag >= 253) {
			popup_dialog(the_second_dialog, 1);
			strcpy(map_parm.cmd[x][y], cmd);
		}
		redraw_block(x, y);
		map_changed = 1;
	}
}


/*****************************************************************************

    Function: change_block_tag(int x, y, tag)

    Description: Changes block tag
    Parameters:  X and Y coords of block and the new tag
    Return:      none

*****************************************************************************/
void static change_block_tag(int x, int y, int tag)
{
	if (tag < 0 || tag > 255)
		return;
	map_data[x][y] = (char) tag;
	redraw_block(x, y);
	map_changed = TRUE;
}

/* M A I N ******************************************************************
    Function:    int edit_map(void)

    Description: Map editor main function
    Parameters:  Map file to open
    Return:

*****************************************************************************/
int edit_map(void)
{
	signed char aborted = FALSE;
	int inkey, cpt_buf = 0, cpti_buf = 0, ecpt_buf = 0, ecpti_buf = 0;
	char *tfn;
	
	if (cur_depth != 8)
		set_video(8);
	map_path[0] = 0;
	image = tilebuf;
	show_mouse(screen);
	redraw_screen();
	
	while (!aborted) {

    /*-- KEYBOARD HANDLER --*/
		if (keypressed()) {
			inkey = readkey();
			if (ISKEY(KEY_ESC)) {
				if (map_changed) {
					if (prompt
					    ("Map not saved! Really quit?"))
						aborted = TRUE;
				} else {
					aborted = TRUE;
				}
			}

			else if (ISKEY(KEY_SPACE)) {
				select_tile(image);
				redraw_screen();
				while (mouse_b & 1 || mouse_b & 2);
			}

			else if (ISKEY(KEY_E)) {
				edit_graphics();
				redraw_screen();
			}

			else if (ISKEY(KEY_S)) {
				clear_keybuf();
				
				// Look directory to save
				tfn = get_filename(map_path);
				strcpy(map_path, pd_fw(tfn));
				
				if (file_select_ex
				    ("Save map", map_path, "MAP", 1024, 0,
				     0)) {
					report_map_err(save_map(map_path));
					map_changed = FALSE;
				}

			}

			else if (ISKEY(KEY_L)) {
				if (file_select_ex
				    ("Load map", map_path, "MAP", 1024, 0,
				     0)) {
					report_map_err(load_map(map_path));
					map_changed = FALSE;
					redraw_screen();
				}
			}

			else if (ISKEY(KEY_C)) {
				if (prompt("Clear map?")) {
					clean_mapdata();
					redraw_screen();
				}
			}

			else if (ISKEY(KEY_M)) {
				if(key[KEY_LSHIFT] || key[KEY_RSHIFT]){
					if (edit_mode > 0)
						edit_mode--;	// Mode switch
					else
						edit_mode = 2;
				} else {
					if (edit_mode < 2)
						edit_mode++;	// Mode switch
					else
						edit_mode = 0;
				}
				redraw_screen();	
			}

			else if (ISKEY(KEY_T)) {
				edit_tag(M2S(mouse_x), M2S(mouse_y));
			}

			else if (ISKEY(KEY_ENTER)) {	// Toggle fullscreen

				if (cfg_get("gfx_fullscreen"))
					cfg_set("gfx_fullscreen", 0);
				else
					cfg_set("gfx_fullscreen", 1);

				set_video(8);
				show_mouse(screen);
				redraw_screen();
			}

			else if (ISKEY(KEY_0)) {	// Null block
				change_block_tag(M2S(mouse_x),
						 M2S(mouse_y), 0);
			}

			else if (ISKEY(KEY_1)) {	// Player 1 start position
				change_block_tag(M2S(mouse_x),
						 M2S(mouse_y), 1);
			}

			else if (ISKEY(KEY_2)) {	// Player 2 start position
				change_block_tag(M2S(mouse_x),
						 M2S(mouse_y), 2);
			}

			else if (ISKEY(KEY_3)) {	// Enemy start position
				change_block_tag(M2S(mouse_x),
						 M2S(mouse_y), 3);
			}

			else if (ISKEY(KEY_G)) {
				if (key[KEY_LSHIFT] || key[KEY_RSHIFT])
					cpt_buf = map_parm.block[M2S(mouse_x)][M2S(mouse_y)];	// Copy tag
				else if (key[KEY_LCONTROL]
					 || key[KEY_RCONTROL])
					cpti_buf = map_parm.tile[M2S(mouse_x)][M2S(mouse_y)];	// Copy tile
				else {
					ecpt_buf = map_parm.block[M2S(mouse_x)][M2S(mouse_y)];	// Copy tag
					ecpti_buf = map_parm.tile[M2S(mouse_x)][M2S(mouse_y)];	// Copy tile
				}
				redraw_block(M2S(mouse_x), M2S(mouse_y));
			}

			else if (ISKEY(KEY_P)) {
				if (key[KEY_LSHIFT] || key[KEY_RSHIFT])
					map_parm.block[M2S(mouse_x)][M2S(mouse_y)] = cpt_buf;	// Copy tag
				else if (key[KEY_LCONTROL]
					 || key[KEY_RCONTROL])
					map_parm.tile[M2S(mouse_x)][M2S(mouse_y)] = cpti_buf;	// Copy tile
				else {
					map_parm.block[M2S(mouse_x)][M2S(mouse_y)] = ecpt_buf;	// Copy tag
					map_parm.tile[M2S(mouse_x)][M2S(mouse_y)] = ecpti_buf;	// Copy tile
				}
				redraw_block(M2S(mouse_x), M2S(mouse_y));
			}

			else if (ISKEY(KEY_B)) {
				edit_background();
				redraw_screen();
			}

			else if (ISKEY(KEY_F5)) {	// Play game!!!
				if (map_changed) {
					if (prompt
					    ("Map not saved! Really play?"))
					{
						show_mouse(0);
						game_main();
						clear_keybuf();
						show_mouse(screen);
						redraw_screen();
					}
				} else {
					show_mouse(0);
					game_main();
					show_mouse(screen);
					redraw_screen();
				}
			} else if (ISKEY(KEY_A)) {
				edit_animation();
				redraw_screen();
			}
		}

    /*-- KEYBOARD HANDLER --*/
		if (mouse_b & 1) {
			insert_block(M2S(mouse_x), M2S(mouse_y));
		} else if (mouse_b & 2) {
			clear_block(M2S(mouse_x), M2S(mouse_y));
		}
	}
	show_mouse(0);
	return 0;
}
