/*
 *  Packdude game engine
 *  Copyright (C) 2003  Jaan Pullerits
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------
 * MAIN FUNCTIONS
 *
 *  Created on 19 May 2002 by JP
 *
 */

#define DEBUGMODE 1

#include <allegro.h>		// Allegro headers
#include <string.h>		// String functions header file
#include <stdio.h>		// STD io
#include <stdlib.h>		// STD lib
#include <unistd.h>     // for getuid
#include "game.h"	   	// Game header
#include "mapform.h"		// Mapformat header file
#include "mapedit.h"		// Mapeditor header file
#include "refresh.h"		// Game screen refreshing header
#include "mapedit.h"		// Mapeditor header
#include "graphed.h"		// Graphics editor header
#include "tileset.h"		// Tileset header
#include "jpgalleg.h"		// JPEG loader
#include "animators.h"		// Animators
#include "main.h"		// Main headers
#include "Python.h"		// Python headers
#include "copyleft.h"		// Copyright notice
#include "fmod.h"		// FMOD library


void sic_low_clear(void);


/***
 * Add datapath
 */
void add_datapath(char *path){
	
	int i;
	
	if(strlen(path) > 240){
		fprintf(stderr, "Path %s is longer than 240 characters, not nice.\n",
				path);
		return;
	}

	if(ndp == 16)
		return;
	
	strcpy(datapaths[ndp], path);
	ndp++;
	
	return;
}


/***
 * Find file somewhere on the datahpaths
 */
char *pd_f(char const *path)
{
	int i;
	char tmp[1024];
	
	if(strlen(path) > 128){
		fprintf(stderr, "Path %s is longer than 128 characters, not nice.\n",
				path);
		return;
	}
	
	strcpy(txtbuf, "/");
	strcat(txtbuf, path);
	strcpy(tmp, txtbuf);
	
	for(i = 0; i < ndp; i++){
		
		if(datapaths[i] == 0)
			break;
	
		if(strlen(tmp) + strlen(datapaths[i]) > 255){
			fprintf(stderr, "Path %s%s is longer than 255 characters, not nice.\n",
					tmp, datapaths[i]);
			return;
		}
		
		strcpy(txtbuf, datapaths[i]);
		strcat(txtbuf, tmp);
		if(file_exists(txtbuf, FA_RDONLY | FA_HIDDEN, NULL))
			return txtbuf;

	}
	return NULL;
}

/***
 * Find file somewhere on datapaths.
 * Make sure that file is writable.
 */
char *pd_fw(char const *path)
{
	int i;
	char tmp[1024];

	if(strlen(path) > 128){
		fprintf(stderr, "Path %s is longer than 128 characters, not nice.\n",
				path);
		return;
	}

	strcpy(txtbuf, "/");
	strcat(txtbuf, path);
	strcpy(tmp, txtbuf);
	
	for(i = 0; i < ndp; i++){

		if(datapaths[i] == 0)
			break;
		
		if(strlen(tmp) + strlen(datapaths[i]) > 255){
			fprintf(stderr, "Path %s%s is longer than 255 characters, not nice.\n",
					tmp, datapaths[i]);
			return;
		}
		
		strcpy(txtbuf, datapaths[i]);
		strcat(txtbuf, tmp);
		if(file_exists(txtbuf, FA_HIDDEN, NULL))
			return txtbuf;
		
	}

	for(i = 0; i < 16; i++){

		if(datapaths[i] == 0)
			break;
		
		strcpy(txtbuf, datapaths[i]);
		
		if(file_exists(txtbuf, FA_HIDDEN | FA_DIREC, NULL)){
			strcat(txtbuf, tmp);
			return txtbuf;
		}
	}
	
	return NULL;
}


/*
 * FILE selection dialog
 *
 */
char *select_file(char *title, char *extension)
{

	strcpy(txtbuf, "");

	if (file_select_ex(title, txtbuf, extension, 1024, 0, 0))
		return txtbuf;
	else
		return 0;
}


/*
 * Display copyright notice
 *
 */
void static display_copyright(void)
{
	int y, i, c, col = 8, glitch = 0;

	*txtbuf = 0;

	clear_bitmap(scrbuf);

	text_mode(-1);

      draw:
	y = 180;
	c = 0;
	hline(scrbuf, 4 + glitch, y - 2 + glitch, 634 + glitch, col);
	for (i = 0; 1; i++) {
		if (*(copyleft + i) == 10) {
			*(txtbuf + c) = 0;
			textout_centre(scrbuf, font, txtbuf, 320 + glitch,
				       y + glitch, col);
			c = 0;
			y += 8;
		} else if (*(copyleft + i) == 0)
			break;
		else {
			*(txtbuf + c) = *(copyleft + i);
			c++;
		}
	}
	hline(scrbuf, 4 + glitch, y + 10 + glitch, 634 + glitch, col);
	if (col == 8) {
		glitch = -3;
		col = 15;
		goto draw;
	}

	text_mode(0);

	fade_out(63);
	bltscr(scrbuf);
	fade_in(pal, 10);

	clear_keybuf();
	while (!keypressed());
	clear_keybuf();

	fade_out(10);
	clear_bitmap(screen);
	fade_in(pal, 64);
}

/*****************************************************************************

    Function:    reperr(char *msg)

    Description: Reports error message
    Parameters:  none
    Return:      none

*****************************************************************************/

void reperr(char *msg)
{

	alert("ERROR", NULL, msg, "OK", NULL, KEY_ENTER, 0);

}

/*****************************************************************************

    Function:    repwarn(char *msg)

    Description: Reports warning message
    Parameters:  message
    Return:      none

*****************************************************************************/

void repwarn(char *msg)
{

	alert("WARNING", NULL, msg, "OK", NULL, KEY_ENTER, 0);

}

int main(int argc, char *argv[])
{
	return 21;
}
END_OF_MAIN()

/*****************************************************************************

    Function: int prompt(char *question);

    Description: Displays the question and goes to query loop
    Parameters:  question
    Return:      When user presses OK return TRUE, if Cancel then FALSE

*****************************************************************************/

int prompt(char *question)
{

	if (alert(question, NULL, NULL, "OK", "Cancel", KEY_ENTER, KEY_ESC)
	    == 2)
		return FALSE;
	else
		return TRUE;

}

void *_mangled_main_address;

/* set_video:
 * 
 * 	Set's up the video mode and keeps the screen buffer up
 * 	to date with color depth changes
 */

int set_video(int depth)
{
	int card;

	if (depth == 0) {	// Called only by shutdown_system()
		fprintf(stdout, "Exiting video mode...\n", depth);

		return 1;
	}
	fprintf(stdout, "Initializing 640x480x%i...\n", depth);

	set_color_depth(depth);

	if (cfg_get("gfx_fullscreen"))
		card = GFX_AUTODETECT;
	else
		card = GFX_AUTODETECT_WINDOWED;

	remove_mouse();
	remove_keyboard();

	if (set_gfx_mode(card, 640, 480, 0, 0)) {
		fprintf(stderr, "Failed initializing 640x480x%i: %s\n",
			depth, allegro_error);
		return 0;
	}

	install_keyboard();
	install_mouse();
	clear_keybuf();

	if(depth == 8)
		set_palette(pal);
	
	if (cur_depth == depth)
		return 1;

	cur_depth = depth;

	if (scrbuf)
		destroy_bitmap(scrbuf);
	scrbuf = create_bitmap_ex(depth, 640, 480);

	return 1;
}


int init_system()
{

	int x;
	FILE *fp;

#ifdef ALLEGRO_UNIX // Packdude isn't the safest proggy around. ;)
	if(!getuid()){
		fprintf(stderr, "Dude, are you suicidal or what?!?\n");
		exit(1);
	}
#endif

	// Malloc text buffer
	txtbuf = (char *) malloc(1025);

	// Init allegro stuff
	allegro_init();
	install_mouse();
	install_keyboard();

	for(x = 0; x < 256; x++){
		pal[x].r = default_palette[x].r;
		pal[x].g = default_palette[x].g;
		pal[x].b = default_palette[x].b;
	}

	set_color_conversion(COLORCONV_NONE);	// No color conversion

	//register_bitmap_file_type("jpg", &load_jpg, 0);

	if (!set_video(8))
		return 0;

	if (cfg_get("sound_init"))
		FSOUND_Init(cfg_get("sound_mixrate"),
			    cfg_get("sound_channels"), 0);

	get_palette(pal);	// Copyright notice needs it

	// Create tile buffer
	tilebuf = create_bitmap(32, 32);

	// Clear some crap-----------------------------
	// Clear animator LUT
	clear_animators();

	// Clear animator refresh specific variables
	for (x = 0; x < 10; x++) {
		animator[x].cur_frame = 0;
	}

	// Clear map structure
	clean_mapdata();
	// Clear sic data
	sic_low_clear();

	ndp = 0;

	// Clear timers
	timer = 0;
	clear_timers();
	init_tileset();

	set_window_title("PackDude");

	if (cfg_get("gfx_display_copyright"))
		display_copyright();

	return 1;
}

int shutdown_system()
{

	remove_tileset();
	set_video(0);

	FSOUND_Close();

	// Free buffers
	free(txtbuf);
	destroy_bitmap(tilebuf);
	destroy_bitmap(scrbuf);

	return 0;
}
